/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.dictionary;

import com.intellij.internal.statistic.eventLog.dictionary.Dictionary;
import com.intellij.internal.statistic.eventLog.dictionary.FixedSizedBlockDictionary;
import com.jetbrains.fus.reporting.FileHandle;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 #2\u00020\u0001:\u0001#B-\b\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0016J\u0011\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0003H\u0082\u0002J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0014H\u0002J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000bR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Lcom/intellij/internal/statistic/eventLog/dictionary/FixedSizedBlockDictionary;", "Lcom/intellij/internal/statistic/eventLog/dictionary/Dictionary;", "blockSize", "", "length", "version", "", "file", "Lcom/jetbrains/fus/reporting/FileHandle;", "(IILjava/lang/String;Lcom/jetbrains/fus/reporting/FileHandle;)V", "getBlockSize", "()I", "getFile", "()Lcom/jetbrains/fus/reporting/FileHandle;", "getLength", "setLength", "(I)V", "numberOfEntries", "getNumberOfEntries", "searchBuffer", "", "searchValueBuffer", "getVersion", "()Ljava/lang/String;", "close", "", "contains", "", "value", "get", "index", "padValue", "bytes", "readBufferFromMemoryMappedFile", "offset", "Companion", "ap-validation"})
public final class FixedSizedBlockDictionary
implements Dictionary {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int blockSize;
    private int length;
    @NotNull
    private final String version;
    @NotNull
    private final FileHandle file;
    @NotNull
    private final byte[] searchBuffer;
    @NotNull
    private final byte[] searchValueBuffer;
    private final int numberOfEntries;

    private FixedSizedBlockDictionary(int blockSize, int length, String version, FileHandle file) {
        this.blockSize = blockSize;
        this.length = length;
        this.version = version;
        this.file = file;
        this.searchBuffer = new byte[this.blockSize];
        this.searchValueBuffer = new byte[this.blockSize];
        this.numberOfEntries = this.length / this.blockSize;
    }

    /* synthetic */ FixedSizedBlockDictionary(int n, int n2, String string2, FileHandle fileHandle, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 128;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        if ((n3 & 4) != 0) {
            string2 = "1";
        }
        this(n, n2, string2, fileHandle);
    }

    public final int getBlockSize() {
        return this.blockSize;
    }

    public final int getLength() {
        return this.length;
    }

    public final void setLength(int n) {
        this.length = n;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final FileHandle getFile() {
        return this.file;
    }

    public final int getNumberOfEntries() {
        return this.numberOfEntries;
    }

    private final byte[] padValue(byte[] bytes) {
        if (bytes.length > this.blockSize - 1) {
            throw new IllegalArgumentException("value " + new String(bytes, Charsets.UTF_8) + " is longer than block size " + this.blockSize);
        }
        ArraysKt.copyInto((byte[])bytes, (byte[])this.searchValueBuffer, (int)0, (int)0, (int)bytes.length);
        int n = this.blockSize - 1;
        for (int i2 = bytes.length; i2 < n; ++i2) {
            this.searchValueBuffer[i2] = 32;
        }
        this.searchValueBuffer[this.blockSize - 1] = 10;
        return this.searchValueBuffer;
    }

    private final byte[] padValue(String value) {
        String string2 = value;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return this.padValue(byArray);
    }

    private final byte[] get(int index) {
        if (index >= this.numberOfEntries) {
            throw new IndexOutOfBoundsException(index + " is greater than number of entries " + this.numberOfEntries);
        }
        int offset = index * this.blockSize;
        this.readBufferFromMemoryMappedFile(offset);
        return this.searchBuffer;
    }

    private final byte[] readBufferFromMemoryMappedFile(int offset) {
        return this.file.read(offset, this.searchBuffer);
    }

    @Override
    public synchronized boolean contains(@NotNull String value) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int low = 0;
        int high = this.numberOfEntries - 1;
        try {
            byArray = this.padValue(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        byte[] paddedValue = byArray;
        while (low <= high) {
            int mid = low + high >>> 1;
            byte[] midValue = this.get(mid);
            int compareResult = FixedSizedBlockDictionary.Companion.compareTo(midValue, paddedValue);
            if (compareResult == 0) {
                return true;
            }
            if (compareResult < 0) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return false;
    }

    @Override
    public synchronized void close() {
        this.file.close();
    }

    public /* synthetic */ FixedSizedBlockDictionary(int blockSize, int length, String version, FileHandle file, DefaultConstructorMarker $constructor_marker) {
        this(blockSize, length, version, file);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\u0010\u001a\u00020\t*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/internal/statistic/eventLog/dictionary/FixedSizedBlockDictionary$Companion;", "", "()V", "createFile", "Lcom/intellij/internal/statistic/eventLog/dictionary/FixedSizedBlockDictionary;", "values", "", "", "blockSize", "", "version", "file", "Lcom/jetbrains/fus/reporting/FileHandle;", "fromJson", "metadataJson", "openRandomAccessFile", "compareTo", "", "other", "ap-validation"})
    @SourceDebugExtension(value={"SMAP\nFixedSizedBlockDictionary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixedSizedBlockDictionary.kt\ncom/intellij/internal/statistic/eventLog/dictionary/FixedSizedBlockDictionary$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n1549#2:142\n1620#2,3:143\n1855#2,2:146\n*S KotlinDebug\n*F\n+ 1 FixedSizedBlockDictionary.kt\ncom/intellij/internal/statistic/eventLog/dictionary/FixedSizedBlockDictionary$Companion\n*L\n60#1:142\n60#1:143,3\n62#1:146,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FixedSizedBlockDictionary openRandomAccessFile(@NotNull FileHandle file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (file.length() == 0L) {
                throw new FileNotFoundException("File is empty");
            }
            long length = file.length();
            String metadataJson = Dictionary.Companion.readLastLine(file, (int)length);
            FixedSizedBlockDictionary fixedSizeBlockFileList = this.fromJson(metadataJson, file);
            return fixedSizeBlockFileList;
        }

        private final FixedSizedBlockDictionary fromJson(String metadataJson, FileHandle file) {
            Triple<Integer, Integer, String> metadata = Dictionary.Companion.parseDictionaryMetadata(metadataJson);
            return new FixedSizedBlockDictionary(((Number)metadata.getFirst()).intValue(), ((Number)metadata.getSecond()).intValue(), (String)metadata.getThird(), file, null);
        }

        private final int compareTo(byte[] $this$compareTo, byte[] other) {
            int n = Math.min($this$compareTo.length, other.length);
            for (int i2 = 0; i2 < n; ++i2) {
                byte byte1 = $this$compareTo[i2];
                byte byte2 = other[i2];
                if (byte1 == byte2) continue;
                return (byte1 & 0xFF) - (byte2 & 0xFF);
            }
            return $this$compareTo.length - other.length;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final FixedSizedBlockDictionary createFile(@NotNull List<String> values, int blockSize, @NotNull String version, @NotNull FileHandle file) {
            void $this$forEach$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            int length = values.size() * blockSize;
            FixedSizedBlockDictionary fixedSizeBlockFileList = new FixedSizedBlockDictionary(blockSize, length, null, file, 4, null);
            Iterable $this$map$iv = values;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                byte[] byArray = it.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                collection.add(byArray);
            }
            $this$map$iv = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (arg_0, arg_1) -> Companion.createFile$lambda$1(createFile.2.INSTANCE, arg_0, arg_1));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                byte[] it = (byte[])element$iv;
                boolean bl = false;
                file.write(fixedSizeBlockFileList.padValue(it));
            }
            String string3 = "{\"blockSize\":" + blockSize + ",\"length\":" + length + ",\"version\":\"" + version + "\"}";
            byte[] byArray = string3.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] metadata = byArray;
            file.write(metadata);
            return fixedSizeBlockFileList;
        }

        public static /* synthetic */ FixedSizedBlockDictionary createFile$default(Companion companion, List list, int n, String string2, FileHandle fileHandle, int n2, Object object) {
            if ((n2 & 4) != 0) {
                string2 = "1";
            }
            return companion.createFile(list, n, string2, fileHandle);
        }

        private static final int createFile$lambda$1(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return ((Number)$tmp0.invoke(p0, p1)).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

