/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.ide.DataManager;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.VcsRootError;
import com.intellij.openapi.vcs.VcsSharedProjectSettings;
import com.intellij.openapi.vcs.changes.HierarchicalFilePathComparator;
import com.intellij.openapi.vcs.configurable.RecordInfo;
import com.intellij.openapi.vcs.configurable.SuggestedVcsComparator;
import com.intellij.openapi.vcs.configurable.VcsDirectoryConfigurationPanelKt;
import com.intellij.openapi.vcs.configurable.VcsMappingConfigurationDialog;
import com.intellij.openapi.vcs.configurable.VcsUpdateInfoScopeFilter;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.roots.VcsRootErrorsFinder;
import com.intellij.openapi.vcs.update.AbstractCommonUpdateAction;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.LightColors;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.TableView;
import com.intellij.util.FontUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 K2\u00020\u0001:\u0005GHIJKB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020%H\u0002J\b\u0010'\u001a\u00020%H\u0002J\u0010\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\t2\u0006\u0010)\u001a\u00020*H\u0002J\b\u0010,\u001a\u00020%H\u0002J\u0016\u0010-\u001a\u00020%2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u0011H\u0002J\u0016\u00100\u001a\u00020%2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0011H\u0002J\b\u00102\u001a\u00020%H\u0002J\b\u00103\u001a\u00020%H\u0002J\u0010\u00104\u001a\u00020%2\u0006\u00105\u001a\u000206H\u0002J\u0006\u00107\u001a\u000208J\b\u00109\u001a\u00020:H\u0002J\u000e\u0010;\u001a\b\u0012\u0004\u0012\u00020/0\u0011H\u0002J\b\u0010<\u001a\u00020\tH\u0002J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\u0011H\u0002J\b\u0010?\u001a\u00020\tH\u0002J\r\u0010@\u001a\u00070\u0015\u00a2\u0006\u0002\bAH\u0002J\b\u0010B\u001a\u00020%H\u0002J\b\u0010C\u001a\u00020%H\u0002J\b\u0010D\u001a\u00020%H\u0002J\b\u0010E\u001a\u00020\tH\u0002J\u000e\u0010F\u001a\b\u0012\u0004\u0012\u00020*0\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lcom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "POSTPONE_MAPPINGS_LOADING_PANEL", "", "isEditingDisabled", "", "vcsManager", "Lcom/intellij/openapi/vcs/ProjectLevelVcsManager;", "vcsConfiguration", "Lcom/intellij/openapi/vcs/VcsConfiguration;", "sharedProjectSettings", "Lcom/intellij/openapi/vcs/VcsSharedProjectSettings;", "allSupportedVcss", "", "Lcom/intellij/openapi/vcs/AbstractVcs;", "vcsRootCheckers", "", "", "Lcom/intellij/openapi/vcs/VcsRootChecker;", "tableLoadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "mappingTable", "Lcom/intellij/ui/table/TableView;", "Lcom/intellij/openapi/vcs/configurable/RecordInfo;", "mappingTableModel", "Lcom/intellij/util/ui/ListTableModel;", "directoryRenderer", "Lcom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$MyDirectoryRenderer;", "vcsComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "rootDetectionIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "dispose", "", "initializeModel", "scheduleUnregisteredRootsLoading", "createRegisteredInfo", "mapping", "Lcom/intellij/openapi/vcs/VcsDirectoryMapping;", "isMappingValid", "addMapping", "addSelectedUnregisteredMappings", "infos", "Lcom/intellij/openapi/vcs/configurable/RecordInfo$UnregisteredMapping;", "setDisplayedMappings", "mappings", "editMapping", "removeMapping", "selectIndex", "index", "", "createMainComponent", "Lcom/intellij/openapi/ui/DialogPanel;", "createMappingsTable", "Ljavax/swing/JComponent;", "getSelectedUnregisteredRoots", "rootsOfOneKindInSelection", "getSelectedRegisteredRoots", "Lcom/intellij/openapi/vcs/configurable/RecordInfo$RegisteredMappingInfo;", "onlyRegisteredRootsInSelection", "getProjectMappingDescription", "Lorg/jetbrains/annotations/Nls;", "reset", "apply", "adjustIgnoredRootsSettings", "isModified", "getModelMappings", "MyDirectoryRenderer", "MyVcsRenderer", "MyDirectoryColumnInfo", "MyVcsColumnInfo", "Companion", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nVcsDirectoryConfigurationPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsDirectoryConfigurationPanel.kt\ncom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,565:1\n1208#2,2:566\n1236#2,4:568\n1563#2:572\n1634#2,3:573\n1761#2,3:576\n808#2,11:579\n774#2:590\n865#2,2:591\n1563#2:593\n1634#2,3:594\n808#2,11:597\n808#2,11:608\n774#2:619\n865#2,2:620\n1563#2:622\n1634#2,3:623\n1563#2:626\n1634#2,3:627\n1617#2,9:630\n1869#2:639\n1870#2:641\n1626#2:642\n774#2:643\n865#2,2:644\n1563#2:646\n1634#2,3:647\n1563#2:650\n1634#2,3:651\n1#3:640\n*S KotlinDebug\n*F\n+ 1 VcsDirectoryConfigurationPanel.kt\ncom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel\n*L\n58#1:566,2\n58#1:568,4\n167#1:572\n167#1:573,3\n236#1:576,3\n259#1:579,11\n264#1:590\n264#1:591,2\n265#1:593\n265#1:594,3\n350#1:597,11\n367#1:608,11\n395#1:619\n395#1:620,2\n396#1:622\n396#1:623,3\n397#1:626\n397#1:627,3\n405#1:630,9\n405#1:639\n405#1:641\n405#1:642\n181#1:643\n181#1:644,2\n182#1:646\n182#1:647,3\n190#1:650\n190#1:651,3\n405#1:640\n*E\n"})
public final class VcsDirectoryConfigurationPanel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final long POSTPONE_MAPPINGS_LOADING_PANEL;
    private final boolean isEditingDisabled;
    @NotNull
    private final ProjectLevelVcsManager vcsManager;
    @NotNull
    private final VcsConfiguration vcsConfiguration;
    @NotNull
    private final VcsSharedProjectSettings sharedProjectSettings;
    @NotNull
    private final List<AbstractVcs> allSupportedVcss;
    @NotNull
    private final Map<String, VcsRootChecker> vcsRootCheckers;
    @NotNull
    private final JBLoadingPanel tableLoadingPanel;
    @NotNull
    private final TableView<RecordInfo> mappingTable;
    @NotNull
    private final ListTableModel<RecordInfo> mappingTableModel;
    @NotNull
    private final MyDirectoryRenderer directoryRenderer;
    @NotNull
    private final ComboBox<AbstractVcs> vcsComboBox;
    @Nullable
    private ProgressIndicator rootDetectionIndicator;

    /*
     * WARNING - void declaration
     */
    public VcsDirectoryConfigurationPanel(@NotNull Project project) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.POSTPONE_MAPPINGS_LOADING_PANEL = 300L;
        this.isEditingDisabled = this.project.isDefault();
        this.vcsManager = ProjectLevelVcsManager.Companion.getInstance(this.project);
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)vcsConfiguration, (String)"getInstance(...)");
        this.vcsConfiguration = vcsConfiguration;
        this.sharedProjectSettings = VcsSharedProjectSettings.Companion.getInstance(this.project);
        this.allSupportedVcss = ArraysKt.asList((Object[])this.vcsManager.getAllSupportedVcss());
        ColumnInfo[] columnInfoArray = (ColumnInfo[])VcsRootChecker.EXTENSION_POINT_NAME.getExtensionList();
        VcsDirectoryConfigurationPanel vcsDirectoryConfigurationPanel = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var5_6 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            VcsRootChecker vcsRootChecker = (VcsRootChecker)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getSupportedVcs().getName(), element$iv$iv);
        }
        vcsDirectoryConfigurationPanel.vcsRootCheckers = destination$iv$iv;
        this.mappingTable = new TableView();
        this.mappingTable.setShowGrid(false);
        this.mappingTable.setIntercellSpacing((Dimension)JBUI.emptySize());
        TableSpeedSearch.installOn((JTable)((JTable)this.mappingTable), arg_0 -> VcsDirectoryConfigurationPanel._init_$lambda$0(this, arg_0));
        this.tableLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, (int)this.POSTPONE_MAPPINGS_LOADING_PANEL * 2);
        this.directoryRenderer = new MyDirectoryRenderer(this.project);
        columnInfoArray = new ColumnInfo[]{new MyDirectoryColumnInfo(), new MyVcsColumnInfo()};
        this.mappingTableModel = new ListTableModel(columnInfoArray);
        this.mappingTable.setModelAndUpdateColumns(this.mappingTableModel);
        this.vcsComboBox = VcsDirectoryConfigurationPanel.Companion.buildVcsesComboBox(this.project, this.allSupportedVcss);
        this.vcsComboBox.addItemListener(arg_0 -> VcsDirectoryConfigurationPanel._init_$lambda$1(this, arg_0));
        this.mappingTable.setRowHeight(this.vcsComboBox.getPreferredSize().height);
        if (this.isEditingDisabled) {
            this.mappingTable.setEnabled(false);
        }
    }

    public void dispose() {
        block0: {
            ProgressIndicator progressIndicator = this.rootDetectionIndicator;
            if (progressIndicator == null) break block0;
            progressIndicator.cancel();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeModel() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List items = new ArrayList();
        Iterable iterable = this.vcsManager.getDirectoryMappings();
        List list = items;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VcsDirectoryMapping vcsDirectoryMapping = (VcsDirectoryMapping)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.createRegisteredInfo((VcsDirectoryMapping)it));
        }
        list.addAll((List)destination$iv$iv);
        this.setDisplayedMappings(items);
        this.scheduleUnregisteredRootsLoading();
    }

    private final void scheduleUnregisteredRootsLoading() {
        if (this.project.isDefault() || !TrustedProjects.isProjectTrusted((Project)this.project)) {
            return;
        }
        ProgressIndicator progressIndicator = this.rootDetectionIndicator;
        if (progressIndicator != null) {
            progressIndicator.cancel();
        }
        if (!VcsUtil.shouldDetectVcsMappingsFor((Project)this.project)) {
            return;
        }
        this.rootDetectionIndicator = BackgroundTaskUtil.executeAndTryWait(arg_0 -> VcsDirectoryConfigurationPanel.scheduleUnregisteredRootsLoading$lambda$1(arg_0 -> VcsDirectoryConfigurationPanel.scheduleUnregisteredRootsLoading$lambda$0(this, arg_0), arg_0), () -> VcsDirectoryConfigurationPanel.scheduleUnregisteredRootsLoading$lambda$2(this), (long)this.POSTPONE_MAPPINGS_LOADING_PANEL, (boolean)false);
    }

    private final RecordInfo createRegisteredInfo(VcsDirectoryMapping mapping) {
        if (this.isMappingValid(mapping)) {
            return new RecordInfo.ValidMapping(mapping);
        }
        return new RecordInfo.InvalidMapping(mapping);
    }

    private final boolean isMappingValid(VcsDirectoryMapping mapping) {
        if (mapping.isDefaultMapping()) {
            return true;
        }
        VcsRootChecker vcsRootChecker = this.vcsRootCheckers.get(mapping.getVcs());
        if (vcsRootChecker == null) {
            return true;
        }
        VcsRootChecker checker = vcsRootChecker;
        VirtualFile directory = LocalFileSystem.getInstance().findFileByPath(mapping.getDirectory());
        return directory != null && checker.validateRoot(directory);
    }

    private final void addMapping() {
        VcsMappingConfigurationDialog dlg = new VcsMappingConfigurationDialog(this.project, VcsBundle.message((String)"directory.mapping.add.title", (Object[])new Object[0]));
        if (dlg.showAndGet()) {
            List list = this.mappingTableModel.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
            List items = CollectionsKt.toMutableList((Collection)list);
            VcsDirectoryMapping vcsDirectoryMapping = dlg.getMapping();
            Intrinsics.checkNotNullExpressionValue((Object)vcsDirectoryMapping, (String)"getMapping(...)");
            items.add(this.createRegisteredInfo(vcsDirectoryMapping));
            this.setDisplayedMappings(items);
        }
    }

    private final void addSelectedUnregisteredMappings(List<RecordInfo.UnregisteredMapping> infos) {
        List list = this.mappingTableModel.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        List items = CollectionsKt.toMutableList((Collection)list);
        for (RecordInfo.UnregisteredMapping info : infos) {
            items.remove(info);
            items.add(this.createRegisteredInfo(info.getMapping()));
        }
        this.setDisplayedMappings(items);
    }

    private final void setDisplayedMappings(List<? extends RecordInfo> mappings) {
        boolean bl;
        List items;
        block4: {
            items = CollectionsKt.toMutableList((Collection)mappings);
            items.removeIf(arg_0 -> VcsDirectoryConfigurationPanel.setDisplayedMappings$lambda$1(VcsDirectoryConfigurationPanel::setDisplayedMappings$lambda$0, arg_0));
            Iterable $this$any$iv = items;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    RecordInfo it = (RecordInfo)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof RecordInfo.UnregisteredMapping)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            items.add(RecordInfo.UnregisteredHeader.INSTANCE);
        }
        CollectionsKt.sortWith((List)items, (Comparator)VcsDirectoryConfigurationPanelKt.access$getRECORD_INFO_COMPARATOR$p());
        this.mappingTableModel.setItems(items);
    }

    private final void editMapping() {
        int row = this.mappingTable.getSelectedRow();
        Object object = this.mappingTable.getRow(row);
        RecordInfo.RegisteredMappingInfo registeredMappingInfo = object instanceof RecordInfo.RegisteredMappingInfo ? (RecordInfo.RegisteredMappingInfo)object : null;
        if (registeredMappingInfo == null) {
            return;
        }
        RecordInfo.RegisteredMappingInfo info = registeredMappingInfo;
        VcsMappingConfigurationDialog dlg = new VcsMappingConfigurationDialog(this.project, VcsBundle.message((String)"directory.mapping.remove.title", (Object[])new Object[0]));
        dlg.setMapping(info.getMapping());
        if (dlg.showAndGet()) {
            List list = this.mappingTableModel.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
            List items = CollectionsKt.toMutableList((Collection)list);
            VcsDirectoryMapping vcsDirectoryMapping = dlg.getMapping();
            Intrinsics.checkNotNullExpressionValue((Object)vcsDirectoryMapping, (String)"getMapping(...)");
            items.set(row, this.createRegisteredInfo(vcsDirectoryMapping));
            this.setDisplayedMappings(items);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void removeMapping() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        RecordInfo.RegisteredMappingInfo info;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        int index = this.mappingTable.getSelectionModel().getMinSelectionIndex();
        Collection collection = this.mappingTable.getSelection();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getSelection(...)");
        Iterable $this$filterIsInstance$iv = collection;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo22 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof RecordInfo.RegisteredMappingInfo)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List selection = (List)destination$iv$iv;
        List list = this.mappingTableModel.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        List items = CollectionsKt.toMutableList((Collection)list);
        items.removeAll(CollectionsKt.toSet((Iterable)selection));
        $this$filterIsInstanceTo$iv$iv = selection;
        boolean $i$f$filter = false;
        void $i$f$filterIsInstanceTo22 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            info = (RecordInfo.RegisteredMappingInfo)element$iv$iv;
            boolean bl = false;
            if (!(info instanceof RecordInfo.ValidMapping && this.vcsRootCheckers.get(info.getMapping().getVcs()) != null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List removedValidRoots = (List)destination$iv$iv2;
        $this$filter$iv = removedValidRoots;
        List list2 = items;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            info = (RecordInfo.RegisteredMappingInfo)item$iv$iv;
            Collection collection2 = destination$iv$iv2;
            boolean bl = false;
            collection2.add(new RecordInfo.UnregisteredMapping(it.getMapping()));
        }
        list2.addAll((List)destination$iv$iv2);
        this.setDisplayedMappings(items);
        this.selectIndex(index);
    }

    private final void selectIndex(int index) {
        List list = this.mappingTableModel.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        List newItems = list;
        if (newItems.isEmpty()) {
            return;
        }
        int toSelect = index >= newItems.size() ? newItems.size() - 1 : index;
        this.mappingTable.getSelectionModel().setSelectionInterval(toSelect, toSelect);
    }

    @NotNull
    public final DialogPanel createMainComponent() {
        DialogPanel dialogPanel;
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        result2.element = com.intellij.ui.dsl.builder.BuilderKt.panel(arg_0 -> VcsDirectoryConfigurationPanel.createMainComponent$lambda$0(this, result2, arg_0));
        if (result2.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"result");
            dialogPanel = null;
        } else {
            dialogPanel = (DialogPanel)result2.element;
        }
        return dialogPanel;
    }

    private final JComponent createMappingsTable() {
        JPanel jPanel = ToolbarDecorator.createDecorator(this.mappingTable, null).setAddActionUpdater(arg_0 -> VcsDirectoryConfigurationPanel.createMappingsTable$lambda$0(this, arg_0)).setAddAction(arg_0 -> VcsDirectoryConfigurationPanel.createMappingsTable$lambda$1(this, arg_0)).setEditActionUpdater(arg_0 -> VcsDirectoryConfigurationPanel.createMappingsTable$lambda$2(this, arg_0)).setEditAction(arg_0 -> VcsDirectoryConfigurationPanel.createMappingsTable$lambda$3(this, arg_0)).setRemoveActionUpdater(arg_0 -> VcsDirectoryConfigurationPanel.createMappingsTable$lambda$4(this, arg_0)).setRemoveAction(arg_0 -> VcsDirectoryConfigurationPanel.createMappingsTable$lambda$5(this, arg_0)).disableUpDownActions().createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        JPanel panelForTable = jPanel;
        panelForTable.setPreferredSize((Dimension)new JBDimension(-1, 200));
        return panelForTable;
    }

    /*
     * WARNING - void declaration
     */
    private final List<RecordInfo.UnregisteredMapping> getSelectedUnregisteredRoots() {
        void $this$filterIsInstanceTo$iv$iv;
        Collection collection = this.mappingTable.getSelection();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getSelection(...)");
        Iterable $this$filterIsInstance$iv = collection;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof RecordInfo.UnregisteredMapping)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean rootsOfOneKindInSelection() {
        Collection selection = this.mappingTable.getSelection();
        if (selection.isEmpty()) {
            return true;
        }
        if (selection.size() == 1 && selection.iterator().next() instanceof RecordInfo.Header) {
            return true;
        }
        List<RecordInfo.RegisteredMappingInfo> selectedRegisteredRoots = this.getSelectedRegisteredRoots();
        return selectedRegisteredRoots.size() == selection.size() || selectedRegisteredRoots.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private final List<RecordInfo.RegisteredMappingInfo> getSelectedRegisteredRoots() {
        void $this$filterIsInstanceTo$iv$iv;
        Collection selection = this.mappingTable.getSelection();
        Intrinsics.checkNotNull((Object)selection);
        Iterable $this$filterIsInstance$iv = selection;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof RecordInfo.RegisteredMappingInfo)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean onlyRegisteredRootsInSelection() {
        return this.getSelectedRegisteredRoots().size() == this.mappingTable.getSelection().size();
    }

    private final String getProjectMappingDescription() {
        String string = DefaultVcsRootPolicy.getInstance(this.project).getProjectConfigurationMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProjectConfigurationMessage(...)");
        String message = StringsKt.replace$default((String)string, (char)'\n', (char)' ', (boolean)false, (int)4, null);
        String string2 = StringUtil.escapeXmlEntities((String)(VcsDirectoryMapping.PROJECT_CONSTANT.get() + " - " + message));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"escapeXmlEntities(...)");
        return string2;
    }

    private final void reset() {
        this.initializeModel();
    }

    private final void apply() throws ConfigurationException {
        this.adjustIgnoredRootsSettings();
        this.vcsManager.setDirectoryMappings(this.getModelMappings());
        this.initializeModel();
    }

    /*
     * WARNING - void declaration
     */
    private final void adjustIgnoredRootsSettings() {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        VcsDirectoryMapping mapping;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        List<VcsDirectoryMapping> newMappings = this.getModelMappings();
        List previousMappings = this.vcsManager.getDirectoryMappings();
        Iterable iterable = previousMappings;
        VcsConfiguration vcsConfiguration = this.vcsConfiguration;
        boolean $i$f$filter = false;
        void var5_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            mapping = (VcsDirectoryMapping)element$iv$iv;
            boolean bl = false;
            if (!(!newMappings.contains(mapping) && !mapping.isDefaultMapping())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            mapping = (VcsDirectoryMapping)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(mapping.getDirectory());
        }
        vcsConfiguration.addIgnoredUnregisteredRoots((Collection)((List)destination$iv$iv));
        $this$map$iv = newMappings;
        vcsConfiguration = this.vcsConfiguration;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void obj;
            mapping = (VcsDirectoryMapping)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(obj.getDirectory());
        }
        vcsConfiguration.removeFromIgnoredUnregisteredRoots((Collection)((List)destination$iv$iv));
    }

    private final boolean isModified() {
        return !Intrinsics.areEqual(this.getModelMappings(), (Object)this.vcsManager.getDirectoryMappings());
    }

    /*
     * WARNING - void declaration
     */
    private final List<VcsDirectoryMapping> getModelMappings() {
        void $this$mapNotNullTo$iv$iv;
        List list = this.mappingTableModel.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VcsDirectoryMapping it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            RecordInfo info = (RecordInfo)element$iv$iv;
            boolean bl2 = false;
            if ((info instanceof RecordInfo.RegisteredMappingInfo ? ((RecordInfo.RegisteredMappingInfo)info).getMapping() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final String _init_$lambda$0(VcsDirectoryConfigurationPanel this$0, Object info) {
        return info instanceof RecordInfo.MappingInfo ? VcsDirectoryConfigurationPanelKt.access$getPresentablePath(this$0.project, ((RecordInfo.MappingInfo)info).getMapping()) : "";
    }

    private static final void _init_$lambda$1(VcsDirectoryConfigurationPanel this$0, ItemEvent it) {
        if (this$0.mappingTable.isEditing()) {
            this$0.mappingTable.stopEditing();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Runnable scheduleUnregisteredRootsLoading$lambda$0(VcsDirectoryConfigurationPanel this$0, ProgressIndicator indicator) {
        void $this$mapTo$iv$iv;
        VcsRootError error;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Collection<VcsRootError> collection = VcsRootErrorsFinder.getInstance(this$0.project).getOrFind();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getOrFind(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            error = (VcsRootError)element$iv$iv;
            boolean bl = false;
            if (!(error.getType() == VcsRootError.Type.UNREGISTERED_ROOT)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            error = (VcsRootError)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(error.getMapping());
        }
        List unregisteredRoots = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        return () -> VcsDirectoryConfigurationPanel.scheduleUnregisteredRootsLoading$lambda$0$2(indicator, this$0, unregisteredRoots);
    }

    /*
     * WARNING - void declaration
     */
    private static final void scheduleUnregisteredRootsLoading$lambda$0$2(ProgressIndicator $indicator, VcsDirectoryConfigurationPanel this$0, List $unregisteredRoots) {
        if ($indicator.isCanceled()) {
            return;
        }
        this$0.tableLoadingPanel.stopLoading();
        if (!$unregisteredRoots.isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List list = this$0.mappingTableModel.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
            List items = CollectionsKt.toMutableList((Collection)list);
            items.removeIf(arg_0 -> VcsDirectoryConfigurationPanel.scheduleUnregisteredRootsLoading$lambda$0$2$1(VcsDirectoryConfigurationPanel::scheduleUnregisteredRootsLoading$lambda$0$2$0, arg_0));
            Iterable iterable = $unregisteredRoots;
            List list2 = items;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VcsDirectoryMapping vcsDirectoryMapping = (VcsDirectoryMapping)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(new RecordInfo.UnregisteredMapping((VcsDirectoryMapping)it));
            }
            list2.addAll((List)destination$iv$iv);
            this$0.setDisplayedMappings(items);
        }
    }

    private static final boolean scheduleUnregisteredRootsLoading$lambda$0$2$0(RecordInfo it) {
        return it.isUnregistered();
    }

    private static final boolean scheduleUnregisteredRootsLoading$lambda$0$2$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Runnable scheduleUnregisteredRootsLoading$lambda$1(Function1 $tmp0, Object p0) {
        return (Runnable)$tmp0.invoke(p0);
    }

    private static final void scheduleUnregisteredRootsLoading$lambda$2(VcsDirectoryConfigurationPanel this$0) {
        this$0.tableLoadingPanel.startLoading();
    }

    private static final boolean setDisplayedMappings$lambda$0(RecordInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof RecordInfo.Header;
    }

    private static final boolean setDisplayedMappings$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit createMainComponent$lambda$0(VcsDirectoryConfigurationPanel this$0, Ref.ObjectRef $result, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        if (!TrustedProjects.isProjectTrusted((Project)this$0.project)) {
            Panel.row$default((Panel)$this$panel, null, VcsDirectoryConfigurationPanel::createMainComponent$lambda$0$0, (int)1, null);
        }
        this$0.tableLoadingPanel.add((Component)this$0.createMappingsTable());
        Panel.row$default((Panel)$this$panel, null, arg_0 -> VcsDirectoryConfigurationPanel.createMainComponent$lambda$0$1(this$0, arg_0), (int)1, null).resizableRow();
        Panel.row$default((Panel)$this$panel, null, arg_0 -> VcsDirectoryConfigurationPanel.createMainComponent$lambda$0$2(this$0, arg_0), (int)1, null);
        if (!AbstractCommonUpdateAction.Companion.showsCustomNotification(ArraysKt.asList((Object[])this$0.vcsManager.getAllActiveVcss()))) {
            VcsUpdateInfoScopeFilter scopeFilter = new VcsUpdateInfoScopeFilter(this$0.project, this$0.vcsConfiguration, this$0);
            scopeFilter.createContent($this$panel, () -> VcsDirectoryConfigurationPanel.createMainComponent$lambda$0$3($result));
        }
        $this$panel.onApply((Function0)new Function0<Unit>((Object)this$0){

            public final void invoke() {
                VcsDirectoryConfigurationPanel.access$apply((VcsDirectoryConfigurationPanel)this.receiver);
            }
        });
        $this$panel.onReset((Function0)new Function0<Unit>((Object)this$0){

            public final void invoke() {
                VcsDirectoryConfigurationPanel.access$reset((VcsDirectoryConfigurationPanel)this.receiver);
            }
        });
        $this$panel.onIsModified((Function0)new Function0<Boolean>((Object)this$0){

            public final Boolean invoke() {
                return VcsDirectoryConfigurationPanel.access$isModified((VcsDirectoryConfigurationPanel)this.receiver);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit createMainComponent$lambda$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)new EditorNotificationPanel(LightColors.RED, EditorNotificationPanel.Status.Error)).applyToComponent(VcsDirectoryConfigurationPanel::createMainComponent$lambda$0$0$0).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createMainComponent$lambda$0$0$0(EditorNotificationPanel $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setText(VcsBundle.message((String)"configuration.project.not.trusted.label", (Object[])new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit createMainComponent$lambda$0$1(VcsDirectoryConfigurationPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell.comment$default((Cell)$this$row.cell((JComponent)this$0.tableLoadingPanel), (String)this$0.getProjectMappingDescription(), (int)-1, null, (int)4, null).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit createMainComponent$lambda$0$2(VcsDirectoryConfigurationPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = VcsBundle.message((String)"directory.mapping.checkbox.detect.vcs.mappings.automatically", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.sharedProjectSettings){

            public Object get() {
                return ((VcsSharedProjectSettings)this.receiver).isDetectVcsMappingsAutomatically();
            }

            public void set(Object value) {
                ((VcsSharedProjectSettings)this.receiver).setDetectVcsMappingsAutomatically(((Boolean)value).booleanValue());
            }
        })).gap(RightGap.SMALL);
        String string2 = VcsBundle.message((String)"directory.mapping.checkbox.detect.vcs.mappings.automatically.hint", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Row.contextHelp$default((Row)$this$row, (String)string2, null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final void createMainComponent$lambda$0$3(Ref.ObjectRef $result) {
        DialogPanel dialogPanel;
        DataManager dataManager = DataManager.getInstance();
        if ($result.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"result");
            dialogPanel = null;
        } else {
            dialogPanel = (DialogPanel)$result.element;
        }
        DataContext dataContext = dataManager.getDataContext((Component)dialogPanel);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Settings settings = (Settings)Settings.KEY.getData(dataContext);
        if (settings != null) {
            settings.select(settings.find("project.scopes"));
        }
    }

    private static final boolean createMappingsTable$lambda$0(VcsDirectoryConfigurationPanel this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !this$0.isEditingDisabled && this$0.rootsOfOneKindInSelection();
    }

    private static final void createMappingsTable$lambda$1(VcsDirectoryConfigurationPanel this$0, AnActionButton it) {
        List<RecordInfo.UnregisteredMapping> unregisteredRoots = this$0.getSelectedUnregisteredRoots();
        if (unregisteredRoots.isEmpty()) {
            this$0.addMapping();
        } else {
            this$0.addSelectedUnregisteredMappings(unregisteredRoots);
        }
    }

    private static final boolean createMappingsTable$lambda$2(VcsDirectoryConfigurationPanel this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !this$0.isEditingDisabled && this$0.onlyRegisteredRootsInSelection();
    }

    private static final void createMappingsTable$lambda$3(VcsDirectoryConfigurationPanel this$0, AnActionButton it) {
        this$0.editMapping();
    }

    private static final boolean createMappingsTable$lambda$4(VcsDirectoryConfigurationPanel this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !this$0.isEditingDisabled && this$0.onlyRegisteredRootsInSelection();
    }

    private static final void createMappingsTable$lambda$5(VcsDirectoryConfigurationPanel this$0, AnActionButton it) {
        this$0.removeMapping();
    }

    @JvmStatic
    @NotNull
    public static final ComboBox<AbstractVcs> buildVcsesComboBox(@NotNull Project project) {
        return Companion.buildVcsesComboBox(project);
    }

    public static final /* synthetic */ ComboBox access$getVcsComboBox$p(VcsDirectoryConfigurationPanel $this) {
        return $this.vcsComboBox;
    }

    public static final /* synthetic */ void access$apply(VcsDirectoryConfigurationPanel $this) {
        $this.apply();
    }

    public static final /* synthetic */ void access$reset(VcsDirectoryConfigurationPanel $this) {
        $this.reset();
    }

    public static final /* synthetic */ boolean access$isModified(VcsDirectoryConfigurationPanel $this) {
        return $this.isModified();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J&\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$Companion;", "", "<init>", "()V", "buildVcsesComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/openapi/vcs/AbstractVcs;", "project", "Lcom/intellij/openapi/project/Project;", "allVcses", "", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nVcsDirectoryConfigurationPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsDirectoryConfigurationPanel.kt\ncom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,565:1\n37#2,2:566\n*S KotlinDebug\n*F\n+ 1 VcsDirectoryConfigurationPanel.kt\ncom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$Companion\n*L\n479#1:566,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ComboBox<AbstractVcs> buildVcsesComboBox(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object[] allVcses = ProjectLevelVcsManager.Companion.getInstance(project).getAllSupportedVcss();
            return this.buildVcsesComboBox(project, ArraysKt.asList((Object[])allVcses));
        }

        private final ComboBox<AbstractVcs> buildVcsesComboBox(Project project, List<? extends AbstractVcs> allVcses) {
            Collection $this$toTypedArray$iv = CollectionsKt.sortedWith((Iterable)CollectionsKt.plus((Collection)allVcses, null), SuggestedVcsComparator.create(project));
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            ComboBox comboBox = new ComboBox((Object[])thisCollection$iv.toArray(new AbstractVcs[0]));
            String string = VcsBundle.message((String)"none.vcs.presentation", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            comboBox.setRenderer(BuilderKt.textListCellRenderer((String)string, Companion::buildVcsesComboBox$lambda$0));
            return comboBox;
        }

        private static final String buildVcsesComboBox$lambda$0(AbstractVcs obj) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            return obj.getDisplayName();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$MyDirectoryColumnInfo;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/openapi/vcs/configurable/RecordInfo;", "<init>", "(Lcom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel;)V", "valueOf", "mapping", "getRenderer", "Ljavax/swing/table/TableCellRenderer;", "vcsDirectoryMapping", "intellij.platform.vcs.impl"})
    private final class MyDirectoryColumnInfo
    extends ColumnInfo<RecordInfo, RecordInfo> {
        public MyDirectoryColumnInfo() {
            super(VcsBundle.message((String)"column.info.configure.vcses.directory", (Object[])new Object[0]));
        }

        @NotNull
        public RecordInfo valueOf(@NotNull RecordInfo mapping) {
            Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
            return mapping;
        }

        @NotNull
        public TableCellRenderer getRenderer(@NotNull RecordInfo vcsDirectoryMapping) {
            Intrinsics.checkNotNullParameter((Object)vcsDirectoryMapping, (String)"vcsDirectoryMapping");
            return (TableCellRenderer)((Object)VcsDirectoryConfigurationPanel.this.directoryRenderer);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J:\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$MyDirectoryRenderer;", "Lcom/intellij/ui/ColoredTableCellRenderer;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "customizeCellRenderer", "", "table", "Ljavax/swing/JTable;", "value", "", "selected", "", "hasFocus", "row", "", "column", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nVcsDirectoryConfigurationPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsDirectoryConfigurationPanel.kt\ncom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$MyDirectoryRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,565:1\n1563#2:566\n1634#2,3:567\n1563#2:570\n1634#2,3:571\n*S KotlinDebug\n*F\n+ 1 VcsDirectoryConfigurationPanel.kt\ncom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$MyDirectoryRenderer\n*L\n95#1:566\n95#1:567,3\n97#1:570\n97#1:571,3\n*E\n"})
    private static final class MyDirectoryRenderer
    extends ColoredTableCellRenderer {
        @NotNull
        private final Project project;

        public MyDirectoryRenderer(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
            Object presentablePath;
            RecordInfo recordInfo;
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.intellij.openapi.vcs.configurable.RecordInfo");
            RecordInfo cfr_ignored_0 = (RecordInfo)value;
            SimpleTextAttributes textAttributes = VcsDirectoryConfigurationPanelKt.access$getAttributes((RecordInfo)value);
            this.setToolTipText(null);
            if (!selected && ((RecordInfo)value).isUnregistered()) {
                this.setBackground(UIUtil.getDecoratedRowColor());
            }
            if ((recordInfo = (RecordInfo)value) instanceof RecordInfo.MappingInfo) {
                presentablePath = VcsDirectoryConfigurationPanelKt.access$getPresentablePath(this.project, ((RecordInfo.MappingInfo)value).getMapping());
                SpeedSearchUtil.appendFragmentsForSpeedSearch((JComponent)table, (String)presentablePath, (SimpleTextAttributes)textAttributes, (boolean)selected, (SimpleColoredComponent)((SimpleColoredComponent)this));
            } else if (recordInfo instanceof RecordInfo.Header) {
                this.append(((RecordInfo.Header)value).getLabel(), textAttributes);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            if (value instanceof RecordInfo.RegisteredMappingInfo && ((RecordInfo.RegisteredMappingInfo)value).getMapping().isDefaultMapping()) {
                String string = ((RecordInfo.RegisteredMappingInfo)value).getMapping().getVcs();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVcs(...)");
                List roots2 = VcsDirectoryConfigurationPanelKt.access$collectDefaultMappedRoots(this.project, string);
                if (!((Collection)roots2).isEmpty()) {
                    FilePath it;
                    Collection collection;
                    Iterable $this$mapTo$iv$iv;
                    Iterable $this$map$iv;
                    this.append(FontUtil.spaceAndThinSpace(), textAttributes);
                    presentablePath = new Object[]{roots2.size()};
                    this.append(VcsBundle.message((String)"project.detected.n.roots.presentation", (Object[])presentablePath), SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
                    presentablePath = roots2;
                    MyDirectoryRenderer myDirectoryRenderer = this;
                    boolean $i$f$map = false;
                    void var11_12 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(VcsUtil.getFilePath((VirtualFile)it));
                    }
                    Iterable iterable = (List)destination$iv$iv;
                    HierarchicalFilePathComparator hierarchicalFilePathComparator = HierarchicalFilePathComparator.NATURAL;
                    Intrinsics.checkNotNullExpressionValue((Object)hierarchicalFilePathComparator, (String)"NATURAL");
                    $this$map$iv = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)((Comparator)hierarchicalFilePathComparator));
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        it = (FilePath)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(StringUtil.escapeXmlEntities((String)it.getPresentableUrl()));
                    }
                    myDirectoryRenderer.setToolTipText(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"<br/>", null, null, (int)0, null, null, (int)62, null));
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$MyVcsColumnInfo;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/openapi/vcs/configurable/RecordInfo;", "", "<init>", "(Lcom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel;)V", "valueOf", "info", "isCellEditable", "", "setValue", "", "newVcs", "getRenderer", "Ljavax/swing/table/TableCellRenderer;", "getEditor", "Ljavax/swing/table/TableCellEditor;", "o", "getMaxStringValue", "getAdditionalWidth", "", "intellij.platform.vcs.impl"})
    private final class MyVcsColumnInfo
    extends ColumnInfo<RecordInfo, String> {
        public MyVcsColumnInfo() {
            super(VcsBundle.message((String)"column.name.configure.vcses.vcs", (Object[])new Object[0]));
        }

        @NotNull
        public String valueOf(@NotNull RecordInfo info) {
            String string;
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            RecordInfo.MappingInfo mappingInfo = info instanceof RecordInfo.MappingInfo ? (RecordInfo.MappingInfo)info : null;
            if ((mappingInfo != null && (mappingInfo = mappingInfo.getMapping()) != null ? mappingInfo.getVcs() : (string = null)) == null) {
                string = "";
            }
            return string;
        }

        public boolean isCellEditable(@NotNull RecordInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            return info instanceof RecordInfo.RegisteredMappingInfo;
        }

        public void setValue(@NotNull RecordInfo info, @NotNull String newVcs) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)newVcs, (String)"newVcs");
            if (info instanceof RecordInfo.RegisteredMappingInfo) {
                VcsDirectoryMapping oldMapping = ((RecordInfo.RegisteredMappingInfo)info).getMapping();
                ((RecordInfo.RegisteredMappingInfo)info).setMapping(new VcsDirectoryMapping(oldMapping.getDirectory(), newVcs, oldMapping.getRootSettings()));
            }
        }

        @NotNull
        public TableCellRenderer getRenderer(@NotNull RecordInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            return (TableCellRenderer)((Object)new MyVcsRenderer(info, VcsDirectoryConfigurationPanel.this.allSupportedVcss));
        }

        @NotNull
        public TableCellEditor getEditor(@NotNull RecordInfo o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            return (TableCellEditor)new AbstractTableCellEditor(VcsDirectoryConfigurationPanel.this){
                final /* synthetic */ VcsDirectoryConfigurationPanel this$0;
                {
                    this.this$0 = $receiver;
                }

                public Object getCellEditorValue() {
                    AbstractVcs selectedVcs;
                    AbstractVcs abstractVcs = selectedVcs = (AbstractVcs)VcsDirectoryConfigurationPanel.access$getVcsComboBox$p(this.this$0).getItem();
                    String string = abstractVcs == null ? "" : abstractVcs.getName();
                    Intrinsics.checkNotNull((Object)string);
                    return string;
                }

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    VcsDirectoryConfigurationPanel.access$getVcsComboBox$p(this.this$0).setSelectedItem(value);
                    return (Component)VcsDirectoryConfigurationPanel.access$getVcsComboBox$p(this.this$0);
                }
            };
        }

        @Nullable
        public String getMaxStringValue() {
            String maxString = null;
            for (AbstractVcs vcs : VcsDirectoryConfigurationPanel.this.allSupportedVcss) {
                String name;
                Intrinsics.checkNotNullExpressionValue((Object)vcs.getDisplayName(), (String)"getDisplayName(...)");
                if (maxString != null && maxString.length() >= name.length()) continue;
                maxString = name;
            }
            return maxString;
        }

        public int getAdditionalWidth() {
            return 10;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ:\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$MyVcsRenderer;", "Lcom/intellij/ui/ColoredTableCellRenderer;", "info", "Lcom/intellij/openapi/vcs/configurable/RecordInfo;", "allSupportedVcss", "", "Lcom/intellij/openapi/vcs/AbstractVcs;", "<init>", "(Lcom/intellij/openapi/vcs/configurable/RecordInfo;Ljava/util/List;)V", "customizeCellRenderer", "", "table", "Ljavax/swing/JTable;", "value", "", "selected", "", "hasFocus", "row", "", "column", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nVcsDirectoryConfigurationPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsDirectoryConfigurationPanel.kt\ncom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$MyVcsRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,565:1\n1#2:566\n*E\n"})
    private static final class MyVcsRenderer
    extends ColoredTableCellRenderer {
        @NotNull
        private final RecordInfo info;
        @NotNull
        private final List<AbstractVcs> allSupportedVcss;

        public MyVcsRenderer(@NotNull RecordInfo info, @NotNull List<? extends AbstractVcs> allSupportedVcss) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter(allSupportedVcss, (String)"allSupportedVcss");
            this.info = info;
            this.allSupportedVcss = allSupportedVcss;
        }

        protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            SimpleTextAttributes textAttributes = VcsDirectoryConfigurationPanelKt.access$getAttributes(this.info);
            if (!selected && this.info.isUnregistered()) {
                this.setBackground(UIUtil.getDecoratedRowColor());
            }
            if (this.info instanceof RecordInfo.MappingInfo) {
                String string = ((RecordInfo.MappingInfo)this.info).getMapping().getVcs();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVcs(...)");
                String vcsName = string;
                if (((CharSequence)vcsName).length() == 0) {
                    this.append(VcsBundle.message((String)"none.vcs.presentation", (Object[])new Object[0]), textAttributes);
                } else {
                    AbstractVcs vcs;
                    Object object;
                    Object v1;
                    block6: {
                        Iterable iterable = this.allSupportedVcss;
                        for (Object t : iterable) {
                            AbstractVcs it = (AbstractVcs)t;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)vcsName, (Object)it.getName())) continue;
                            v1 = t;
                            break block6;
                        }
                        v1 = null;
                    }
                    if ((object = (vcs = (AbstractVcs)v1)) == null || (object = object.getDisplayName()) == null) {
                        Object[] objectArray = new Object[]{vcsName};
                        String string2 = VcsBundle.message((String)"unknown.vcs.presentation", (Object[])objectArray);
                        object = string2;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                    }
                    this.append((String)object, textAttributes);
                }
            }
        }
    }
}

