/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesListener;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.committed.IncomingChangesViewProviderKt;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.ui.content.Content;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0003\u0014\u0015\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0007H\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u00020\t*\u00020\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/vcs/changes/committed/IncomingChangesViewProvider;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "browser", "Lcom/intellij/openapi/vcs/changes/committed/CommittedChangesTreeBrowser;", "initTabContent", "", "content", "Lcom/intellij/ui/content/Content;", "createIncomingChangesBrowser", "loadIncomingChanges", "inBackground", "", "setIncomingChanges", "changeLists", "", "Lcom/intellij/openapi/vcs/versionBrowser/CommittedChangeList;", "IncomingChangesListener", "VisibilityPredicate", "DisplayNameSupplier", "intellij.platform.vcs.impl"})
public final class IncomingChangesViewProvider
implements ChangesViewContentProvider {
    @NotNull
    private final Project project;
    @Nullable
    private CommittedChangesTreeBrowser browser;

    public IncomingChangesViewProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Override
    public void initTabContent(@NotNull Content content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        CommittedChangesTreeBrowser it = this.createIncomingChangesBrowser();
        boolean bl = false;
        this.browser = it;
        content.setComponent((JComponent)it);
        content.setDisposer(() -> IncomingChangesViewProvider.initTabContent$lambda$0$0(this));
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)it);
        Topic<CommittedChangesListener> topic = CommittedChangesCache.COMMITTED_TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"COMMITTED_TOPIC");
        messageBusConnection.subscribe(topic, (Object)new IncomingChangesListener());
        this.loadIncomingChanges(false);
    }

    private final CommittedChangesTreeBrowser createIncomingChangesBrowser() {
        CommittedChangesTreeBrowser committedChangesTreeBrowser;
        CommittedChangesTreeBrowser $this$createIncomingChangesBrowser_u24lambda_u240 = committedChangesTreeBrowser = new CommittedChangesTreeBrowser(this.project, CollectionsKt.emptyList());
        boolean bl = false;
        $this$createIncomingChangesBrowser_u24lambda_u240.getEmptyText().setText(VcsBundle.message((String)"incoming.changes.not.loaded.message", (Object[])new Object[0]));
        AnAction anAction = ActionManager.getInstance().getAction("IncomingChangesToolbar");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ActionGroup group = (ActionGroup)anAction;
        $this$createIncomingChangesBrowser_u24lambda_u240.setToolBar($this$createIncomingChangesBrowser_u24lambda_u240.createGroupFilterToolbar(this.project, group, null, CollectionsKt.emptyList()).getComponent());
        $this$createIncomingChangesBrowser_u24lambda_u240.setTableContextMenu(group, CollectionsKt.emptyList());
        return committedChangesTreeBrowser;
    }

    private final void loadIncomingChanges(boolean inBackground) {
        CommittedChangesCache cache = CommittedChangesCache.getInstance(this.project);
        cache.hasCachesForAnyRoot((Consumer<? super Boolean>)((Consumer)arg_0 -> IncomingChangesViewProvider.loadIncomingChanges$lambda$1(arg_0 -> IncomingChangesViewProvider.loadIncomingChanges$lambda$0(cache, this, inBackground, arg_0), arg_0)));
    }

    private final void setIncomingChanges(CommittedChangesTreeBrowser $this$setIncomingChanges, List<? extends CommittedChangeList> changeLists2) {
        $this$setIncomingChanges.getEmptyText().setText(VcsBundle.message((String)"incoming.changes.empty.message", (Object[])new Object[0]));
        $this$setIncomingChanges.setItems(changeLists2, CommittedChangesBrowserUseCase.INCOMING);
    }

    private static final void initTabContent$lambda$0$0(IncomingChangesViewProvider this$0) {
        this$0.browser = null;
    }

    private static final Unit loadIncomingChanges$lambda$0(CommittedChangesCache $cache, IncomingChangesViewProvider this$0, boolean $inBackground, boolean hasCaches) {
        if (!hasCaches) {
            return Unit.INSTANCE;
        }
        List<CommittedChangeList> cachedIncomingChanges = $cache.getCachedIncomingChanges();
        if (cachedIncomingChanges != null) {
            CommittedChangesTreeBrowser committedChangesTreeBrowser = this$0.browser;
            if (committedChangesTreeBrowser != null) {
                this$0.setIncomingChanges(committedChangesTreeBrowser, cachedIncomingChanges);
            }
        } else {
            $cache.loadIncomingChangesAsync((Consumer<? super List<CommittedChangeList>>)((Consumer)arg_0 -> IncomingChangesViewProvider.loadIncomingChanges$lambda$0$1(arg_0 -> IncomingChangesViewProvider.loadIncomingChanges$lambda$0$0(this$0, arg_0), arg_0)), $inBackground);
        }
        return Unit.INSTANCE;
    }

    private static final Unit loadIncomingChanges$lambda$0$0(IncomingChangesViewProvider this$0, List incomingChanges) {
        ActionsKt.runInEdt$default(null, () -> IncomingChangesViewProvider.loadIncomingChanges$lambda$0$0$0(this$0, incomingChanges), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit loadIncomingChanges$lambda$0$0$0(IncomingChangesViewProvider this$0, List $incomingChanges) {
        block0: {
            CommittedChangesTreeBrowser committedChangesTreeBrowser = this$0.browser;
            if (committedChangesTreeBrowser == null) break block0;
            Intrinsics.checkNotNull((Object)$incomingChanges);
            this$0.setIncomingChanges(committedChangesTreeBrowser, $incomingChanges);
        }
        return Unit.INSTANCE;
    }

    private static final void loadIncomingChanges$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void loadIncomingChanges$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0002H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/vcs/changes/committed/IncomingChangesViewProvider$DisplayNameSupplier;", "Ljava/util/function/Supplier;", "", "<init>", "()V", "get", "intellij.platform.vcs.impl"})
    public static final class DisplayNameSupplier
    implements Supplier<String> {
        @Override
        @NotNull
        public String get() {
            String string = VcsBundle.message((String)"incoming.changes.tab", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0018\u0010\u000b\u001a\u00020\u00052\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016J\u0012\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/vcs/changes/committed/IncomingChangesViewProvider$IncomingChangesListener;", "Lcom/intellij/openapi/vcs/changes/committed/CommittedChangesListener;", "<init>", "(Lcom/intellij/openapi/vcs/changes/committed/IncomingChangesViewProvider;)V", "changesLoaded", "", "location", "Lcom/intellij/openapi/vcs/RepositoryLocation;", "changes", "", "Lcom/intellij/openapi/vcs/versionBrowser/CommittedChangeList;", "incomingChangesUpdated", "receivedChanges", "changesCleared", "refreshErrorStatusChanged", "lastError", "Lcom/intellij/openapi/vcs/VcsException;", "updateModel", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nIncomingChangesViewProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncomingChangesViewProvider.kt\ncom/intellij/openapi/vcs/changes/committed/IncomingChangesViewProvider$IncomingChangesListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1#2:105\n*E\n"})
    private final class IncomingChangesListener
    implements CommittedChangesListener {
        public void changesLoaded(@NotNull RepositoryLocation location, @NotNull List<? extends CommittedChangeList> changes) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            this.updateModel();
        }

        public void incomingChangesUpdated(@Nullable List<? extends CommittedChangeList> receivedChanges) {
            this.updateModel();
        }

        @Override
        public void changesCleared() {
            CommittedChangesTreeBrowser committedChangesTreeBrowser = IncomingChangesViewProvider.this.browser;
            if (committedChangesTreeBrowser != null) {
                IncomingChangesViewProvider.this.setIncomingChanges(committedChangesTreeBrowser, CollectionsKt.emptyList());
            }
        }

        @Override
        public void refreshErrorStatusChanged(@Nullable VcsException lastError) {
            block0: {
                VcsException vcsException = lastError;
                if (vcsException == null) break block0;
                VcsException vcsException2 = vcsException;
                IncomingChangesViewProvider incomingChangesViewProvider = IncomingChangesViewProvider.this;
                VcsException it = vcsException2;
                boolean bl = false;
                VcsBalloonProblemNotifier.showOverChangesView(incomingChangesViewProvider.project, it.getMessage(), MessageType.ERROR, new NamedRunnable[0]);
            }
        }

        private final void updateModel() {
            ActionsKt.runInEdt$default(null, () -> IncomingChangesListener.updateModel$lambda$0(IncomingChangesViewProvider.this), (int)1, null);
        }

        private static final Unit updateModel$lambda$0(IncomingChangesViewProvider this$0) {
            if (this$0.project.isDisposed() || this$0.browser == null) {
                return Unit.INSTANCE;
            }
            this$0.loadIncomingChanges(true);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/changes/committed/IncomingChangesViewProvider$VisibilityPredicate;", "Ljava/util/function/Predicate;", "Lcom/intellij/openapi/project/Project;", "<init>", "()V", "test", "", "project", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nIncomingChangesViewProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncomingChangesViewProvider.kt\ncom/intellij/openapi/vcs/changes/committed/IncomingChangesViewProvider$VisibilityPredicate\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,104:1\n12970#2,2:105\n*S KotlinDebug\n*F\n+ 1 IncomingChangesViewProvider.kt\ncom/intellij/openapi/vcs/changes/committed/IncomingChangesViewProvider$VisibilityPredicate\n*L\n93#1:105,2\n*E\n"})
    public static final class VisibilityPredicate
    implements Predicate<Project> {
        @Override
        public boolean test(@NotNull Project project) {
            boolean bl;
            block1: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                AbstractVcs[] $this$any$iv = ProjectLevelVcsManager.Companion.getInstance(project).getAllActiveVcss();
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    AbstractVcs element$iv;
                    AbstractVcs it = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!IncomingChangesViewProviderKt.isIncomingChangesAvailable(it)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }
    }
}

