/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class TypeProvider {
    private final Map<GrMethod, PsiType[]> inferredTypes = new HashMap<GrMethod, PsiType[]>();

    @NotNull
    public PsiType getReturnType(@NotNull PsiMethod method) {
        GrTypeElement typeElement;
        if (method == null) {
            TypeProvider.$$$reportNull$$$0(0);
        }
        if (method instanceof GrMethod && (typeElement = ((GrMethod)method).getReturnTypeElementGroovy()) != null) {
            PsiType psiType = typeElement.getType();
            if (psiType == null) {
                TypeProvider.$$$reportNull$$$0(1);
            }
            return psiType;
        }
        PsiType smartReturnType = PsiUtil.getSmartReturnType(method);
        if (smartReturnType != null && !PsiTypes.nullType().equals(smartReturnType)) {
            PsiType psiType = smartReturnType;
            if (psiType == null) {
                TypeProvider.$$$reportNull$$$0(2);
            }
            return psiType;
        }
        if (PsiTypes.nullType().equals(smartReturnType) && PsiUtil.isVoidMethod(method)) {
            PsiPrimitiveType psiPrimitiveType = PsiTypes.voidType();
            if (psiPrimitiveType == null) {
                TypeProvider.$$$reportNull$$$0(3);
            }
            return psiPrimitiveType;
        }
        PsiClassType psiClassType = TypesUtil.getJavaLangObject((PsiElement)method);
        if (psiClassType == null) {
            TypeProvider.$$$reportNull$$$0(4);
        }
        return psiClassType;
    }

    @NotNull
    public PsiType getVarType(@NotNull PsiVariable variable) {
        if (variable == null) {
            TypeProvider.$$$reportNull$$$0(5);
        }
        if (variable instanceof PsiParameter) {
            PsiType psiType = this.getParameterType((PsiParameter)variable);
            if (psiType == null) {
                TypeProvider.$$$reportNull$$$0(6);
            }
            return psiType;
        }
        return TypeProvider.getVariableTypeInner(variable);
    }

    @NotNull
    private static PsiType getVariableTypeInner(@NotNull PsiVariable variable) {
        if (variable == null) {
            TypeProvider.$$$reportNull$$$0(7);
        }
        PsiType type = null;
        if (variable instanceof GrVariable && (type = ((GrVariable)variable).getDeclaredType()) == null) {
            type = ((GrVariable)variable).getTypeGroovy();
        }
        if (type == null) {
            type = variable.getType();
        }
        PsiType psiType = type;
        if (psiType == null) {
            TypeProvider.$$$reportNull$$$0(8);
        }
        return psiType;
    }

    @NotNull
    public PsiType getParameterType(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            TypeProvider.$$$reportNull$$$0(9);
        }
        if (!(parameter instanceof GrParameter)) {
            PsiElement scope = parameter.getDeclarationScope();
            if (scope instanceof GrAccessorMethod) {
                PsiType psiType = this.getVarType(((GrAccessorMethod)scope).getProperty());
                if (psiType == null) {
                    TypeProvider.$$$reportNull$$$0(10);
                }
                return psiType;
            }
            PsiType psiType = parameter.getType();
            if (psiType == null) {
                TypeProvider.$$$reportNull$$$0(11);
            }
            return psiType;
        }
        PsiElement parent = parameter.getParent();
        if (!(parent instanceof GrParameterList)) {
            return TypeProvider.getVariableTypeInner((PsiVariable)parameter);
        }
        PsiElement pparent = parent.getParent();
        if (!(pparent instanceof GrMethod)) {
            PsiType psiType = parameter.getType();
            if (psiType == null) {
                TypeProvider.$$$reportNull$$$0(12);
            }
            return psiType;
        }
        PsiType[] types = this.inferMethodParameters((GrMethod)pparent);
        PsiType psiType = types[((GrParameterList)parent).getParameterNumber((GrParameter)parameter)];
        if (psiType == null) {
            TypeProvider.$$$reportNull$$$0(13);
        }
        return psiType;
    }

    private PsiType @NotNull [] inferMethodParameters(@NotNull GrMethod method) {
        PsiType[] psiTypes;
        if (method == null) {
            TypeProvider.$$$reportNull$$$0(14);
        }
        if ((psiTypes = this.inferredTypes.get(method)) != null) {
            if (psiTypes == null) {
                TypeProvider.$$$reportNull$$$0(15);
            }
            return psiTypes;
        }
        GrParameter[] parameters = method.getParameters();
        IntArrayList paramInds = new IntArrayList(parameters.length);
        PsiType[] types = PsiType.createArray((int)parameters.length);
        for (int i3 = 0; i3 < parameters.length; ++i3) {
            if (parameters[i3].getTypeElementGroovy() == null) {
                paramInds.add(i3);
                continue;
            }
            types[i3] = parameters[i3].getType();
        }
        if (!paramInds.isEmpty()) {
            GrSignature signature = GrClosureSignatureUtil.createSignature(method, PsiSubstitutor.EMPTY);
            MethodReferencesSearch.search((PsiMethod)method, (boolean)true).forEach(arg_0 -> TypeProvider.lambda$inferMethodParameters$1(signature, (IntList)paramInds, types, arg_0));
        }
        paramInds.forEach(i2 -> {
            if (types[i2] == null || types[i2] == PsiTypes.nullType()) {
                types[i2] = parameters[i2].getType();
            }
        });
        this.inferredTypes.put(method, types);
        if (types == null) {
            TypeProvider.$$$reportNull$$$0(16);
        }
        return types;
    }

    @NotNull
    public PsiType getReturnType(GrClosableBlock closure) {
        PsiType returnType = closure.getReturnType();
        if (PsiTypes.nullType().equals(returnType) && PsiUtil.isBlockReturnVoid(closure)) {
            PsiPrimitiveType psiPrimitiveType = PsiTypes.voidType();
            if (psiPrimitiveType == null) {
                TypeProvider.$$$reportNull$$$0(17);
            }
            return psiPrimitiveType;
        }
        if (returnType == null) {
            PsiClassType psiClassType = TypesUtil.getJavaLangObject(closure);
            if (psiClassType == null) {
                TypeProvider.$$$reportNull$$$0(18);
            }
            return psiClassType;
        }
        PsiType psiType = TypesUtil.boxPrimitiveType(returnType, closure.getManager(), closure.getResolveScope());
        if (psiType == null) {
            TypeProvider.$$$reportNull$$$0(19);
        }
        return psiType;
    }

    private static /* synthetic */ boolean lambda$inferMethodParameters$1(GrSignature signature, IntList paramInds, PsiType[] types, PsiReference psiReference) {
        PsiElement element = psiReference.getElement();
        PsiManager manager = element.getManager();
        GlobalSearchScope resolveScope = element.getResolveScope();
        if (element instanceof GrReferenceExpression) {
            GrCall call = (GrCall)element.getParent();
            GrClosureSignatureUtil.ArgInfo[] argInfos = GrClosureSignatureUtil.mapParametersToArguments(signature, call);
            if (argInfos == null) {
                return true;
            }
            paramInds.forEach(i2 -> {
                PsiType type = GrClosureSignatureUtil.getTypeByArg(argInfos[i2], manager, resolveScope);
                types[i2] = TypesUtil.getLeastUpperBoundNullable(type, types[i2], manager);
            });
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 6, 8, 10, 11, 12, 13, 15, 16, 17, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/convertToJava/TypeProvider";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/convertToJava/TypeProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableTypeInner";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterType";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "inferMethodParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVarType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getVariableTypeInner";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getParameterType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "inferMethodParameters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 6, 8, 10, 11, 12, 13, 15, 16, 17, 18, 19 -> new IllegalStateException(string);
        };
    }
}

