/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.util.CompileStaticUtil;
import org.jetbrains.plugins.groovy.lang.resolve.BaseGroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.references.GrConstructorReference;
import org.jetbrains.plugins.groovy.lang.resolve.references.GrLiteralConstructorReferenceKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\tH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014R\"\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010j\u0004\u0018\u0001`\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/references/GrLiteralConstructorReference;", "Lorg/jetbrains/plugins/groovy/lang/resolve/references/GrConstructorReference;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/GrListOrMap;", "element", "<init>", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/GrListOrMap;)V", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "handleElementRename", "Lcom/intellij/psi/PsiElement;", "newElementName", "", "bindToElement", "doResolveClass", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "arguments", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "getArguments", "()Ljava/util/List;", "supportsEnclosingInstance", "", "getSupportsEnclosingInstance", "()Z", "intellij.groovy.psi"})
public final class GrLiteralConstructorReference
extends GrConstructorReference<GrListOrMap> {
    public GrLiteralConstructorReference(@NotNull GrListOrMap element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element);
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = TextRange.EMPTY_RANGE;
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"EMPTY_RANGE");
        return textRange;
    }

    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) {
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        PsiElement psiElement = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        return psiElement;
    }

    @NotNull
    public PsiElement bindToElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element;
    }

    @Override
    @Nullable
    protected GroovyResolveResult doResolveClass() {
        boolean fallsBackToConstructor;
        PsiElement psiElement = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        GrListOrMap literal = (GrListOrMap)psiElement;
        boolean cs = CompileStaticUtil.isCompileStatic(literal);
        PsiType psiType = GrLiteralConstructorReferenceKt.access$getExpectedType(literal, cs);
        PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
        if (psiClassType == null) {
            return null;
        }
        PsiClassType lType = psiClassType;
        PsiClassType.ClassResolveResult classResolveResult = lType.resolveGenerics();
        Intrinsics.checkNotNullExpressionValue((Object)classResolveResult, (String)"resolveGenerics(...)");
        PsiClassType.ClassResolveResult resolveResult = classResolveResult;
        PsiClass psiClass = resolveResult.getElement();
        if (psiClass == null) {
            return null;
        }
        PsiClass clazz = psiClass;
        boolean bl = fallsBackToConstructor = cs ? GrLiteralConstructorReferenceKt.access$fallsBackToConstructorCS(clazz, literal) : GrLiteralConstructorReferenceKt.access$fallsBackToConstructor(clazz, literal);
        if (fallsBackToConstructor) {
            PsiElement psiElement2 = (PsiElement)clazz;
            PsiElement psiElement3 = literal;
            PsiSubstitutor psiSubstitutor = resolveResult.getSubstitutor();
            Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"getSubstitutor(...)");
            return new BaseGroovyResolveResult(psiElement2, psiElement3, null, psiSubstitutor, null, 20, null);
        }
        return null;
    }

    @Override
    @Nullable
    public List<Argument> getArguments() {
        PsiElement psiElement = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        return GrLiteralConstructorReferenceKt.access$getArguments((GrListOrMap)psiElement);
    }

    @Override
    protected boolean getSupportsEnclosingInstance() {
        return false;
    }
}

