/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.facet.impl.ui.libraries.LibraryCompositionSettings;
import com.intellij.facet.impl.ui.libraries.LibraryOptionsPanel;
import com.intellij.framework.library.FrameworkLibraryVersionFilter;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.config.GroovyLibraryDescription;

public final class GroovySdkForNewModuleWizardStep
extends ModuleWizardStep {
    private final String myBasePath;
    private final LibrariesContainer myLibrariesContainer;
    private final Disposable myDisposable;
    @Nullable
    private final ModuleWizardStep myJavaStep;
    private LibraryOptionsPanel myPanel;
    private LibraryCompositionSettings myLibraryCompositionSettings;
    private boolean myDownloaded;

    GroovySdkForNewModuleWizardStep(@NotNull ModuleBuilder moduleBuilder, @NotNull SettingsStep settingsStep) {
        if (moduleBuilder == null) {
            GroovySdkForNewModuleWizardStep.$$$reportNull$$$0(0);
        }
        if (settingsStep == null) {
            GroovySdkForNewModuleWizardStep.$$$reportNull$$$0(1);
        }
        this.myBasePath = moduleBuilder.getContentEntryPath();
        WizardContext wizardContext = settingsStep.getContext();
        this.myLibrariesContainer = wizardContext.getModulesProvider() == null ? LibrariesContainerFactory.createContainer((Project)wizardContext.getProject()) : LibrariesContainerFactory.createContainer((WizardContext)wizardContext, (ModulesProvider)wizardContext.getModulesProvider());
        this.myDisposable = wizardContext.getDisposable();
        moduleBuilder.addModuleConfigurationUpdater(this.createModuleConfigurationUpdater());
        this.myJavaStep = JavaModuleType.getModuleType().modifyProjectTypeStep(settingsStep, moduleBuilder);
        settingsStep.addSettingsField(GroovyBundle.message("groovy.library.label", new Object[0]), (JComponent)this.getPanel().getSimplePanel());
    }

    private ModuleBuilder.ModuleConfigurationUpdater createModuleConfigurationUpdater() {
        return new ModuleBuilder.ModuleConfigurationUpdater(){

            public void update(@NotNull Module module, @NotNull ModifiableRootModel rootModel) {
                if (module == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (rootModel == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (GroovySdkForNewModuleWizardStep.this.myLibraryCompositionSettings != null) {
                    GroovySdkForNewModuleWizardStep.this.myLibraryCompositionSettings.addLibraries(rootModel, new ArrayList(), GroovySdkForNewModuleWizardStep.this.myLibrariesContainer);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "module";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rootModel";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/groovy/config/GroovySdkForNewModuleWizardStep$1";
                objectArray[2] = "update";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public JComponent getComponent() {
        return this.getPanel().getMainPanel();
    }

    public String getHelpId() {
        return "reference.dialogs.new.project.fromScratch.groovy";
    }

    public boolean validate() throws ConfigurationException {
        return super.validate() && (this.myJavaStep == null || this.myJavaStep.validate());
    }

    public void updateDataModel() {
        this.myLibraryCompositionSettings = this.getPanel().apply();
        if (this.myJavaStep != null) {
            this.myJavaStep.updateDataModel();
        }
    }

    public void _commit(boolean finishChosen) {
        if (finishChosen && !this.myDownloaded && this.myLibraryCompositionSettings != null && this.myLibraryCompositionSettings.downloadFiles(this.getPanel().getMainPanel())) {
            this.myDownloaded = true;
        }
    }

    private LibraryOptionsPanel getPanel() {
        if (this.myPanel == null) {
            GroovyLibraryDescription libraryDescription = new GroovyLibraryDescription();
            String baseDirPath = this.myBasePath != null ? FileUtil.toSystemIndependentName((String)this.myBasePath) : "";
            this.myPanel = new LibraryOptionsPanel((CustomLibraryDescription)libraryDescription, baseDirPath, FrameworkLibraryVersionFilter.ALL, this.myLibrariesContainer, false);
            Disposer.register((Disposable)this.myDisposable, (Disposable)this.myPanel);
        }
        return this.myPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "moduleBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "settingsStep";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/config/GroovySdkForNewModuleWizardStep";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

