/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.core.trace.dsl.impl;

import com.intellij.debugger.streams.core.trace.dsl.ArrayVariable;
import com.intellij.debugger.streams.core.trace.dsl.CodeBlock;
import com.intellij.debugger.streams.core.trace.dsl.CodeContext;
import com.intellij.debugger.streams.core.trace.dsl.CompositeCodeBlock;
import com.intellij.debugger.streams.core.trace.dsl.Convertable;
import com.intellij.debugger.streams.core.trace.dsl.Dsl;
import com.intellij.debugger.streams.core.trace.dsl.Expression;
import com.intellij.debugger.streams.core.trace.dsl.ForLoopBody;
import com.intellij.debugger.streams.core.trace.dsl.IfBranch;
import com.intellij.debugger.streams.core.trace.dsl.Lambda;
import com.intellij.debugger.streams.core.trace.dsl.LambdaBody;
import com.intellij.debugger.streams.core.trace.dsl.ListVariable;
import com.intellij.debugger.streams.core.trace.dsl.MapVariable;
import com.intellij.debugger.streams.core.trace.dsl.Statement;
import com.intellij.debugger.streams.core.trace.dsl.StatementFactory;
import com.intellij.debugger.streams.core.trace.dsl.TryBlock;
import com.intellij.debugger.streams.core.trace.dsl.Types;
import com.intellij.debugger.streams.core.trace.dsl.Variable;
import com.intellij.debugger.streams.core.trace.dsl.VariableDeclaration;
import com.intellij.debugger.streams.core.trace.dsl.impl.TextExpression;
import com.intellij.debugger.streams.core.trace.impl.handler.type.GenericType;
import com.intellij.debugger.streams.core.wrapper.IntermediateStreamCall;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001DB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J!\u0010\u0016\u001a\u00020\u00152\u0017\u0010\u0017\u001a\u0013\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018\u00a2\u0006\u0002\b\u001bH\u0016J!\u0010\u001c\u001a\u00020\u001d2\u0017\u0010\u0017\u001a\u0013\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018\u00a2\u0006\u0002\b\u001bH\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J)\u0010!\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00132\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070#\"\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010$J\u0018\u0010%\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u0007H\u0016J9\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070#\"\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010+J\u0018\u0010,\u001a\u00020-2\u0006\u0010 \u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J)\u0010.\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00132\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070#\"\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010$J9\u0010/\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070#\"\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010+J/\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u00152\u001d\u0010\u0017\u001a\u0019\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001a03\u00a2\u0006\u0002\b\u001bH\u0016J \u00105\u001a\u0002062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u000206H\u0016J\b\u0010:\u001a\u00020\u0007H\u0016J\b\u0010;\u001a\u00020\u0007H\u0016J\b\u0010<\u001a\u00020\u0007H\u0016J\u0018\u0010=\u001a\u00020>2\u0006\u0010 \u001a\u00020\u00132\u0006\u00100\u001a\u000201H\u0016J\u0015\u0010?\u001a\u00020\u0007*\u00020\u00072\u0006\u0010@\u001a\u00020\u0007H\u0096\u0004J\u0015\u0010A\u001a\u00020\u0007*\u00020\u00072\u0006\u0010@\u001a\u00020\u0007H\u0096\u0004J\u0015\u0010B\u001a\u00020\u0007*\u00020\u00072\u0006\u0010@\u001a\u00020\u0007H\u0096\u0004J\r\u0010C\u001a\u00020\u0007*\u00020\u0007H\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006E"}, d2={"Lcom/intellij/debugger/streams/core/trace/dsl/impl/DslImpl;", "Lcom/intellij/debugger/streams/core/trace/dsl/Dsl;", "statementFactory", "Lcom/intellij/debugger/streams/core/trace/dsl/StatementFactory;", "<init>", "(Lcom/intellij/debugger/streams/core/trace/dsl/StatementFactory;)V", "nullExpression", "Lcom/intellij/debugger/streams/core/trace/dsl/Expression;", "getNullExpression", "()Lcom/intellij/debugger/streams/core/trace/dsl/Expression;", "thisExpression", "getThisExpression", "types", "Lcom/intellij/debugger/streams/core/trace/dsl/Types;", "getTypes", "()Lcom/intellij/debugger/streams/core/trace/dsl/Types;", "variable", "Lcom/intellij/debugger/streams/core/trace/dsl/Variable;", "type", "Lcom/intellij/debugger/streams/core/trace/impl/handler/type/GenericType;", "name", "", "code", "init", "Lkotlin/Function1;", "Lcom/intellij/debugger/streams/core/trace/dsl/CodeContext;", "", "Lkotlin/ExtensionFunctionType;", "block", "Lcom/intellij/debugger/streams/core/trace/dsl/CodeBlock;", "array", "Lcom/intellij/debugger/streams/core/trace/dsl/ArrayVariable;", "elementType", "newArray", "args", "", "(Lcom/intellij/debugger/streams/core/trace/impl/handler/type/GenericType;[Lcom/intellij/debugger/streams/core/trace/dsl/Expression;)Lcom/intellij/debugger/streams/core/trace/dsl/Expression;", "newSizedArray", "size", "map", "Lcom/intellij/debugger/streams/core/trace/dsl/MapVariable;", "keyType", "valueType", "(Lcom/intellij/debugger/streams/core/trace/impl/handler/type/GenericType;Lcom/intellij/debugger/streams/core/trace/impl/handler/type/GenericType;Ljava/lang/String;[Lcom/intellij/debugger/streams/core/trace/dsl/Expression;)Lcom/intellij/debugger/streams/core/trace/dsl/MapVariable;", "list", "Lcom/intellij/debugger/streams/core/trace/dsl/ListVariable;", "newList", "linkedMap", "lambda", "Lcom/intellij/debugger/streams/core/trace/dsl/Lambda;", "argName", "Lkotlin/Function2;", "Lcom/intellij/debugger/streams/core/trace/dsl/LambdaBody;", "declaration", "Lcom/intellij/debugger/streams/core/trace/dsl/VariableDeclaration;", "isMutable", "", "timeDeclaration", "currentTime", "updateTime", "currentNanoseconds", "createPeekCall", "Lcom/intellij/debugger/streams/core/wrapper/IntermediateStreamCall;", "and", "right", "equals", "same", "not", "MyContext", "intellij.debugger.streams.core"})
public final class DslImpl
implements Dsl {
    @NotNull
    private final StatementFactory statementFactory;
    @NotNull
    private final Expression nullExpression;
    @NotNull
    private final Expression thisExpression;
    @NotNull
    private final Types types;

    public DslImpl(@NotNull StatementFactory statementFactory) {
        Intrinsics.checkNotNullParameter((Object)statementFactory, (String)"statementFactory");
        this.statementFactory = statementFactory;
        this.nullExpression = new TextExpression("null");
        this.thisExpression = new TextExpression("this");
        this.types = this.statementFactory.getTypes();
    }

    @Override
    @NotNull
    public Expression getNullExpression() {
        return this.nullExpression;
    }

    @Override
    @NotNull
    public Expression getThisExpression() {
        return this.thisExpression;
    }

    @Override
    @NotNull
    public Types getTypes() {
        return this.types;
    }

    @Override
    @NotNull
    public Variable variable(@NotNull GenericType type, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.statementFactory.createVariable(type, name);
    }

    @Override
    @NotNull
    public String code(@NotNull Function1<? super CodeContext, Unit> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        MyContext fragment = new MyContext();
        init.invoke((Object)fragment);
        return fragment.toCode(0);
    }

    @Override
    @NotNull
    public CodeBlock block(@NotNull Function1<? super CodeContext, Unit> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        MyContext fragment = new MyContext();
        init.invoke((Object)fragment);
        return fragment;
    }

    @Override
    @NotNull
    public ArrayVariable array(@NotNull GenericType elementType, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.statementFactory.createArrayVariable(elementType, name);
    }

    @Override
    @NotNull
    public Expression newArray(@NotNull GenericType elementType, Expression ... args) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return this.statementFactory.createNewArrayExpression(elementType, args);
    }

    @Override
    @NotNull
    public Expression newSizedArray(@NotNull GenericType elementType, @NotNull Expression size) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        return this.statementFactory.createNewSizedArray(elementType, size);
    }

    @Override
    @NotNull
    public MapVariable map(@NotNull GenericType keyType, @NotNull GenericType valueType, @NotNull String name, Expression ... args) {
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return this.statementFactory.createMapVariable(keyType, valueType, name, false, args);
    }

    @Override
    @NotNull
    public ListVariable list(@NotNull GenericType elementType, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.statementFactory.createListVariable(elementType, name);
    }

    @Override
    @NotNull
    public Expression newList(@NotNull GenericType elementType, Expression ... args) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return this.statementFactory.createNewListExpression(elementType, Arrays.copyOf(args, args.length));
    }

    @Override
    @NotNull
    public MapVariable linkedMap(@NotNull GenericType keyType, @NotNull GenericType valueType, @NotNull String name, Expression ... args) {
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return this.statementFactory.createMapVariable(keyType, valueType, name, true, args);
    }

    @Override
    @NotNull
    public Lambda lambda(@NotNull String argName, @NotNull Function2<? super LambdaBody, ? super Expression, Unit> init) {
        Intrinsics.checkNotNullParameter((Object)argName, (String)"argName");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        LambdaBody lambdaBody = this.statementFactory.createEmptyLambdaBody(argName);
        init.invoke((Object)lambdaBody, (Object)this.getExpr(argName));
        return this.statementFactory.createLambda(argName, lambdaBody);
    }

    @Override
    @NotNull
    public VariableDeclaration declaration(@NotNull Variable variable, @NotNull Expression init, boolean isMutable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)init, (String)"init");
        return this.statementFactory.createVariableDeclaration(variable, init, isMutable);
    }

    @Override
    @NotNull
    public VariableDeclaration timeDeclaration() {
        return this.statementFactory.createTimeVariableDeclaration();
    }

    @Override
    @NotNull
    public Expression currentTime() {
        return this.statementFactory.currentTimeExpression();
    }

    @Override
    @NotNull
    public Expression updateTime() {
        return this.statementFactory.updateCurrentTimeExpression();
    }

    @Override
    @NotNull
    public Expression currentNanoseconds() {
        return this.statementFactory.currentNanosecondsExpression();
    }

    @Override
    @NotNull
    public IntermediateStreamCall createPeekCall(@NotNull GenericType elementType, @NotNull Lambda lambda) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)lambda, (String)"lambda");
        return this.statementFactory.createPeekCall(elementType, lambda);
    }

    @Override
    @NotNull
    public Expression and(@NotNull Expression $this$and, @NotNull Expression right) {
        Intrinsics.checkNotNullParameter((Object)$this$and, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return this.statementFactory.and($this$and, right);
    }

    @Override
    @NotNull
    public Expression equals(@NotNull Expression $this$equals, @NotNull Expression right) {
        Intrinsics.checkNotNullParameter((Object)$this$equals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return this.statementFactory.equals($this$equals, right);
    }

    @Override
    @NotNull
    public Expression same(@NotNull Expression $this$same, @NotNull Expression right) {
        Intrinsics.checkNotNullParameter((Object)$this$same, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return this.statementFactory.same($this$same, right);
    }

    @Override
    @NotNull
    public Expression not(@NotNull Expression $this$not) {
        Intrinsics.checkNotNullParameter((Object)$this$not, (String)"<this>");
        return this.statementFactory.not($this$not);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0096\u0001J\u0015\u0010\t\u001a\u00020\n*\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0096\u0005J\u0019\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096\u0001J\u0015\u0010\u0012\u001a\u00020\u0007*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0096\u0005J\"\u0010\b\u001a\u00020\u00032\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u0016\u00a2\u0006\u0002\b\u0017H\u0096\u0001J2\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00112\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u001c\"\u00020\nH\u0096\u0001\u00a2\u0006\u0002\u0010\u001dJ\"\u0010\u001e\u001a\u00020\u00112\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u0016\u00a2\u0006\u0002\b\u0017H\u0096\u0001J\u0019\u0010\u001f\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"H\u0096\u0001J\t\u0010#\u001a\u00020\nH\u0096\u0001J\t\u0010$\u001a\u00020\nH\u0096\u0001J!\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010(\u001a\u00020)H\u0096\u0001J\u0011\u0010*\u001a\u00020\u00132\u0006\u0010%\u001a\u00020&H\u0096\u0001J\u0019\u0010*\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020)H\u0096\u0001J!\u0010*\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010(\u001a\u00020)H\u0096\u0001J\u0011\u0010+\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\nH\u0096\u0001J\u0015\u0010,\u001a\u00020\n*\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0096\u0005J2\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\n2\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u00070\u0016\u00a2\u0006\u0002\b\u0017H\u0096\u0001J:\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u00020&2\u0006\u00103\u001a\u00020\n2\u0006\u00104\u001a\u00020\n2\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u00070\u0016\u00a2\u0006\u0002\b\u0017H\u0096\u0001J\u000f\u00105\u001a\b\u0012\u0004\u0012\u00020706H\u0096\u0001J*\u00108\u001a\u0002092\u0006\u00103\u001a\u00020\n2\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0016\u00a2\u0006\u0002\b\u0017H\u0096\u0001J0\u0010!\u001a\u00020\"2\u0006\u0010:\u001a\u00020\u00112\u001d\u0010\u0015\u001a\u0019\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070;\u00a2\u0006\u0002\b\u0017H\u0096\u0001J:\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u000f2\u0006\u0010@\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u001c\"\u00020\nH\u0096\u0001\u00a2\u0006\u0002\u0010AJ\u0019\u0010B\u001a\u00020C2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096\u0001J:\u0010D\u001a\u00020>2\u0006\u0010?\u001a\u00020\u000f2\u0006\u0010@\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u001c\"\u00020\nH\u0096\u0001\u00a2\u0006\u0002\u0010AJ*\u0010E\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u001c\"\u00020\nH\u0096\u0001\u00a2\u0006\u0002\u0010FJ*\u0010G\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u001c\"\u00020\nH\u0096\u0001\u00a2\u0006\u0002\u0010FJ\u0019\u0010H\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010I\u001a\u00020\nH\u0096\u0001J\u0019\u0010H\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010I\u001a\u00020JH\u0096\u0001J\r\u0010K\u001a\u00020\n*\u00020\nH\u0096\u0003J\u0015\u0010L\u001a\u00020\n*\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0096\u0005J\"\u0010M\u001a\u00020\u00072\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0016\u00a2\u0006\u0002\b\u0017H\u0096\u0001J\u0017\u0010N\u001a\u00020\u00072\f\u0010N\u001a\b\u0012\u0004\u0012\u00020P0OH\u0096\u0001J\t\u0010Q\u001a\u00020&H\u0096\u0001J\u0011\u0010R\u001a\u00020\u00112\u0006\u0010S\u001a\u00020JH\u0097\u0001J\"\u0010T\u001a\u00020U2\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0016\u00a2\u0006\u0002\b\u0017H\u0096\u0001J\r\u0010V\u001a\u00020\u0007*\u00020PH\u0096\u0003J\t\u0010W\u001a\u00020\nH\u0096\u0001J\u0019\u0010'\u001a\u00020\u00132\u0006\u0010X\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096\u0001J\u0015\u0010Y\u001a\u00020\u0011*\u00020\u00112\u0006\u0010S\u001a\u00020JH\u0096\u0001R\u0018\u0010Z\u001a\u00020\n*\u00020\u00118VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b[\u0010\\R\u0012\u0010]\u001a\u00020\nX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b^\u0010_R\u0012\u0010I\u001a\u00020JX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b`\u0010aR\u0012\u0010b\u001a\u00020\nX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bc\u0010_R\u0012\u0010d\u001a\u00020eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bf\u0010g\u00a8\u0006h"}, d2={"Lcom/intellij/debugger/streams/core/trace/dsl/impl/DslImpl$MyContext;", "Lcom/intellij/debugger/streams/core/trace/dsl/CodeContext;", "Lcom/intellij/debugger/streams/core/trace/dsl/Dsl;", "Lcom/intellij/debugger/streams/core/trace/dsl/CodeBlock;", "<init>", "(Lcom/intellij/debugger/streams/core/trace/dsl/impl/DslImpl;)V", "add", "", "block", "and", "Lcom/intellij/debugger/streams/core/trace/dsl/Expression;", "right", "array", "Lcom/intellij/debugger/streams/core/trace/dsl/ArrayVariable;", "elementType", "Lcom/intellij/debugger/streams/core/trace/impl/handler/type/GenericType;", "name", "", "assign", "Lcom/intellij/debugger/streams/core/trace/dsl/Variable;", "expression", "init", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "call", "receiver", "methodName", "args", "", "(Lcom/intellij/debugger/streams/core/trace/dsl/Expression;Ljava/lang/String;[Lcom/intellij/debugger/streams/core/trace/dsl/Expression;)Lcom/intellij/debugger/streams/core/trace/dsl/Expression;", "code", "createPeekCall", "Lcom/intellij/debugger/streams/core/wrapper/IntermediateStreamCall;", "lambda", "Lcom/intellij/debugger/streams/core/trace/dsl/Lambda;", "currentNanoseconds", "currentTime", "declaration", "Lcom/intellij/debugger/streams/core/trace/dsl/VariableDeclaration;", "variable", "isMutable", "", "declare", "doReturn", "equals", "forEachLoop", "iterateVariable", "collection", "Lcom/intellij/debugger/streams/core/trace/dsl/ForLoopBody;", "forLoop", "initialization", "condition", "afterThought", "getStatements", "", "Lcom/intellij/debugger/streams/core/trace/dsl/Convertable;", "ifBranch", "Lcom/intellij/debugger/streams/core/trace/dsl/IfBranch;", "argName", "Lkotlin/Function2;", "Lcom/intellij/debugger/streams/core/trace/dsl/LambdaBody;", "linkedMap", "Lcom/intellij/debugger/streams/core/trace/dsl/MapVariable;", "keyType", "valueType", "(Lcom/intellij/debugger/streams/core/trace/impl/handler/type/GenericType;Lcom/intellij/debugger/streams/core/trace/impl/handler/type/GenericType;Ljava/lang/String;[Lcom/intellij/debugger/streams/core/trace/dsl/Expression;)Lcom/intellij/debugger/streams/core/trace/dsl/MapVariable;", "list", "Lcom/intellij/debugger/streams/core/trace/dsl/ListVariable;", "map", "newArray", "(Lcom/intellij/debugger/streams/core/trace/impl/handler/type/GenericType;[Lcom/intellij/debugger/streams/core/trace/dsl/Expression;)Lcom/intellij/debugger/streams/core/trace/dsl/Expression;", "newList", "newSizedArray", "size", "", "not", "same", "scope", "statement", "Lkotlin/Function0;", "Lcom/intellij/debugger/streams/core/trace/dsl/Statement;", "timeDeclaration", "toCode", "indent", "tryBlock", "Lcom/intellij/debugger/streams/core/trace/dsl/TryBlock;", "unaryPlus", "updateTime", "type", "withIndent", "expr", "getExpr", "(Ljava/lang/String;)Lcom/intellij/debugger/streams/core/trace/dsl/Expression;", "nullExpression", "getNullExpression", "()Lcom/intellij/debugger/streams/core/trace/dsl/Expression;", "getSize", "()I", "thisExpression", "getThisExpression", "types", "Lcom/intellij/debugger/streams/core/trace/dsl/Types;", "getTypes", "()Lcom/intellij/debugger/streams/core/trace/dsl/Types;", "intellij.debugger.streams.core"})
    private final class MyContext
    implements CodeContext,
    Dsl,
    CodeBlock {
        private final /* synthetic */ DslImpl $$delegate_0;
        private final /* synthetic */ CompositeCodeBlock $$delegate_1;

        public MyContext() {
            this.$$delegate_0 = DslImpl.this;
            this.$$delegate_1 = DslImpl.this.statementFactory.createEmptyCompositeCodeBlock();
        }

        @Override
        @NotNull
        public Expression getNullExpression() {
            return this.$$delegate_0.getNullExpression();
        }

        @Override
        @NotNull
        public Expression getThisExpression() {
            return this.$$delegate_0.getThisExpression();
        }

        @Override
        @NotNull
        public Types getTypes() {
            return this.$$delegate_0.getTypes();
        }

        @Override
        @NotNull
        public CodeBlock block(@NotNull Function1<? super CodeContext, Unit> init) {
            Intrinsics.checkNotNullParameter(init, (String)"init");
            return this.$$delegate_0.block(init);
        }

        @Override
        @NotNull
        public String code(@NotNull Function1<? super CodeContext, Unit> init) {
            Intrinsics.checkNotNullParameter(init, (String)"init");
            return this.$$delegate_0.code(init);
        }

        @Override
        @NotNull
        public Lambda lambda(@NotNull String argName, @NotNull Function2<? super LambdaBody, ? super Expression, Unit> init) {
            Intrinsics.checkNotNullParameter((Object)argName, (String)"argName");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            return this.$$delegate_0.lambda(argName, init);
        }

        @Override
        @NotNull
        public Variable variable(@NotNull GenericType type, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.$$delegate_0.variable(type, name);
        }

        @Override
        @NotNull
        public ArrayVariable array(@NotNull GenericType elementType, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.$$delegate_0.array(elementType, name);
        }

        @Override
        @NotNull
        public ListVariable list(@NotNull GenericType elementType, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.$$delegate_0.list(elementType, name);
        }

        @Override
        @NotNull
        public Expression newList(@NotNull GenericType elementType, Expression ... args) {
            Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            return this.$$delegate_0.newList(elementType, args);
        }

        @Override
        @NotNull
        public Expression newArray(@NotNull GenericType elementType, Expression ... args) {
            Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            return this.$$delegate_0.newArray(elementType, args);
        }

        @Override
        @NotNull
        public Expression newSizedArray(@NotNull GenericType elementType, @NotNull Expression size) {
            Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
            Intrinsics.checkNotNullParameter((Object)size, (String)"size");
            return this.$$delegate_0.newSizedArray(elementType, size);
        }

        @Override
        @NotNull
        public Expression newSizedArray(@NotNull GenericType elementType, int size) {
            Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
            return this.$$delegate_0.newSizedArray(elementType, size);
        }

        @Override
        @NotNull
        public MapVariable map(@NotNull GenericType keyType, @NotNull GenericType valueType, @NotNull String name, Expression ... args) {
            Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
            Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            return this.$$delegate_0.map(keyType, valueType, name, args);
        }

        @Override
        @NotNull
        public MapVariable linkedMap(@NotNull GenericType keyType, @NotNull GenericType valueType, @NotNull String name, Expression ... args) {
            Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
            Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            return this.$$delegate_0.linkedMap(keyType, valueType, name, args);
        }

        @Override
        @NotNull
        public VariableDeclaration declaration(@NotNull Variable variable, @NotNull Expression init, boolean isMutable) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)init, (String)"init");
            return this.$$delegate_0.declaration(variable, init, isMutable);
        }

        @Override
        @NotNull
        public Expression getExpr(@NotNull String $this$expr) {
            Intrinsics.checkNotNullParameter((Object)$this$expr, (String)"<this>");
            return this.$$delegate_0.getExpr($this$expr);
        }

        @Override
        @NotNull
        public Expression and(@NotNull Expression $this$and, @NotNull Expression right) {
            Intrinsics.checkNotNullParameter((Object)$this$and, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            return this.$$delegate_0.and($this$and, right);
        }

        @Override
        @NotNull
        public Expression equals(@NotNull Expression $this$equals, @NotNull Expression right) {
            Intrinsics.checkNotNullParameter((Object)$this$equals, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            return this.$$delegate_0.equals($this$equals, right);
        }

        @Override
        @NotNull
        public Expression same(@NotNull Expression $this$same, @NotNull Expression right) {
            Intrinsics.checkNotNullParameter((Object)$this$same, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            return this.$$delegate_0.same($this$same, right);
        }

        @Override
        @NotNull
        public Expression not(@NotNull Expression $this$not) {
            Intrinsics.checkNotNullParameter((Object)$this$not, (String)"<this>");
            return this.$$delegate_0.not($this$not);
        }

        @Override
        @NotNull
        public VariableDeclaration timeDeclaration() {
            return this.$$delegate_0.timeDeclaration();
        }

        @Override
        @NotNull
        public Expression currentTime() {
            return this.$$delegate_0.currentTime();
        }

        @Override
        @NotNull
        public Expression updateTime() {
            return this.$$delegate_0.updateTime();
        }

        @Override
        @NotNull
        public Expression currentNanoseconds() {
            return this.$$delegate_0.currentNanoseconds();
        }

        @Override
        @NotNull
        public IntermediateStreamCall createPeekCall(@NotNull GenericType elementType, @NotNull Lambda lambda) {
            Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
            Intrinsics.checkNotNullParameter((Object)lambda, (String)"lambda");
            return this.$$delegate_0.createPeekCall(elementType, lambda);
        }

        @Override
        public int getSize() {
            return this.$$delegate_1.getSize();
        }

        @Override
        @NotNull
        public Variable declare(@NotNull Variable variable, boolean isMutable) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            return this.$$delegate_1.declare(variable, isMutable);
        }

        @Override
        @NotNull
        public Variable declare(@NotNull Variable variable, @NotNull Expression init, boolean isMutable) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)init, (String)"init");
            return this.$$delegate_1.declare(variable, init, isMutable);
        }

        @Override
        @NotNull
        public Variable declare(@NotNull VariableDeclaration declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            return this.$$delegate_1.declare(declaration);
        }

        @Override
        public void forEachLoop(@NotNull Variable iterateVariable, @NotNull Expression collection, @NotNull Function1<? super ForLoopBody, Unit> init) {
            Intrinsics.checkNotNullParameter((Object)iterateVariable, (String)"iterateVariable");
            Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            this.$$delegate_1.forEachLoop(iterateVariable, collection, init);
        }

        @Override
        public void forLoop(@NotNull VariableDeclaration initialization, @NotNull Expression condition, @NotNull Expression afterThought, @NotNull Function1<? super ForLoopBody, Unit> init) {
            Intrinsics.checkNotNullParameter((Object)initialization, (String)"initialization");
            Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
            Intrinsics.checkNotNullParameter((Object)afterThought, (String)"afterThought");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            this.$$delegate_1.forLoop(initialization, condition, afterThought, init);
        }

        @Override
        @NotNull
        public TryBlock tryBlock(@NotNull Function1<? super CodeBlock, Unit> init) {
            Intrinsics.checkNotNullParameter(init, (String)"init");
            return this.$$delegate_1.tryBlock(init);
        }

        @Override
        public void scope(@NotNull Function1<? super CodeBlock, Unit> init) {
            Intrinsics.checkNotNullParameter(init, (String)"init");
            this.$$delegate_1.scope(init);
        }

        @Override
        @NotNull
        public IfBranch ifBranch(@NotNull Expression condition, @NotNull Function1<? super CodeBlock, Unit> init) {
            Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            return this.$$delegate_1.ifBranch(condition, init);
        }

        @Override
        @NotNull
        public Expression call(@NotNull Expression receiver, @NotNull String methodName, Expression ... args) {
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            return this.$$delegate_1.call(receiver, methodName, args);
        }

        @Override
        public void doReturn(@NotNull Expression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            this.$$delegate_1.doReturn(expression);
        }

        @Override
        public void statement(@NotNull Function0<? extends Statement> statement) {
            Intrinsics.checkNotNullParameter(statement, (String)"statement");
            this.$$delegate_1.statement(statement);
        }

        @Override
        public void unaryPlus(@NotNull Statement $this$unaryPlus) {
            Intrinsics.checkNotNullParameter((Object)$this$unaryPlus, (String)"<this>");
            this.$$delegate_1.unaryPlus($this$unaryPlus);
        }

        @Override
        public void assign(@NotNull Variable $this$assign, @NotNull Expression expression) {
            Intrinsics.checkNotNullParameter((Object)$this$assign, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            this.$$delegate_1.assign($this$assign, expression);
        }

        @Override
        public void add(@NotNull CodeBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            this.$$delegate_1.add(block);
        }

        @Override
        @NotNull
        public List<Convertable> getStatements() {
            return this.$$delegate_1.getStatements();
        }

        @Override
        @NonNls
        @NotNull
        public String toCode(int indent) {
            return this.$$delegate_1.toCode(indent);
        }

        @Override
        @NotNull
        public String withIndent(@NotNull String $this$withIndent, int indent) {
            Intrinsics.checkNotNullParameter((Object)$this$withIndent, (String)"<this>");
            return this.$$delegate_1.withIndent($this$withIndent, indent);
        }
    }
}

