/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.MVMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.incremental.storage.ExperimentalOutputToTargetMappingKt;
import org.jetbrains.jps.incremental.storage.ExperimentalSourceToOutputMapping;
import org.jetbrains.jps.incremental.storage.LongListAddItemDecisionMaker;
import org.jetbrains.jps.incremental.storage.LongListRemoveItemDecisionMaker;
import org.jetbrains.jps.incremental.storage.OutputToTargetMapping;
import org.jetbrains.jps.incremental.storage.PathTypeAwareRelativizer;
import org.jetbrains.jps.incremental.storage.RelativePathType;
import org.jetbrains.jps.incremental.storage.StorageManager;
import org.jetbrains.jps.incremental.storage.dataTypes.LongListKeyDataType;
import org.jetbrains.jps.incremental.storage.dataTypes.LongPairKeyDataType;
import org.jetbrains.jps.incremental.storage.dataTypes.LongPairKeyDataTypeKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J,\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J&\u0010\u0011\u001a\u00020\u00122\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J!\u0010\u0014\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000bR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/jps/incremental/storage/ExperimentalOutputToTargetMapping;", "Lorg/jetbrains/jps/incremental/storage/OutputToTargetMapping;", "storageManager", "Lorg/jetbrains/jps/incremental/storage/StorageManager;", "<init>", "(Lorg/jetbrains/jps/incremental/storage/StorageManager;)V", "map", "Lorg/h2/mvstore/MVMap;", "", "removeTargetAndGetSafeToDeleteOutputs", "", "", "outputPaths", "currentTargetId", "", "srcToOut", "Lorg/jetbrains/jps/builders/storage/SourceToOutputMapping;", "removeMappings", "", "buildTargetId", "addMappings", "normalizeOutputPaths", "", "targetHashId", "", "([Ljava/lang/String;J)V", "addMapping", "normalizeOutputPath", "removeTarget", "targetId", "targetTypeId", "intellij.platform.jps.build"})
@ApiStatus.Internal
public final class ExperimentalOutputToTargetMapping
implements OutputToTargetMapping {
    @NotNull
    private final MVMap<long[], long[]> map;

    public ExperimentalOutputToTargetMapping(@NotNull StorageManager storageManager) {
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        this.map = storageManager.openMap("out-to-target-v1", LongPairKeyDataType.INSTANCE, LongListKeyDataType.INSTANCE);
    }

    @Override
    @NotNull
    public Collection<String> removeTargetAndGetSafeToDeleteOutputs(@NotNull Collection<String> outputPaths, int currentTargetId, @NotNull SourceToOutputMapping srcToOut) {
        Intrinsics.checkNotNullParameter(outputPaths, (String)"outputPaths");
        Intrinsics.checkNotNullParameter((Object)srcToOut, (String)"srcToOut");
        int size = outputPaths.size();
        if (size == 0) {
            return CollectionsKt.emptyList();
        }
        ExperimentalSourceToOutputMapping cfr_ignored_0 = (ExperimentalSourceToOutputMapping)srcToOut;
        LongListRemoveItemDecisionMaker decisionMaker = new LongListRemoveItemDecisionMaker(((ExperimentalSourceToOutputMapping)srcToOut).targetHashId);
        PathTypeAwareRelativizer relativizer = ((ExperimentalSourceToOutputMapping)srcToOut).relativizer;
        ArrayList<String> result = new ArrayList<String>(size);
        for (String outPath : outputPaths) {
            long[] key = LongPairKeyDataTypeKt.stringTo128BitHash(relativizer.toRelative(outPath, RelativePathType.OUTPUT));
            this.map.operate((Object)key, null, (MVMap.DecisionMaker)decisionMaker);
            if (decisionMaker.outStillUsed) continue;
            result.add(outPath);
        }
        return result;
    }

    @Override
    public void removeMappings(@NotNull Collection<String> outputPaths, int buildTargetId, @NotNull SourceToOutputMapping srcToOut) {
        Intrinsics.checkNotNullParameter(outputPaths, (String)"outputPaths");
        Intrinsics.checkNotNullParameter((Object)srcToOut, (String)"srcToOut");
        ExperimentalSourceToOutputMapping cfr_ignored_0 = (ExperimentalSourceToOutputMapping)srcToOut;
        PathTypeAwareRelativizer relativizer = ((ExperimentalSourceToOutputMapping)srcToOut).relativizer;
        LongListRemoveItemDecisionMaker decisionMaker = new LongListRemoveItemDecisionMaker(((ExperimentalSourceToOutputMapping)srcToOut).targetHashId);
        for (String outPath : outputPaths) {
            long[] key = LongPairKeyDataTypeKt.stringTo128BitHash(relativizer.toRelative(outPath, RelativePathType.OUTPUT));
            this.map.operate((Object)key, null, (MVMap.DecisionMaker)decisionMaker);
        }
    }

    public final void addMappings(@NotNull String[] normalizeOutputPaths, long targetHashId) {
        Intrinsics.checkNotNullParameter((Object)normalizeOutputPaths, (String)"normalizeOutputPaths");
        LongListAddItemDecisionMaker decisionMaker = new LongListAddItemDecisionMaker(targetHashId);
        for (String outPath : normalizeOutputPaths) {
            this.map.operate((Object)LongPairKeyDataTypeKt.stringTo128BitHash(outPath), null, (MVMap.DecisionMaker)decisionMaker);
        }
    }

    public final void addMapping(@NotNull String normalizeOutputPath, long targetHashId) {
        Intrinsics.checkNotNullParameter((Object)normalizeOutputPath, (String)"normalizeOutputPath");
        LongListAddItemDecisionMaker decisionMaker = new LongListAddItemDecisionMaker(targetHashId);
        this.map.operate((Object)LongPairKeyDataTypeKt.stringTo128BitHash(normalizeOutputPath), null, (MVMap.DecisionMaker)decisionMaker);
    }

    public final void removeTarget(@NotNull String targetId, @NotNull String targetTypeId) {
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)targetTypeId, (String)"targetTypeId");
        Cursor iterator = this.map.cursor(null);
        LongListRemoveItemDecisionMaker decisionMaker = new LongListRemoveItemDecisionMaker(ExperimentalOutputToTargetMappingKt.targetToHash(targetId, targetTypeId));
        while (iterator.hasNext()) {
            this.map.operate(iterator.next(), null, (MVMap.DecisionMaker)decisionMaker);
        }
    }
}

