/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.relativizer;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.relativizer.PathRelativizer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0010\u0018\u00002\u00020\u0001B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/jps/incremental/relativizer/CommonPathRelativizer;", "Lorg/jetbrains/jps/incremental/relativizer/PathRelativizer;", "basePath", "", "identifier", "isCaseSensitive", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Z)V", "toRelativePath", "path", "toAbsolutePath", "intellij.platform.jps.build"})
public class CommonPathRelativizer
implements PathRelativizer {
    @NotNull
    private final String basePath;
    @NotNull
    private final String identifier;
    private final boolean isCaseSensitive;

    @JvmOverloads
    public CommonPathRelativizer(@NotNull String basePath, @NotNull String identifier, boolean isCaseSensitive) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        this.basePath = basePath;
        this.identifier = identifier;
        this.isCaseSensitive = isCaseSensitive;
    }

    public /* synthetic */ CommonPathRelativizer(String string, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = SystemInfoRt.isFileSystemCaseSensitive;
        }
        this(string, string2, bl);
    }

    @Override
    @Nullable
    public String toRelativePath(@NotNull String path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (FileUtil.startsWith((String)path, (String)this.basePath, (boolean)this.isCaseSensitive)) {
            String string2 = path.substring(this.basePath.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            string = this.identifier + string2;
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @Nullable
    public String toAbsolutePath(@NotNull String path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (StringsKt.startsWith$default((String)path, (String)this.identifier, (boolean)false, (int)2, null)) {
            String string2 = path.substring(this.identifier.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            string = this.basePath + string2;
        } else {
            string = null;
        }
        return string;
    }

    @JvmOverloads
    public CommonPathRelativizer(@NotNull String basePath, @NotNull String identifier) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        this(basePath, identifier, false, 4, null);
    }
}

