/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.instructions;

import com.dynatrace.hash4j.hashing.HashSink;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTarget;
import org.jetbrains.jps.incremental.artifacts.ArtifactOutputToSourceMapping;
import org.jetbrains.jps.incremental.artifacts.IncArtifactBuilder;
import org.jetbrains.jps.incremental.artifacts.impl.JpsArtifactPathUtil;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.DestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.FileCopyingHandler;
import org.jetbrains.jps.incremental.artifacts.instructions.SourceFileFilter;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;

@ApiStatus.Internal
public final class FileBasedArtifactRootDescriptor
extends ArtifactRootDescriptor {
    private static final Logger LOG = Logger.getInstance(FileBasedArtifactRootDescriptor.class);
    private final FileCopyingHandler myCopyingHandler;

    public FileBasedArtifactRootDescriptor(@NotNull File file, @NotNull SourceFileFilter filter, int index, ArtifactBuildTarget target, @NotNull DestinationInfo destinationInfo, FileCopyingHandler copyingHandler) {
        if (file == null) {
            FileBasedArtifactRootDescriptor.$$$reportNull$$$0(0);
        }
        if (filter == null) {
            FileBasedArtifactRootDescriptor.$$$reportNull$$$0(1);
        }
        if (destinationInfo == null) {
            FileBasedArtifactRootDescriptor.$$$reportNull$$$0(2);
        }
        super(file, FileBasedArtifactRootDescriptor.createCompositeFilter(filter, copyingHandler.createFileFilter()), index, target, destinationInfo);
        this.myCopyingHandler = copyingHandler;
    }

    private static SourceFileFilter createCompositeFilter(SourceFileFilter baseFilter, FileFilter filter) {
        return filter == FileFilters.EVERYTHING ? baseFilter : new CompositeSourceFileFilter(baseFilter, filter);
    }

    @Override
    protected String getFullPath() {
        return this.myRoot.getPath();
    }

    @Override
    public void writeConfiguration(@NotNull HashSink hash, PathRelativizerService relativizer) {
        if (hash == null) {
            FileBasedArtifactRootDescriptor.$$$reportNull$$$0(3);
        }
        super.writeConfiguration(hash, relativizer);
        this.myCopyingHandler.writeConfiguration(hash);
    }

    @Override
    public void copyFromRoot(String filePath, int rootIndex, String outputPath, CompileContext context, BuildOutputConsumer outputConsumer, ArtifactOutputToSourceMapping outSrcMapping) throws IOException, ProjectBuildException {
        String targetPath;
        File file = new File(filePath);
        if (!file.exists()) {
            return;
        }
        if (!FileUtil.filesEqual((File)file, (File)this.getRootFile())) {
            Path rootFile = this.getFile();
            String relativePath = FileUtil.getRelativePath((String)FileUtilRt.toSystemIndependentName((String)rootFile.toString()), (String)filePath, (char)'/');
            if (relativePath == null || relativePath.startsWith("..")) {
                throw new ProjectBuildException((Throwable)((Object)new AssertionError((Object)(filePath + " is not under " + String.valueOf(rootFile)))));
            }
            targetPath = JpsArtifactPathUtil.appendToPath(outputPath, relativePath);
        } else {
            targetPath = outputPath;
        }
        File targetFile = new File(targetPath);
        if (FileUtil.filesEqual((File)file, (File)targetFile)) {
            return;
        }
        if (outSrcMapping.getState(targetPath) == null) {
            ProjectBuilderLogger logger = context.getLoggingManager().getProjectBuilderLogger();
            if (logger.isEnabled()) {
                logger.logCompiledFiles(Collections.singletonList(file), "artifacts-builder", "Copying file:");
            }
            try {
                this.myCopyingHandler.copyFile(file, targetFile, context);
            }
            catch (IOException e) {
                context.processMessage(new CompilerMessage(IncArtifactBuilder.getBuilderName(), BuildMessage.Kind.ERROR, CompilerMessage.getTextFromThrowable(e)));
                return;
            }
            outputConsumer.registerOutputFile(targetFile, Collections.singletonList(filePath));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Target path " + targetPath + " is already registered so " + filePath + " won't be copied");
        }
        outSrcMapping.appendData(targetPath, rootIndex, filePath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/incremental/artifacts/instructions/FileBasedArtifactRootDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "writeConfiguration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class CompositeSourceFileFilter
    extends SourceFileFilter {
        private final SourceFileFilter myBaseFilter;
        private final FileFilter myFilter;

        CompositeSourceFileFilter(SourceFileFilter baseFilter, FileFilter filter) {
            this.myBaseFilter = baseFilter;
            this.myFilter = filter;
        }

        @Override
        public boolean accept(@NotNull String fullFilePath) {
            if (fullFilePath == null) {
                CompositeSourceFileFilter.$$$reportNull$$$0(0);
            }
            return this.myFilter.accept(new File(fullFilePath)) && this.myBaseFilter.accept(fullFilePath);
        }

        @Override
        public boolean shouldBeCopied(@NotNull String fullFilePath, ProjectDescriptor projectDescriptor) throws IOException {
            if (fullFilePath == null) {
                CompositeSourceFileFilter.$$$reportNull$$$0(1);
            }
            return this.myBaseFilter.shouldBeCopied(fullFilePath, projectDescriptor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "fullFilePath";
            objectArray2[1] = "org/jetbrains/jps/incremental/artifacts/instructions/FileBasedArtifactRootDescriptor$CompositeSourceFileFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldBeCopied";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

