/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.CollectionFactory;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.incremental.BuildTask;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.BuilderService;
import org.jetbrains.jps.incremental.JvmClassFileInstrumenter;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.jps.service.JpsServiceManager;

public final class BuilderRegistry {
    private static final Logger LOG = Logger.getInstance(BuilderRegistry.class);
    private final Map<BuilderCategory, List<ModuleLevelBuilder>> myModuleLevelBuilders = new HashMap<BuilderCategory, List<ModuleLevelBuilder>>();
    private final List<JvmClassFileInstrumenter> myClassFileInstrumenters = new ArrayList<JvmClassFileInstrumenter>();
    private final Object2LongMap<BuildTargetType<?>> myExpectedBuildTime = new Object2LongOpenHashMap();
    private final List<TargetBuilder<?, ?>> myTargetBuilders = new ArrayList();
    private final FileFilter myModuleBuilderFileFilter;

    @NotNull
    public static BuilderRegistry getInstance() {
        BuilderRegistry builderRegistry = Holder.ourInstance;
        if (builderRegistry == null) {
            BuilderRegistry.$$$reportNull$$$0(0);
        }
        return builderRegistry;
    }

    private BuilderRegistry() {
        for (BuilderCategory category : BuilderCategory.values()) {
            this.myModuleLevelBuilders.put(category, new ArrayList());
        }
        Set compilableFileExtensions = CollectionFactory.createFilePathSet();
        for (BuilderService service : JpsServiceManager.getInstance().getExtensions(BuilderService.class)) {
            this.myTargetBuilders.addAll(service.createBuilders());
            for (ModuleLevelBuilder moduleLevelBuilder : service.createModuleLevelBuilders()) {
                try {
                    List<String> extensions = moduleLevelBuilder.getCompilableFileExtensions();
                    if (compilableFileExtensions != null) {
                        compilableFileExtensions.addAll(extensions);
                    }
                }
                catch (AbstractMethodError e) {
                    LOG.info(moduleLevelBuilder.getClass().getName() + " builder doesn't implement 'getCompilableFileExtensions' method so ModuleBuildTarget will process all files under source roots.");
                    compilableFileExtensions = null;
                }
                this.myModuleLevelBuilders.get((Object)moduleLevelBuilder.getCategory()).add(moduleLevelBuilder);
                if (!(moduleLevelBuilder instanceof JvmClassFileInstrumenter)) continue;
                this.myClassFileInstrumenters.add((JvmClassFileInstrumenter)((Object)moduleLevelBuilder));
            }
        }
        Collections.sort(this.myClassFileInstrumenters, Comparator.comparing(JvmClassFileInstrumenter::getId));
        Collections.sort(this.myModuleLevelBuilders.get((Object)BuilderCategory.CLASS_INSTRUMENTER), Comparator.comparing(builder -> builder instanceof JvmClassFileInstrumenter ? ((JvmClassFileInstrumenter)((Object)builder)).getId() : builder.getPresentableName()));
        if (compilableFileExtensions == null) {
            this.myModuleBuilderFileFilter = FileFilters.EVERYTHING;
        } else {
            Set finalCompilableFileExtensions = compilableFileExtensions;
            this.myModuleBuilderFileFilter = file -> finalCompilableFileExtensions.contains(FileUtilRt.getExtension((String)file.getName()));
        }
        long moduleTargetBuildTime = 0L;
        for (ModuleLevelBuilder moduleLevelBuilder : this.getModuleLevelBuilders()) {
            moduleTargetBuildTime += moduleLevelBuilder.getExpectedBuildTime();
        }
        this.myExpectedBuildTime.put((Object)JavaModuleBuildTargetType.PRODUCTION, moduleTargetBuildTime);
        this.myExpectedBuildTime.put((Object)JavaModuleBuildTargetType.TEST, moduleTargetBuildTime);
        for (TargetBuilder targetBuilder : this.myTargetBuilders) {
            long buildTime = targetBuilder.getExpectedBuildTime();
            for (BuildTargetType type : targetBuilder.getTargetTypes()) {
                long total = this.myExpectedBuildTime.getLong(type);
                this.myExpectedBuildTime.put(type, total + buildTime);
            }
        }
    }

    @NotNull
    public FileFilter getModuleBuilderFileFilter() {
        FileFilter fileFilter = this.myModuleBuilderFileFilter;
        if (fileFilter == null) {
            BuilderRegistry.$$$reportNull$$$0(1);
        }
        return fileFilter;
    }

    public int getModuleLevelBuilderCount() {
        int count = 0;
        for (BuilderCategory category : BuilderCategory.values()) {
            count += this.getBuilders(category).size();
        }
        return count;
    }

    @ApiStatus.Internal
    @NotNull
    public List<JvmClassFileInstrumenter> getClassFileInstrumenters() {
        List<JvmClassFileInstrumenter> list = this.myClassFileInstrumenters;
        if (list == null) {
            BuilderRegistry.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public @Unmodifiable List<BuildTask> getBeforeTasks() {
        List<BuildTask> list = List.of();
        if (list == null) {
            BuilderRegistry.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public @Unmodifiable List<BuildTask> getAfterTasks() {
        List<BuildTask> list = List.of();
        if (list == null) {
            BuilderRegistry.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public @Unmodifiable List<ModuleLevelBuilder> getBuilders(BuilderCategory category) {
        List<ModuleLevelBuilder> list = Collections.unmodifiableList(this.myModuleLevelBuilders.get((Object)category));
        if (list == null) {
            BuilderRegistry.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public @Unmodifiable List<ModuleLevelBuilder> getModuleLevelBuilders() {
        ArrayList<ModuleLevelBuilder> result = new ArrayList<ModuleLevelBuilder>();
        for (BuilderCategory category : BuilderCategory.values()) {
            result.addAll(this.getBuilders(category));
        }
        ArrayList<ModuleLevelBuilder> arrayList = result;
        if (arrayList == null) {
            BuilderRegistry.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public @Unmodifiable List<TargetBuilder<?, ?>> getTargetBuilders() {
        List<TargetBuilder<?, ?>> list = this.myTargetBuilders;
        if (list == null) {
            BuilderRegistry.$$$reportNull$$$0(7);
        }
        return list;
    }

    public long getExpectedBuildTimeForTarget(BuildTargetType<?> targetType) {
        return this.myExpectedBuildTime.getLong(targetType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/jps/incremental/BuilderRegistry";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleBuilderFileFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassFileInstrumenters";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeforeTasks";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAfterTasks";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilders";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleLevelBuilders";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetBuilders";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static final class Holder {
        static final BuilderRegistry ourInstance = new BuilderRegistry();

        private Holder() {
        }
    }
}

