/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import java.io.IOException;
import java.lang.reflect.Array;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.dependency.Externalizer;
import org.jetbrains.jps.dependency.GraphDataInput;
import org.jetbrains.jps.dependency.GraphDataOutput;
import org.jetbrains.org.objectweb.asm.Type;

enum JvmProtoMemberValueExternalizer implements Externalizer<Object>
{
    NONE(null){

        @Override
        public void save(GraphDataOutput out, Object v) {
        }

        @Override
        public Object load(GraphDataInput in) {
            return null;
        }
    }
    ,
    STRING((Class)String.class){

        @Override
        public void save(GraphDataOutput out, Object v) throws IOException {
            out.writeUTF((String)v);
        }

        @Override
        public Object load(GraphDataInput in) throws IOException {
            return in.readUTF();
        }
    }
    ,
    INTEGER((Class)Integer.class){

        @Override
        public void save(GraphDataOutput out, Object v) throws IOException {
            out.writeInt((Integer)v);
        }

        @Override
        public Object load(GraphDataInput in) throws IOException {
            return in.readInt();
        }
    }
    ,
    LONG((Class)Long.class){

        @Override
        public void save(GraphDataOutput out, Object v) throws IOException {
            out.writeLong((Long)v);
        }

        @Override
        public Object load(GraphDataInput in) throws IOException {
            return in.readLong();
        }
    }
    ,
    FLOAT((Class)Float.class){

        @Override
        public void save(GraphDataOutput out, Object v) throws IOException {
            out.writeFloat(((Float)v).floatValue());
        }

        @Override
        public Object load(GraphDataInput in) throws IOException {
            return Float.valueOf(in.readFloat());
        }
    }
    ,
    DOUBLE((Class)Double.class){

        @Override
        public void save(GraphDataOutput out, Object v) throws IOException {
            out.writeDouble((Double)v);
        }

        @Override
        public Object load(GraphDataInput in) throws IOException {
            return in.readDouble();
        }
    }
    ,
    TYPE((Class)Type.class){

        @Override
        public void save(GraphDataOutput out, Object v) throws IOException {
            out.writeUTF(((Type)v).getDescriptor());
        }

        @Override
        public Object load(GraphDataInput in) throws IOException {
            return Type.getType((String)in.readUTF());
        }
    }
    ,
    ARRAY((Class)Array.class){

        @Override
        public void save(GraphDataOutput out, Object val) throws IOException {
            int length = Array.getLength(val);
            JvmProtoMemberValueExternalizer ext = JvmProtoMemberValueExternalizer.find(this.getDataType(length > 0 ? Array.get(val, 0).getClass() : val.getClass().getComponentType()));
            out.writeInt(ext.ordinal());
            if (ext != NONE) {
                out.writeInt(length);
                for (int idx = 0; idx < length; ++idx) {
                    ext.save(out, Array.get(val, idx));
                }
            }
        }

        @Override
        public Object load(GraphDataInput in) throws IOException {
            int ord = in.readInt();
            if (NONE.ordinal() != ord) {
                for (JvmProtoMemberValueExternalizer ext : 8.values()) {
                    if (ext.ordinal() != ord) continue;
                    int length = in.readInt();
                    Object array = Array.newInstance(this.getArrayElementType(ext.dataType), length);
                    for (int idx = 0; idx < length; ++idx) {
                        Array.set(array, idx, ext.load(in));
                    }
                    return array;
                }
            }
            return NONE.load(in);
        }

        private Class<?> getArrayElementType(Class<?> dataType) {
            if (Character.class.equals(dataType)) {
                return Character.TYPE;
            }
            if (Byte.class.equals(dataType)) {
                return Byte.TYPE;
            }
            if (Short.class.equals(dataType)) {
                return Short.TYPE;
            }
            if (Integer.class.equals(dataType)) {
                return Integer.TYPE;
            }
            if (Long.class.equals(dataType)) {
                return Long.TYPE;
            }
            if (Float.class.equals(dataType)) {
                return Float.TYPE;
            }
            if (Double.class.equals(dataType)) {
                return Double.TYPE;
            }
            if (Boolean.class.equals(dataType)) {
                return Boolean.TYPE;
            }
            return dataType;
        }

        private Class<?> getDataType(Class<?> arrayElementType) {
            if (Character.TYPE.equals(arrayElementType)) {
                return Character.class;
            }
            if (Byte.TYPE.equals(arrayElementType)) {
                return Byte.class;
            }
            if (Short.TYPE.equals(arrayElementType)) {
                return Short.class;
            }
            if (Integer.TYPE.equals(arrayElementType)) {
                return Integer.class;
            }
            if (Long.TYPE.equals(arrayElementType)) {
                return Long.class;
            }
            if (Float.TYPE.equals(arrayElementType)) {
                return Float.class;
            }
            if (Double.TYPE.equals(arrayElementType)) {
                return Double.class;
            }
            if (Boolean.TYPE.equals(arrayElementType)) {
                return Boolean.class;
            }
            return arrayElementType;
        }
    }
    ,
    BOOLEAN((Class)Boolean.class){

        @Override
        public void save(GraphDataOutput out, Object v) throws IOException {
            out.writeBoolean((Boolean)v);
        }

        @Override
        public Object load(GraphDataInput in) throws IOException {
            return in.readBoolean();
        }
    }
    ,
    CHARACTER((Class)Character.class){

        @Override
        public void save(GraphDataOutput out, Object v) throws IOException {
            out.writeChar(((Character)v).charValue());
        }

        @Override
        public Object load(GraphDataInput in) throws IOException {
            return Character.valueOf(in.readChar());
        }
    }
    ,
    BYTE((Class)Byte.class){

        @Override
        public void save(GraphDataOutput out, Object v) throws IOException {
            out.writeByte(((Byte)v).byteValue());
        }

        @Override
        public Object load(GraphDataInput in) throws IOException {
            return in.readByte();
        }
    }
    ,
    SHORT((Class)Short.class){

        @Override
        public void save(GraphDataOutput out, Object v) throws IOException {
            out.writeShort(((Short)v).shortValue());
        }

        @Override
        public Object load(GraphDataInput in) throws IOException {
            return in.readShort();
        }
    };

    @Nullable
    private final Class<?> dataType;

    private JvmProtoMemberValueExternalizer(Class<?> dataType) {
        this.dataType = dataType;
    }

    @Override
    public Object[] createStorage(int size) {
        return new Object[size];
    }

    @Override
    public abstract void save(GraphDataOutput var1, Object var2) throws IOException;

    @Override
    public abstract Object load(GraphDataInput var1) throws IOException;

    private static JvmProtoMemberValueExternalizer find(@Nullable Class<?> dataType) {
        if (dataType != null) {
            if (dataType.isArray()) {
                return ARRAY;
            }
            for (JvmProtoMemberValueExternalizer ext : JvmProtoMemberValueExternalizer.values()) {
                if (ext.dataType == null || !ext.dataType.isAssignableFrom(dataType)) continue;
                return ext;
            }
        }
        return NONE;
    }

    static void write(GraphDataOutput out, @Nullable Object value) throws IOException {
        JvmProtoMemberValueExternalizer ext = JvmProtoMemberValueExternalizer.find(value != null ? value.getClass() : null);
        out.writeInt(ext.ordinal());
        ext.save(out, value);
    }

    static Object read(GraphDataInput in) throws IOException {
        int ord = in.readInt();
        for (JvmProtoMemberValueExternalizer ext : JvmProtoMemberValueExternalizer.values()) {
            if (ext.ordinal() != ord) continue;
            return ext.load(in);
        }
        return null;
    }
}

