/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency;

import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface LogConsumer {
    public static final LogConsumer EMPTY = new LogConsumer(){

        @Override
        public void consume(Supplier<String> message) {
        }

        @Override
        public void consume(String message) {
        }
    };

    public void consume(Supplier<String> var1);

    public void consume(String var1);

    public static LogConsumer composite(final LogConsumer first, final LogConsumer second) {
        return first == EMPTY ? second : (second == EMPTY ? first : new LogConsumer(){

            @Override
            public void consume(Supplier<String> message) {
                try {
                    first.consume(message);
                }
                finally {
                    second.consume(message);
                }
            }

            @Override
            public void consume(String message) {
                try {
                    first.consume(message);
                }
                finally {
                    second.consume(message);
                }
            }
        });
    }

    public static LogConsumer memory(final StringBuilder builder) {
        return new LogConsumer(){

            @Override
            public void consume(Supplier<String> message) {
                builder.append(message.get()).append("\n");
            }

            @Override
            public void consume(String message) {
                builder.append(message).append("\n");
            }
        };
    }

    public static LogConsumer createJULogConsumer(Level level) {
        return LogConsumer.createJULogConsumer("#org.jetbrains.jps.dependency.java.JvmDifferentiateStrategy", level);
    }

    public static LogConsumer createJULogConsumer(String category, final Level level) {
        final Logger logger = Logger.getLogger(category);
        return new LogConsumer(){

            @Override
            public void consume(Supplier<String> message) {
                logger.log(level, message);
            }

            @Override
            public void consume(String message) {
                logger.log(level, message);
            }
        };
    }
}

