/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.util;

import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.dependency.fest_reflect.core.Reflection;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.util.SystemPropertyWriter;

public final class AWTExceptionHandlerInstaller {
    private static final SystemPropertyWriter WRITER = new SystemPropertyWriter();

    public static void installAWTExceptionHandler(@Nonnull Class<?> exceptionHandlerType) {
        AWTExceptionHandlerInstaller.installAWTExceptionHandler(exceptionHandlerType, WRITER);
    }

    @VisibleForTesting
    static void installAWTExceptionHandler(@Nonnull Class<?> exceptionHandlerType, SystemPropertyWriter writer) {
        try {
            Reflection.constructor().in(exceptionHandlerType).info();
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("The exception handler type should have a default constructor");
        }
        writer.updateSystemProperty("sun.awt.exception.handler", exceptionHandlerType.getName());
    }

    private AWTExceptionHandlerInstaller() {
    }
}

