/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.debugger.agent;

import com.intellij.rt.debugger.agent.CaptureAgent;
import org.jetbrains.capture.org.objectweb.asm.ClassReader;
import org.jetbrains.capture.org.objectweb.asm.ClassVisitor;
import org.jetbrains.capture.org.objectweb.asm.ClassWriter;

public class ClassTransformer {
    private final String className;
    private final ClassReader reader;
    final ClassWriter writer;

    public ClassTransformer(String className, byte[] classfileBuffer, int flags, final ClassLoader loader) {
        this.className = className;
        this.reader = new ClassReader(classfileBuffer);
        this.writer = new ClassWriter(this.reader, flags){

            @Override
            protected ClassLoader getClassLoader() {
                return loader;
            }
        };
    }

    public byte[] accept(ClassVisitor visitor, int parsingOptions, boolean storeClassForDebug) {
        this.reader.accept(visitor, parsingOptions);
        byte[] bytes = this.writer.toByteArray();
        if (storeClassForDebug) {
            CaptureAgent.storeClassForDebug(this.className, bytes);
        }
        return bytes;
    }
}

