/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;

public class ShouldBeInstance
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldBeInstance(Object object, Class<?> type) {
        ShouldBeInstance shouldBeInstance;
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            shouldBeInstance = new ShouldBeInstance(throwable, type);
        } else {
            shouldBeInstance = new ShouldBeInstance(object, type);
        }
        return shouldBeInstance;
    }

    public static ErrorMessageFactory shouldBeInstanceButWasNull(String objectDescription, Class<?> type) {
        return new ShouldBeInstance(objectDescription, type);
    }

    private ShouldBeInstance(Object object, Class<?> type) {
        super("%nExpecting actual:%n  %s%nto be an instance of:%n  %s%nbut was instance of:%n  %s", object, type, object.getClass());
    }

    private ShouldBeInstance(Throwable throwable, Class<?> type) {
        super("%nExpecting actual throwable to be an instance of:%n  %s%nbut was:%n  %s", type, throwable);
    }

    private ShouldBeInstance(String objectDescription, Class<?> type) {
        super("%nExpecting object:%n  %s%nto be an instance of:%n  <%s>%nbut was null", objectDescription, type);
    }
}

