/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.InstanceOfAssertFactory;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.WithThrowable;
import org.assertj.core.error.ShouldBeEqual;
import org.assertj.core.error.ShouldMatch;
import org.assertj.core.error.future.ShouldBeCancelled;
import org.assertj.core.error.future.ShouldBeCompleted;
import org.assertj.core.error.future.ShouldBeCompletedExceptionally;
import org.assertj.core.error.future.ShouldBeDone;
import org.assertj.core.error.future.ShouldHaveFailed;
import org.assertj.core.error.future.ShouldNotBeCancelled;
import org.assertj.core.error.future.ShouldNotBeCompleted;
import org.assertj.core.error.future.ShouldNotBeCompletedExceptionally;
import org.assertj.core.error.future.ShouldNotBeDone;
import org.assertj.core.error.future.ShouldNotHaveFailed;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Futures;
import org.assertj.core.presentation.PredicateDescription;

public abstract class AbstractCompletableFutureAssert<SELF extends AbstractCompletableFutureAssert<SELF, RESULT>, RESULT>
extends AbstractAssert<SELF, CompletableFuture<RESULT>> {
    Futures futures = Futures.instance();

    protected AbstractCompletableFutureAssert(CompletableFuture<RESULT> actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isDone() {
        this.isNotNull();
        if (!((CompletableFuture)this.actual).isDone()) {
            this.throwAssertionError(ShouldBeDone.shouldBeDone((Future)this.actual));
        }
        return (SELF)((AbstractCompletableFutureAssert)this.myself);
    }

    public SELF isNotDone() {
        this.isNotNull();
        if (((CompletableFuture)this.actual).isDone()) {
            this.throwAssertionError(ShouldNotBeDone.shouldNotBeDone((Future)this.actual));
        }
        return (SELF)((AbstractCompletableFutureAssert)this.myself);
    }

    public SELF isCompletedExceptionally() {
        this.isNotNull();
        if (!((CompletableFuture)this.actual).isCompletedExceptionally()) {
            this.throwAssertionError(ShouldBeCompletedExceptionally.shouldHaveCompletedExceptionally((CompletableFuture)this.actual));
        }
        return (SELF)((AbstractCompletableFutureAssert)this.myself);
    }

    public SELF isNotCompletedExceptionally() {
        this.isNotNull();
        if (((CompletableFuture)this.actual).isCompletedExceptionally()) {
            this.throwAssertionError(ShouldNotBeCompletedExceptionally.shouldNotHaveCompletedExceptionally((CompletableFuture)this.actual));
        }
        return (SELF)((AbstractCompletableFutureAssert)this.myself);
    }

    public SELF isCancelled() {
        this.isNotNull();
        if (!((CompletableFuture)this.actual).isCancelled()) {
            this.throwAssertionError(ShouldBeCancelled.shouldBeCancelled((Future)this.actual));
        }
        return (SELF)((AbstractCompletableFutureAssert)this.myself);
    }

    public SELF isNotCancelled() {
        this.isNotNull();
        if (((CompletableFuture)this.actual).isCancelled()) {
            this.throwAssertionError(ShouldNotBeCancelled.shouldNotBeCancelled((Future)this.actual));
        }
        return (SELF)((AbstractCompletableFutureAssert)this.myself);
    }

    public SELF isCompleted() {
        this.isNotNull();
        if (((CompletableFuture)this.actual).isCompletedExceptionally() || !((CompletableFuture)this.actual).isDone()) {
            this.throwAssertionError(ShouldBeCompleted.shouldBeCompleted((CompletableFuture)this.actual));
        }
        return (SELF)((AbstractCompletableFutureAssert)this.myself);
    }

    public SELF isNotCompleted() {
        this.isNotNull();
        if (((CompletableFuture)this.actual).isDone() && !((CompletableFuture)this.actual).isCompletedExceptionally()) {
            this.throwAssertionError(ShouldNotBeCompleted.shouldNotBeCompleted((CompletableFuture)this.actual));
        }
        return (SELF)((AbstractCompletableFutureAssert)this.myself);
    }

    public SELF isCompletedWithValue(RESULT expected) {
        this.isCompleted();
        Object actualResult = ((CompletableFuture)this.actual).join();
        if (!Objects.equals(actualResult, expected)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqual.shouldBeEqual(actualResult, expected, this.info.representation()));
        }
        return (SELF)((AbstractCompletableFutureAssert)this.myself);
    }

    public SELF isCompletedWithValueMatchingWithin(Predicate<RESULT> resultPredicate, Duration completionDuration) {
        Object actualResult = this.futures.assertSucceededWithin(this.info, (Future)this.actual, completionDuration);
        if (!resultPredicate.test(actualResult)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldMatch.shouldMatch(actualResult, resultPredicate, PredicateDescription.GIVEN));
        }
        return (SELF)((AbstractCompletableFutureAssert)this.myself);
    }

    public SELF isCompletedWithValueMatching(Predicate<? super RESULT> predicate) {
        return this.isCompletedWithValueMatching(predicate, PredicateDescription.GIVEN);
    }

    public SELF isCompletedWithValueMatching(Predicate<? super RESULT> predicate, String description) {
        return this.isCompletedWithValueMatching(predicate, new PredicateDescription(description));
    }

    private SELF isCompletedWithValueMatching(Predicate<? super RESULT> predicate, PredicateDescription description) {
        this.isCompleted();
        Object actualResult = ((CompletableFuture)this.actual).join();
        if (!predicate.test(actualResult)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldMatch.shouldMatch(actualResult, predicate, description));
        }
        return (SELF)((AbstractCompletableFutureAssert)this.myself);
    }

    @Deprecated(since="3", forRemoval=true)
    public SELF hasFailed() {
        this.isNotNull();
        if (!((CompletableFuture)this.actual).isCompletedExceptionally() || ((CompletableFuture)this.actual).isCancelled()) {
            this.throwAssertionError(ShouldHaveFailed.shouldHaveFailed((CompletableFuture)this.actual));
        }
        return (SELF)((AbstractCompletableFutureAssert)this.myself);
    }

    @Deprecated(since="3", forRemoval=true)
    public SELF hasNotFailed() {
        this.isNotNull();
        if (((CompletableFuture)this.actual).isCompletedExceptionally() && !((CompletableFuture)this.actual).isCancelled()) {
            this.throwAssertionError(ShouldNotHaveFailed.shouldNotHaveFailed((CompletableFuture)this.actual));
        }
        return (SELF)((AbstractCompletableFutureAssert)this.myself);
    }

    public ObjectAssert<RESULT> succeedsWithin(Duration timeout) {
        return this.internalSucceedsWithin(timeout);
    }

    private ObjectAssert<RESULT> internalSucceedsWithin(Duration timeout) {
        Object result = this.futures.assertSucceededWithin(this.info, (Future)this.actual, timeout);
        return this.newObjectAssert(result);
    }

    protected ObjectAssert<RESULT> newObjectAssert(RESULT objectUnderTest) {
        return new ObjectAssert<RESULT>(objectUnderTest);
    }

    public ObjectAssert<RESULT> succeedsWithin(long timeout, TimeUnit unit) {
        return this.internalSucceedsWithin(timeout, unit);
    }

    private ObjectAssert<RESULT> internalSucceedsWithin(long timeout, TimeUnit unit) {
        Object result = this.futures.assertSucceededWithin(this.info, (Future)this.actual, timeout, unit);
        return this.newObjectAssert(result);
    }

    public <ASSERT extends AbstractAssert<?, ?>> ASSERT succeedsWithin(Duration timeout, InstanceOfAssertFactory<RESULT, ASSERT> assertFactory) {
        return this.internalSucceedsWithin(timeout).asInstanceOf(assertFactory);
    }

    public <ASSERT extends AbstractAssert<?, ?>> ASSERT succeedsWithin(long timeout, TimeUnit unit, InstanceOfAssertFactory<RESULT, ASSERT> assertFactory) {
        return this.internalSucceedsWithin(timeout, unit).asInstanceOf(assertFactory);
    }

    @Deprecated(since="3", forRemoval=true)
    public AbstractThrowableAssert<?, ? extends Throwable> hasFailedWithThrowableThat() {
        this.hasFailed();
        try {
            ((CompletableFuture)this.actual).join();
            return AssertionsForClassTypes.assertThat((Throwable)null);
        }
        catch (CompletionException e) {
            return AssertionsForClassTypes.assertThat(e.getCause());
        }
    }

    public WithThrowable failsWithin(Duration timeout) {
        return this.internalFailsWithin(timeout);
    }

    public WithThrowable failsWithin(long timeout, TimeUnit unit) {
        return this.internalFailsWithin(timeout, unit);
    }

    private WithThrowable internalFailsWithin(Duration timeout) {
        Exception exception = this.futures.assertFailedWithin(this.info, (Future)this.actual, timeout);
        return new WithThrowable(exception);
    }

    private WithThrowable internalFailsWithin(long timeout, TimeUnit unit) {
        Exception exception = this.futures.assertFailedWithin(this.info, (Future)this.actual, timeout, unit);
        return new WithThrowable(exception);
    }

    public WithThrowable completesExceptionallyWithin(Duration timeout) {
        return this.internalCompletesExceptionallyWithin(timeout);
    }

    public WithThrowable completesExceptionallyWithin(long timeout, TimeUnit unit) {
        return this.internalCompletesExceptionallyWithin(timeout, unit);
    }

    private WithThrowable internalCompletesExceptionallyWithin(Duration timeout) {
        Exception exception = this.futures.assertCompletedExceptionallyWithin(this.info, (Future)this.actual, timeout);
        return new WithThrowable(exception);
    }

    private WithThrowable internalCompletesExceptionallyWithin(long timeout, TimeUnit unit) {
        Exception exception = this.futures.assertCompletedExceptionallyWithin(this.info, (Future)this.actual, timeout, unit);
        return new WithThrowable(exception);
    }
}

