/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.dataFlow.inference.JavaSourceInference;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.light.LightRecordCanonicalConstructor;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginModeProvider;
import org.jetbrains.kotlin.nj2k.NullabilityUtilsKt;

class J2KNullityInferrer {
    private static final int MAX_PASSES = 10;
    private int numAnnotationsAdded;
    private final Set<PsiType> notNullTypes = Collections.newSetFromMap(new IdentityHashMap());
    private final Set<PsiType> nullableTypes = Collections.newSetFromMap(new IdentityHashMap());
    private final Set<PsiJavaCodeReferenceElement> notNullElements = new HashSet<PsiJavaCodeReferenceElement>();
    private final Set<PsiJavaCodeReferenceElement> nullableElements = new HashSet<PsiJavaCodeReferenceElement>();
    private final Map<PsiVariable, Collection<PsiReference>> variableReferences = new HashMap<PsiVariable, Collection<PsiReference>>();
    private final Map<PsiVariable, Collection<PsiExpression>> variableAssignmentRightHandSides = new HashMap<PsiVariable, Collection<PsiExpression>>();
    private final Map<PsiParameter, List<PsiReferenceExpression>> parameterReferences = new HashMap<PsiParameter, List<PsiReferenceExpression>>();

    J2KNullityInferrer() {
    }

    Set<PsiType> getNotNullTypes() {
        return this.notNullTypes;
    }

    Set<PsiType> getNullableTypes() {
        return this.nullableTypes;
    }

    Set<PsiJavaCodeReferenceElement> getNotNullElements() {
        return this.notNullElements;
    }

    Set<PsiJavaCodeReferenceElement> getNullableElements() {
        return this.nullableElements;
    }

    private boolean expressionIsNeverNull(@Nullable PsiExpression expression) {
        if (expression == null) {
            return false;
        }
        if (ExpressionUtils.nonStructuralChildren((PsiExpression)expression).allMatch(expr -> expr instanceof PsiMethodCallExpression && this.isNotNull((PsiModifierListOwner)((PsiMethodCallExpression)expr).resolveMethod()))) {
            return true;
        }
        return NullabilityUtil.getExpressionNullability((PsiExpression)expression, (boolean)true) == Nullability.NOT_NULL;
    }

    private boolean expressionIsSometimesNull(@Nullable PsiExpression expression) {
        if (expression == null) {
            return false;
        }
        if (ExpressionUtils.nonStructuralChildren((PsiExpression)expression).anyMatch(expr -> {
            PsiMethodCallExpression callExpression;
            return expr instanceof PsiMethodCallExpression && this.isNullable((PsiModifierListOwner)(callExpression = (PsiMethodCallExpression)expr).resolveMethod());
        })) {
            return true;
        }
        return NullabilityUtil.getExpressionNullability((PsiExpression)expression, (boolean)true) == Nullability.NULLABLE;
    }

    private boolean variableNeverAssignedNull(@NotNull PsiVariable variable) {
        PsiExpression initializer2;
        if (variable == null) {
            J2KNullityInferrer.$$$reportNull$$$0(0);
        }
        if ((initializer2 = variable.getInitializer()) != null) {
            if (!this.expressionIsNeverNull(initializer2)) {
                return false;
            }
        } else {
            PsiParameter parameter;
            if (!variable.hasModifierProperty("final")) {
                return false;
            }
            if (variable instanceof PsiParameter && (parameter = (PsiParameter)variable).getDeclarationScope() instanceof PsiCatchSection) {
                return false;
            }
        }
        Collection<PsiReference> references = this.variableReferences.get(variable);
        for (PsiReference reference : references) {
            PsiAssignmentExpression assignment2;
            PsiElement parent;
            PsiElement element = reference.getElement();
            if (!(element instanceof PsiReferenceExpression) || !((parent = element.getParent()) instanceof PsiAssignmentExpression) || !(assignment2 = (PsiAssignmentExpression)parent).getLExpression().equals((Object)element) || this.expressionIsNeverNull(assignment2.getRExpression())) continue;
            return false;
        }
        return true;
    }

    private boolean variableSometimesAssignedNull(@NotNull PsiVariable variable) {
        PsiExpression initializer2;
        if (variable == null) {
            J2KNullityInferrer.$$$reportNull$$$0(1);
        }
        if ((initializer2 = variable.getInitializer()) != null && this.expressionIsSometimesNull(initializer2)) {
            return true;
        }
        SearchScope scope = J2KNullityInferrer.getScope(variable);
        if (scope == null) {
            return false;
        }
        Collection<PsiReference> references = this.variableReferences.get(variable);
        for (PsiReference reference : references) {
            PsiAssignmentExpression assignment2;
            PsiElement parent;
            PsiElement element = reference.getElement();
            if (!(element instanceof PsiReferenceExpression) || !((parent = element.getParent()) instanceof PsiAssignmentExpression) || !(assignment2 = (PsiAssignmentExpression)parent).getLExpression().equals((Object)element) || !this.expressionIsSometimesNull(assignment2.getRExpression())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static SearchScope getScope(@NotNull PsiVariable variable) {
        if (variable == null) {
            J2KNullityInferrer.$$$reportNull$$$0(2);
        }
        if (!(variable instanceof PsiField)) {
            return variable.getUseScope();
        }
        PsiField field2 = (PsiField)variable;
        if (J2KNullityInferrer.isPrivate(field2)) {
            return variable.getUseScope();
        }
        PsiFile containingFile = variable.getContainingFile();
        return containingFile != null ? new LocalSearchScope((PsiElement)containingFile) : null;
    }

    private static boolean isPrivate(PsiField field2) {
        PsiModifierList modifierList = field2.getModifierList();
        if (modifierList == null) {
            return false;
        }
        return modifierList.hasModifierProperty("private");
    }

    public void collect(@NotNull PsiFile file) {
        if (file == null) {
            J2KNullityInferrer.$$$reportNull$$$0(3);
        }
        this.runPreprocessing(file);
        this.inferNullabilityIteratively(file);
        this.flushCaches();
    }

    private void runPreprocessing(@NotNull PsiFile file) {
        if (file == null) {
            J2KNullityInferrer.$$$reportNull$$$0(4);
        }
        file.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitTypeElement(@NotNull PsiTypeElement typeElement2) {
                PsiModifierListOwner modifierListOwner;
                PsiModifierListOwner owner;
                if (typeElement2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitTypeElement(typeElement2);
                PsiType type2 = typeElement2.getType();
                PsiElement psiElement = typeElement2.getParent();
                PsiModifierListOwner psiModifierListOwner = owner = psiElement instanceof PsiModifierListOwner ? (modifierListOwner = (PsiModifierListOwner)psiElement) : null;
                if (owner instanceof PsiMethod) {
                    return;
                }
                Nullability nullability = DfaPsiUtil.getElementNullabilityForWrite((PsiType)type2, (PsiModifierListOwner)owner);
                switch (nullability) {
                    case NULLABLE: {
                        J2KNullityInferrer.this.registerNullableType(type2);
                        break;
                    }
                    case NOT_NULL: {
                        J2KNullityInferrer.this.registerNotNullType(type2);
                    }
                }
                if (type2 instanceof PsiArrayType) {
                    PsiArrayType arrayType = (PsiArrayType)type2;
                    PsiType componentType = arrayType.getComponentType();
                    Nullability componentNullability = componentType.getNullability().nullability();
                    switch (componentNullability) {
                        case NULLABLE: {
                            J2KNullityInferrer.this.registerNullableType(componentType);
                            break;
                        }
                        case NOT_NULL: {
                            J2KNullityInferrer.this.registerNotNullType(componentType);
                        }
                    }
                }
            }

            public void visitVariable(@NotNull PsiVariable variable) {
                if (variable == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitVariable(variable);
                if (variable.getType() instanceof PsiPrimitiveType) {
                    return;
                }
                SearchScope scope = J2KNullityInferrer.getScope(variable);
                Collection<Object> references = Collections.emptyList();
                if (scope != null) {
                    references = ReferencesSearch.search((PsiElement)variable, (SearchScope)scope).findAll();
                }
                J2KNullityInferrer.this.variableReferences.put(variable, references);
                Collection rightHandSides = DfaPsiUtil.getVariableAssignmentsInFile((PsiVariable)variable, (boolean)false, null);
                J2KNullityInferrer.this.variableAssignmentRightHandSides.put(variable, rightHandSides);
            }

            public void visitParameter(@NotNull PsiParameter parameter) {
                PsiMethod method;
                if (parameter == null) {
                    1.$$$reportNull$$$0(2);
                }
                super.visitParameter(parameter);
                if (parameter.getType() instanceof PsiPrimitiveType) {
                    return;
                }
                List references = Collections.emptyList();
                PsiElement grandParent = parameter.getDeclarationScope();
                if (grandParent instanceof PsiMethod && (method = (PsiMethod)grandParent).getBody() != null) {
                    references = VariableAccessUtils.getVariableReferences((PsiVariable)parameter, (PsiElement)method);
                }
                J2KNullityInferrer.this.parameterReferences.put(parameter, references);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typeElement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "variable";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parameter";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/nj2k/J2KNullityInferrer$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTypeElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitVariable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitParameter";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void inferNullabilityIteratively(@NotNull PsiFile file) {
        int prevNumAnnotationsAdded;
        if (file == null) {
            J2KNullityInferrer.$$$reportNull$$$0(5);
        }
        int pass = 0;
        do {
            NullityInferrerVisitor visitor2 = new NullityInferrerVisitor();
            prevNumAnnotationsAdded = this.numAnnotationsAdded;
            file.accept((PsiElementVisitor)visitor2);
        } while (prevNumAnnotationsAdded < this.numAnnotationsAdded && ++pass < 10);
    }

    private void flushCaches() {
        this.variableReferences.clear();
        this.variableAssignmentRightHandSides.clear();
        this.parameterReferences.clear();
    }

    private void registerNullableAnnotation(@NotNull PsiModifierListOwner declaration) {
        if (declaration == null) {
            J2KNullityInferrer.$$$reportNull$$$0(6);
        }
        this.registerAnnotation(declaration, true);
    }

    private void registerNotNullAnnotation(@NotNull PsiModifierListOwner declaration) {
        if (declaration == null) {
            J2KNullityInferrer.$$$reportNull$$$0(7);
        }
        this.registerAnnotation(declaration, false);
    }

    private void registerAnnotation(@NotNull PsiModifierListOwner declaration, boolean isNullable) {
        PsiType type2;
        if (declaration == null) {
            J2KNullityInferrer.$$$reportNull$$$0(8);
        }
        if ((type2 = J2KNullityInferrer.getType(declaration)) == null) {
            return;
        }
        this.registerTypeNullability(type2, isNullable);
    }

    private static PsiType getType(PsiModifierListOwner declaration) {
        if (declaration instanceof PsiVariable) {
            return ((PsiVariable)declaration).getType();
        }
        if (declaration instanceof PsiMethod) {
            return ((PsiMethod)declaration).getReturnType();
        }
        return null;
    }

    private void registerNullableType(@Nullable PsiType type2) {
        if (type2 != null) {
            this.registerTypeNullability(type2, true);
        }
    }

    private void registerNotNullType(@Nullable PsiType type2) {
        if (type2 != null) {
            this.registerTypeNullability(type2, false);
        }
    }

    private void registerTypeNullability(@NotNull PsiType type2, boolean isNullable) {
        PsiClassType classType;
        PsiClass psiClass;
        if (type2 == null) {
            J2KNullityInferrer.$$$reportNull$$$0(9);
        }
        if (this.isNullable(type2)) {
            return;
        }
        if (this.isNotNull(type2) && !isNullable) {
            return;
        }
        if (type2 instanceof PsiClassType && (psiClass = (classType = (PsiClassType)type2).resolve()) instanceof PsiTypeParameter) {
            return;
        }
        PsiJavaCodeReferenceElement element = null;
        if (type2 instanceof PsiClassReferenceType) {
            PsiClassReferenceType classReferenceType = (PsiClassReferenceType)type2;
            element = classReferenceType.getReference();
        }
        PsiType unwrappedType = J2KNullityInferrer.unwrap(type2);
        if (isNullable) {
            this.nullableTypes.add(unwrappedType);
            if (element != null) {
                this.nullableElements.add(element);
            }
            this.notNullTypes.remove(unwrappedType);
            if (element != null) {
                this.notNullElements.remove(element);
            }
        } else {
            this.notNullTypes.add(unwrappedType);
            if (element != null) {
                this.notNullElements.add(element);
            }
        }
        ++this.numAnnotationsAdded;
    }

    private void registerAnnotationByNullAssignmentStatus(PsiVariable variable) {
        if (this.variableNeverAssignedNull(variable)) {
            this.registerNotNullAnnotation((PsiModifierListOwner)variable);
        } else if (this.variableSometimesAssignedNull(variable)) {
            this.registerNullableAnnotation((PsiModifierListOwner)variable);
        }
    }

    private boolean isNotNull(@Nullable PsiModifierListOwner owner) {
        if (owner == null) {
            return false;
        }
        if (NullableNotNullManager.isNotNull((PsiModifierListOwner)owner)) {
            return true;
        }
        PsiType type2 = J2KNullityInferrer.getType(owner);
        if (type2 == null) {
            return false;
        }
        return this.isNotNull(type2);
    }

    private boolean isNotNull(@Nullable PsiType type2) {
        if (type2 == null) {
            return false;
        }
        PsiType unwrappedType = J2KNullityInferrer.unwrap(type2);
        return this.notNullTypes.contains(unwrappedType);
    }

    private boolean isNullable(@Nullable PsiModifierListOwner owner) {
        if (owner == null) {
            return false;
        }
        if (NullableNotNullManager.isNullable((PsiModifierListOwner)owner)) {
            return true;
        }
        PsiType type2 = J2KNullityInferrer.getType(owner);
        if (type2 == null) {
            return false;
        }
        return this.isNullable(type2);
    }

    private boolean isNullable(@Nullable PsiType type2) {
        if (type2 == null) {
            return false;
        }
        PsiType unwrappedType = J2KNullityInferrer.unwrap(type2);
        return this.nullableTypes.contains(unwrappedType);
    }

    @NotNull
    private static PsiType unwrap(@NotNull PsiType type2) {
        if (type2 == null) {
            J2KNullityInferrer.$$$reportNull$$$0(10);
        }
        if (type2 instanceof PsiCapturedWildcardType) {
            PsiCapturedWildcardType capturedWildcardType = (PsiCapturedWildcardType)type2;
            return J2KNullityInferrer.unwrap((PsiType)capturedWildcardType.getWildcard());
        }
        if (type2 instanceof PsiWildcardType) {
            PsiWildcardType wildcardType = (PsiWildcardType)type2;
            if (wildcardType.isExtends()) {
                PsiType psiType = wildcardType.getExtendsBound();
                if (psiType == null) {
                    J2KNullityInferrer.$$$reportNull$$$0(11);
                }
                return psiType;
            }
            if (wildcardType.isSuper()) {
                PsiType psiType = wildcardType.getSuperBound();
                if (psiType == null) {
                    J2KNullityInferrer.$$$reportNull$$$0(12);
                }
                return psiType;
            }
        }
        PsiType psiType = type2;
        if (psiType == null) {
            J2KNullityInferrer.$$$reportNull$$$0(13);
        }
        return psiType;
    }

    private boolean hasRawNullability(@NotNull PsiType type2) {
        if (type2 == null) {
            J2KNullityInferrer.$$$reportNull$$$0(14);
        }
        return this.isNullable(type2) || this.isNotNull(type2);
    }

    private boolean hasRawNullability(@NotNull PsiModifierListOwner owner) {
        NullableNotNullManager manager;
        NullabilityAnnotationInfo info2;
        if (owner == null) {
            J2KNullityInferrer.$$$reportNull$$$0(15);
        }
        if ((info2 = (manager = NullableNotNullManager.getInstance((Project)owner.getProject())).findEffectiveNullabilityInfo(owner)) != null && !info2.isInferred() && info2.getNullability() != Nullability.UNKNOWN) {
            return true;
        }
        PsiType type2 = J2KNullityInferrer.getType(owner);
        if (type2 == null) {
            return false;
        }
        return this.hasRawNullability(type2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 9: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/nj2k/J2KNullityInferrer";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/nj2k/J2KNullityInferrer";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "variableNeverAssignedNull";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "variableSometimesAssignedNull";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runPreprocessing";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "inferNullabilityIteratively";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerNullableAnnotation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerNotNullAnnotation";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerAnnotation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerTypeNullability";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unwrap";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "hasRawNullability";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 13 -> new IllegalStateException(string);
        };
    }

    private class NullityInferrerVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private NullityInferrerVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                NullityInferrerVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            if (method.isConstructor() || method.getReturnType() instanceof PsiPrimitiveType) {
                return;
            }
            this.unifyNullabilityOfMethodReturnTypeAndReturnedExpressions(method);
            Collection overridingMethods = OverridingMethodsSearch.search((PsiMethod)method).findAll();
            for (PsiMethod overridingMethod : overridingMethods) {
                if (!J2KNullityInferrer.this.isNullable((PsiModifierListOwner)overridingMethod)) continue;
                J2KNullityInferrer.this.registerNullableAnnotation((PsiModifierListOwner)method);
                return;
            }
            NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)method.getProject());
            if (!manager.isNotNull((PsiModifierListOwner)method, false) && manager.isNotNull((PsiModifierListOwner)method, true)) {
                J2KNullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)method);
                return;
            }
            if (J2KNullityInferrer.this.hasRawNullability((PsiModifierListOwner)method)) {
                return;
            }
            Nullability nullability = NullabilityUtilsKt.getMethodNullabilityByDfa(method);
            switch (nullability) {
                case NULLABLE: {
                    J2KNullityInferrer.this.registerNullableAnnotation((PsiModifierListOwner)method);
                    break;
                }
                case NOT_NULL: {
                    for (PsiMethod overridingMethod : overridingMethods) {
                        if (J2KNullityInferrer.this.isNotNull((PsiModifierListOwner)overridingMethod)) continue;
                        return;
                    }
                    J2KNullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)method);
                }
            }
        }

        private void unifyNullabilityOfMethodReturnTypeAndReturnedExpressions(@NotNull PsiMethod method) {
            if (method == null) {
                NullityInferrerVisitor.$$$reportNull$$$0(1);
            }
            if (KotlinPluginModeProvider.Companion.isK1Mode()) {
                return;
            }
            PsiReturnStatement[] statements2 = PsiUtil.findReturnStatements((PsiMethod)method);
            if (statements2.length == 0) {
                return;
            }
            PsiType methodReturnType = method.getReturnType();
            if (methodReturnType == null) {
                return;
            }
            Nullability methodNullability = DfaPsiUtil.getElementNullabilityForWrite((PsiType)methodReturnType, (PsiModifierListOwner)method);
            if (methodNullability == Nullability.NOT_NULL) {
                J2KNullityInferrer.this.registerNotNullType(methodReturnType);
            }
            if (methodReturnType instanceof PsiArrayType) {
                PsiArrayType arrayType = (PsiArrayType)methodReturnType;
                PsiType componentType = arrayType.getComponentType();
                Nullability componentNullability = componentType.getNullability().nullability();
                switch (componentNullability) {
                    case NULLABLE: {
                        J2KNullityInferrer.this.registerNullableType(componentType);
                        break;
                    }
                    case NOT_NULL: {
                        J2KNullityInferrer.this.registerNotNullType(componentType);
                    }
                }
            }
            boolean allRawReturnValueTypesAreNotNull = true;
            boolean rawMethodReturnTypeIsNotNull = methodNullability == Nullability.NOT_NULL || J2KNullityInferrer.this.isNotNull(methodReturnType);
            for (PsiReturnStatement statement : statements2) {
                PsiType returnValueType;
                PsiExpression returnValue = statement.getReturnValue();
                if (returnValue == null || (returnValueType = NullityInferrerVisitor.getReferenceType(returnValue)) == null) continue;
                if (rawMethodReturnTypeIsNotNull) {
                    this.propagateRawNullabilityWithPsiContext(methodReturnType, returnValueType);
                    this.propagateRawNullabilityWithPsiContext(methodReturnType, returnValue.getType());
                }
                if (!J2KNullityInferrer.this.isNotNull(returnValueType)) {
                    allRawReturnValueTypesAreNotNull = false;
                }
                this.unifyGenericNullability(methodReturnType, returnValueType);
            }
            if (allRawReturnValueTypesAreNotNull) {
                J2KNullityInferrer.this.registerNotNullType(methodReturnType);
            }
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            if (variable == null) {
                NullityInferrerVisitor.$$$reportNull$$$0(2);
            }
            super.visitLocalVariable(variable);
            PsiType variableType = variable.getType();
            if (variableType instanceof PsiPrimitiveType) {
                return;
            }
            if (!J2KNullityInferrer.this.hasRawNullability(variableType)) {
                J2KNullityInferrer.this.registerAnnotationByNullAssignmentStatus((PsiVariable)variable);
            }
            this.inferNullabilityFromVariableReferences((PsiVariable)variable);
            this.propagateNullabilityFromVariable((PsiVariable)variable);
        }

        private void inferNullabilityFromVariableReferences(@NotNull PsiVariable variable) {
            if (variable == null) {
                NullityInferrerVisitor.$$$reportNull$$$0(3);
            }
            if (KotlinPluginModeProvider.Companion.isK1Mode()) {
                return;
            }
            Collection<PsiReference> references = J2KNullityInferrer.this.variableReferences.get(variable);
            for (PsiReference reference : references) {
                PsiElement element = reference.getElement();
                if (!(element instanceof PsiReferenceExpression)) continue;
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
                PsiElement refParent = PsiTreeUtil.skipParentsOfType((PsiElement)referenceExpression, (Class[])new Class[]{PsiParenthesizedExpression.class, PsiTypeCastExpression.class});
                this.processReference(variable, referenceExpression, refParent);
            }
        }

        private void propagateNullabilityFromVariable(PsiVariable variable) {
            if (KotlinPluginModeProvider.Companion.isK1Mode()) {
                return;
            }
            PsiType variableType = variable.getType();
            Collection<PsiExpression> rightHandSides = J2KNullityInferrer.this.variableAssignmentRightHandSides.get(variable);
            for (PsiExpression expr : rightHandSides) {
                PsiType exprType2 = expr.getType();
                PsiType referenceType = NullityInferrerVisitor.getReferenceType(expr);
                if (J2KNullityInferrer.this.isNullable(exprType2) || J2KNullityInferrer.this.isNullable(referenceType)) {
                    J2KNullityInferrer.this.registerNullableType(variableType);
                } else if (J2KNullityInferrer.this.isNotNull(variableType)) {
                    this.propagateRawNullabilityWithPsiContext(variableType, exprType2);
                    this.propagateRawNullabilityWithPsiContext(variableType, referenceType);
                }
                this.unifyGenericNullabilityWithPsiContext(variableType, exprType2);
                this.unifyGenericNullabilityWithPsiContext(variableType, referenceType);
            }
        }

        @Nullable
        private static PsiType getReferenceType(PsiExpression expression) {
            PsiMethodCallExpression methodCallExpression;
            PsiMethod method;
            if (expression instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
                PsiElement target = referenceExpression.resolve();
                if (target instanceof PsiVariable) {
                    PsiVariable variable = (PsiVariable)target;
                    return variable.getType();
                }
            } else if (expression instanceof PsiMethodCallExpression && (method = (methodCallExpression = (PsiMethodCallExpression)expression).resolveMethod()) != null) {
                return method.getReturnType();
            }
            return expression.getType();
        }

        private void unifyGenericNullabilityWithPsiContext(@Nullable PsiType type1, @Nullable PsiType type2) {
            this.propagateGenericNullabilityWithPsiContext(type1, type2);
            this.propagateGenericNullabilityWithPsiContext(type2, type1);
        }

        private void propagateGenericNullabilityWithPsiContext(@Nullable PsiType originType, @Nullable PsiType targetType) {
            if (originType == null || targetType == null) {
                return;
            }
            int prevCount = J2KNullityInferrer.this.numAnnotationsAdded;
            this.propagateGenericNullability(originType, targetType, false);
            if (prevCount == J2KNullityInferrer.this.numAnnotationsAdded) {
                return;
            }
            PsiType psiContextType = NullityInferrerVisitor.getPsiContextType(targetType);
            if (psiContextType != null) {
                this.propagateGenericNullabilityWithPsiContext(originType, psiContextType);
            }
        }

        @Nullable
        private static PsiType getPsiContextType(@NotNull PsiType type2) {
            if (type2 == null) {
                NullityInferrerVisitor.$$$reportNull$$$0(4);
            }
            if (!(type2 instanceof PsiClassType)) {
                return null;
            }
            PsiClassType classType = (PsiClassType)type2;
            PsiElement psiContext = classType.getPsiContext();
            if (!(psiContext instanceof PsiJavaCodeReferenceElement)) {
                return null;
            }
            PsiJavaCodeReferenceElement javaCodeReferenceElement = (PsiJavaCodeReferenceElement)psiContext;
            PsiElement codeReferenceElementParent = javaCodeReferenceElement.getParent();
            if (!(codeReferenceElementParent instanceof PsiTypeElement)) {
                return null;
            }
            PsiTypeElement typeElement2 = (PsiTypeElement)codeReferenceElementParent;
            PsiType psiContextType = typeElement2.getType();
            if (type2 == psiContextType) {
                return null;
            }
            return psiContextType;
        }

        public void visitParameter(@NotNull PsiParameter parameter) {
            if (parameter == null) {
                NullityInferrerVisitor.$$$reportNull$$$0(5);
            }
            super.visitParameter(parameter);
            if (parameter.getType() instanceof PsiPrimitiveType) {
                return;
            }
            PsiElement grandParent = parameter.getDeclarationScope();
            if (grandParent instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)grandParent;
                if (method.getBody() != null) {
                    if (JavaSourceInference.inferNullability((PsiParameter)parameter) == Nullability.NOT_NULL) {
                        J2KNullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter);
                    }
                    List<PsiReferenceExpression> references = J2KNullityInferrer.this.parameterReferences.get(parameter);
                    for (PsiReferenceExpression expr : references) {
                        PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)expr, (Class[])new Class[]{PsiParenthesizedExpression.class, PsiTypeCastExpression.class});
                        this.processReference((PsiVariable)parameter, expr, parent);
                        if (!J2KNullityInferrer.this.isNotNull((PsiModifierListOwner)method)) continue;
                        PsiElement toReturn = parent;
                        if (parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getCondition() != expr) {
                            toReturn = parent.getParent();
                        }
                        if (!(toReturn instanceof PsiReturnStatement)) continue;
                        J2KNullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter);
                    }
                }
            } else if (grandParent instanceof PsiForeachStatement) {
                PsiForeachStatement foreachStatement = (PsiForeachStatement)grandParent;
                for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter, (SearchScope)new LocalSearchScope((PsiElement)foreachStatement)).asIterable()) {
                    PsiElement parent;
                    PsiReferenceExpression expr;
                    PsiElement place = reference.getElement();
                    if (!(place instanceof PsiReferenceExpression) || !this.processReference((PsiVariable)parameter, expr = (PsiReferenceExpression)place, parent = PsiTreeUtil.skipParentsOfType((PsiElement)expr, (Class[])new Class[]{PsiParenthesizedExpression.class, PsiTypeCastExpression.class}))) continue;
                    this.propagateRawNullabilityToIterableComponentType(foreachStatement);
                }
            } else {
                J2KNullityInferrer.this.registerAnnotationByNullAssignmentStatus((PsiVariable)parameter);
            }
        }

        private void propagateRawNullabilityToIterableComponentType(@NotNull PsiForeachStatement foreachStatement) {
            if (foreachStatement == null) {
                NullityInferrerVisitor.$$$reportNull$$$0(6);
            }
            if (KotlinPluginModeProvider.Companion.isK1Mode()) {
                return;
            }
            PsiType parameterType = foreachStatement.getIterationParameter().getType();
            if (!J2KNullityInferrer.this.isNullable(parameterType) && !J2KNullityInferrer.this.isNotNull(parameterType)) {
                return;
            }
            PsiExpression iteratedValue = foreachStatement.getIteratedValue();
            if (iteratedValue == null) {
                return;
            }
            PsiType componentType = JavaGenericsUtil.getCollectionItemType((PsiExpression)iteratedValue);
            if (componentType == null) {
                return;
            }
            this.propagateRawNullabilityWithPsiContext(parameterType, componentType);
        }

        private void propagateRawNullabilityWithPsiContext(@Nullable PsiType originType, @Nullable PsiType targetType) {
            if (originType == null || targetType == null) {
                return;
            }
            if (J2KNullityInferrer.this.isNullable(targetType) || J2KNullityInferrer.this.isNotNull(targetType)) {
                return;
            }
            if (J2KNullityInferrer.this.isNullable(originType)) {
                J2KNullityInferrer.this.registerNullableType(targetType);
            } else if (J2KNullityInferrer.this.isNotNull(originType)) {
                J2KNullityInferrer.this.registerNotNullType(targetType);
            }
            PsiType psiContextType = NullityInferrerVisitor.getPsiContextType(targetType);
            if (psiContextType != null) {
                this.propagateRawNullabilityWithPsiContext(originType, psiContextType);
            }
        }

        private boolean processReference(@NotNull PsiVariable variable, @NotNull PsiReferenceExpression expr, PsiElement parent) {
            PsiSwitchStatement switchStatement;
            if (variable == null) {
                NullityInferrerVisitor.$$$reportNull$$$0(7);
            }
            if (expr == null) {
                NullityInferrerVisitor.$$$reportNull$$$0(8);
            }
            if (NullabilityUtilsKt.isUsedInAutoUnboxingContext(expr)) {
                J2KNullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)variable);
                return true;
            }
            if (PsiUtil.isAccessedForWriting((PsiExpression)expr)) {
                return true;
            }
            if (NullabilityUtilsKt.getExpressionDfaNullability((PsiExpression)expr) == DfaNullability.NOT_NULL) {
                this.processArgumentReference(variable, expr, false);
                return false;
            }
            if (parent instanceof PsiThrowStatement) {
                J2KNullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)variable);
                return true;
            }
            if (parent instanceof PsiSynchronizedStatement) {
                J2KNullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)variable);
                return true;
            }
            if (parent instanceof PsiArrayAccessExpression) {
                J2KNullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)variable);
                return true;
            }
            if (parent instanceof PsiBinaryExpression) {
                PsiBinaryExpression binOp = (PsiBinaryExpression)parent;
                PsiExpression opposite = null;
                PsiExpression lOperand = binOp.getLOperand();
                PsiExpression rOperand = binOp.getROperand();
                if (lOperand == expr) {
                    opposite = rOperand;
                } else if (rOperand == expr) {
                    opposite = lOperand;
                }
                if (opposite != null && opposite.getType() == PsiTypes.nullType()) {
                    if (DfaPsiUtil.isAssertionEffectively((PsiExpression)binOp, (binOp.getOperationTokenType() == JavaTokenType.NE ? 1 : 0) != 0)) {
                        J2KNullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)variable);
                        return true;
                    }
                    J2KNullityInferrer.this.registerNullableAnnotation((PsiModifierListOwner)variable);
                    return true;
                }
            } else if (parent instanceof PsiReferenceExpression) {
                PsiReferenceExpression ref = (PsiReferenceExpression)parent;
                PsiExpression qualifierExpression = ref.getQualifierExpression();
                if (qualifierExpression == expr) {
                    J2KNullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)variable);
                    return true;
                }
                PsiElement exprParent = expr.getParent();
                while (exprParent instanceof PsiTypeCastExpression || exprParent instanceof PsiParenthesizedExpression) {
                    if (qualifierExpression == exprParent) {
                        J2KNullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)variable);
                        return true;
                    }
                    exprParent = exprParent.getParent();
                }
            } else if (parent instanceof PsiAssignmentExpression) {
                PsiVariable localVar;
                PsiReferenceExpression ref;
                PsiExpression psiExpression;
                PsiAssignmentExpression assignment2 = (PsiAssignmentExpression)parent;
                if (assignment2.getRExpression() == expr && (psiExpression = assignment2.getLExpression()) instanceof PsiReferenceExpression && (psiExpression = (ref = (PsiReferenceExpression)psiExpression).resolve()) instanceof PsiVariable && J2KNullityInferrer.this.isNotNull((PsiModifierListOwner)(localVar = (PsiVariable)psiExpression))) {
                    J2KNullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)variable);
                    return true;
                }
            } else if (parent instanceof PsiForeachStatement) {
                PsiForeachStatement forEach = (PsiForeachStatement)parent;
                if (forEach.getIteratedValue() == expr) {
                    J2KNullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)variable);
                    return true;
                }
            } else if (parent instanceof PsiSwitchStatement && (switchStatement = (PsiSwitchStatement)parent).getExpression() == expr) {
                J2KNullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)variable);
                return true;
            }
            return this.processArgumentReference(variable, expr, true);
        }

        private boolean processArgumentReference(@NotNull PsiVariable variable, @NotNull PsiReferenceExpression expr, boolean updateRawNullability) {
            PsiCall call2;
            if (variable == null) {
                NullityInferrerVisitor.$$$reportNull$$$0(9);
            }
            if (expr == null) {
                NullityInferrerVisitor.$$$reportNull$$$0(10);
            }
            if ((call2 = (PsiCall)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiCall.class)) == null) {
                return false;
            }
            PsiExpressionList argumentList = call2.getArgumentList();
            if (argumentList == null) {
                return false;
            }
            Object[] args = argumentList.getExpressions();
            int idx = ArrayUtil.find((Object[])args, (Object)expr);
            if (idx < 0) {
                return false;
            }
            PsiMethod resolvedMethod = call2.resolveMethod();
            if (resolvedMethod == null) {
                return false;
            }
            PsiParameter[] parameters2 = resolvedMethod.getParameterList().getParameters();
            if (idx >= parameters2.length) {
                return false;
            }
            PsiParameter resolvedToParam = parameters2[idx];
            if (resolvedToParam instanceof LightRecordCanonicalConstructor.LightRecordConstructorParameter) {
                resolvedToParam = ((LightRecordCanonicalConstructor.LightRecordConstructorParameter)resolvedToParam).getRecordComponent();
            }
            if (resolvedToParam == null) {
                return false;
            }
            PsiType variableType = variable.getType();
            PsiType parameterType = resolvedToParam.getType();
            this.unifyGenericNullability(variableType, parameterType);
            if (!updateRawNullability) {
                return false;
            }
            if (J2KNullityInferrer.this.isNotNull((PsiModifierListOwner)resolvedToParam) || variableType instanceof PsiArrayType && !NullityInferrerVisitor.isVarArgs(variable) && NullityInferrerVisitor.isVarArgs((PsiVariable)resolvedToParam)) {
                J2KNullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)variable);
                return true;
            }
            return false;
        }

        private static boolean isVarArgs(PsiVariable variable) {
            if (variable instanceof PsiParameter) {
                return ((PsiParameter)variable).isVarArgs();
            }
            if (variable instanceof PsiRecordComponent) {
                return ((PsiRecordComponent)variable).isVarArgs();
            }
            return false;
        }

        private void unifyGenericNullability(PsiType type1, PsiType type2) {
            this.propagateGenericNullability(type1, type2, false);
            this.propagateGenericNullability(type2, type1, false);
        }

        private void propagateGenericNullability(PsiType originType, PsiType targetType, boolean updateRawType) {
            if (KotlinPluginModeProvider.Companion.isK1Mode()) {
                return;
            }
            if (updateRawType) {
                if (J2KNullityInferrer.this.isNotNull(originType)) {
                    J2KNullityInferrer.this.registerNotNullType(targetType);
                } else if (J2KNullityInferrer.this.isNullable(originType)) {
                    J2KNullityInferrer.this.registerNullableType(targetType);
                }
            }
            if (originType instanceof PsiArrayType) {
                PsiArrayType originArrayType = (PsiArrayType)originType;
                if (targetType instanceof PsiArrayType) {
                    PsiArrayType targetArrayType = (PsiArrayType)targetType;
                    PsiType originComponentType = originArrayType.getComponentType();
                    PsiType targetComponentType = targetArrayType.getComponentType();
                    this.propagateGenericNullability(originComponentType, targetComponentType, true);
                }
            }
            if (!(originType instanceof PsiClassType)) {
                return;
            }
            PsiClassType originClassType = (PsiClassType)originType;
            if (!(targetType instanceof PsiClassType)) {
                return;
            }
            PsiClassType targetClassType = (PsiClassType)targetType;
            PsiType[] originTypeArguments = originClassType.getParameters();
            PsiType[] targetTypeArguments = targetClassType.getParameters();
            if (originTypeArguments.length != targetTypeArguments.length) {
                return;
            }
            for (int i2 = 0; i2 < originTypeArguments.length; ++i2) {
                PsiType originTypeArgument = originTypeArguments[i2];
                PsiType targetTypeArgument = targetTypeArguments[i2];
                this.propagateGenericNullability(originTypeArgument, targetTypeArgument, true);
            }
        }

        public void visitField(@NotNull PsiField field2) {
            if (field2 == null) {
                NullityInferrerVisitor.$$$reportNull$$$0(11);
            }
            super.visitField(field2);
            if (field2 instanceof PsiEnumConstant) {
                return;
            }
            PsiType fieldType = field2.getType();
            if (fieldType instanceof PsiPrimitiveType) {
                return;
            }
            if (!J2KNullityInferrer.this.hasRawNullability(fieldType)) {
                J2KNullityInferrer.this.registerAnnotationByNullAssignmentStatus((PsiVariable)field2);
            }
            this.inferNullabilityFromVariableReferences((PsiVariable)field2);
            this.propagateNullabilityFromVariable((PsiVariable)field2);
        }

        public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
            if (reference == null) {
                NullityInferrerVisitor.$$$reportNull$$$0(12);
            }
            if (KotlinPluginModeProvider.Companion.isK1Mode()) {
                return;
            }
            PsiElement target = reference.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass klass = (PsiClass)target;
            PsiTypeParameter[] typeParameters2 = klass.getTypeParameters();
            PsiType[] typeArguments2 = reference.getTypeParameters();
            this.updateNullabilityOfTypeArguments(typeParameters2, typeArguments2);
        }

        private void updateNullabilityOfTypeArguments(PsiTypeParameter[] typeParameters2, PsiType[] typeArguments2) {
            if (KotlinPluginModeProvider.Companion.isK1Mode()) {
                return;
            }
            if (typeParameters2.length != typeArguments2.length) {
                return;
            }
            block4: for (int i2 = 0; i2 < typeParameters2.length; ++i2) {
                PsiTypeParameter typeParameter = typeParameters2[i2];
                PsiType typeArgument = typeArguments2[i2];
                Nullability nullability = NullabilityUtilsKt.getTypeParameterNullability(typeParameter);
                switch (nullability) {
                    case NULLABLE: {
                        J2KNullityInferrer.this.registerNullableType(typeArgument);
                        continue block4;
                    }
                    case NOT_NULL: {
                        J2KNullityInferrer.this.registerNotNullType(typeArgument);
                    }
                }
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiExpression[] argumentList;
            if (expression == null) {
                NullityInferrerVisitor.$$$reportNull$$$0(13);
            }
            if (KotlinPluginModeProvider.Companion.isK1Mode()) {
                return;
            }
            super.visitMethodCallExpression(expression);
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            for (PsiExpression argument2 : argumentList = expression.getArgumentList().getExpressions()) {
                PsiParameter parameter = MethodCallUtils.getParameterForArgument((PsiExpression)argument2);
                if (parameter == null) continue;
                PsiType parameterType = parameter.getType();
                PsiType argumentType = NullityInferrerVisitor.getReferenceType(argument2);
                this.unifyGenericNullability(parameterType, argumentType);
            }
            PsiTypeParameter[] typeParameters2 = method.getTypeParameters();
            PsiType[] typeArguments2 = expression.getTypeArguments();
            this.updateNullabilityOfTypeArguments(typeParameters2, typeArguments2);
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                NullityInferrerVisitor.$$$reportNull$$$0(14);
            }
            if (KotlinPluginModeProvider.Companion.isK1Mode()) {
                return;
            }
            super.visitNewExpression(expression);
            PsiType psiType = expression.getType();
            if (!(psiType instanceof PsiArrayType)) {
                return;
            }
            PsiArrayType arrayType = (PsiArrayType)psiType;
            PsiType componentType = arrayType.getComponentType();
            PsiArrayInitializerExpression arrayInitializer = expression.getArrayInitializer();
            if (arrayInitializer == null) {
                return;
            }
            PsiType arrayInitializerType = arrayInitializer.getType();
            if (!(arrayInitializerType instanceof PsiArrayType)) {
                return;
            }
            PsiArrayType arrayInitializerArrayType = (PsiArrayType)arrayInitializerType;
            PsiType arrayInitializerComponentType = arrayInitializerArrayType.getComponentType();
            PsiExpression[] initializers = arrayInitializer.getInitializers();
            if (initializers.length == 0) {
                return;
            }
            for (PsiExpression initializer2 : initializers) {
                Nullability nullability = NullabilityUtil.getExpressionNullability((PsiExpression)initializer2, (boolean)true);
                if (nullability == Nullability.NULLABLE) {
                    J2KNullityInferrer.this.registerNullableType(componentType);
                    J2KNullityInferrer.this.registerNullableType(arrayInitializerComponentType);
                    return;
                }
                if (nullability != Nullability.UNKNOWN) continue;
                return;
            }
            J2KNullityInferrer.this.registerNotNullType(componentType);
            J2KNullityInferrer.this.registerNotNullType(arrayInitializerComponentType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 2: 
                case 3: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "foreachStatement";
                    break;
                }
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expr";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/nj2k/J2KNullityInferrer$NullityInferrerVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "unifyNullabilityOfMethodReturnTypeAndReturnedExpressions";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLocalVariable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "inferNullabilityFromVariableReferences";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPsiContextType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParameter";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propagateRawNullabilityToIterableComponentType";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processReference";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processArgumentReference";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceElement";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNewExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

