/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclaration;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.shorten.DelayedRequestsWaitingSetKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.rename.KotlinRenameRefactoringSupport;
import org.jetbrains.kotlin.idea.refactoring.rename.RenameConflictUtilsKt;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchUtilsKt;
import org.jetbrains.kotlin.name.NameUtils;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0019\u001a\u00020\u0010H\u0016J \u0010\u001a\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\u001b2\u0006\u0010\u0019\u001a\u00020\u0010H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020!H\u0016J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u000f2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J\u0010\u0010'\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0007H\u0016J\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020)H\u0016\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/K1RenameRefactoringSupport;", "Lorg/jetbrains/kotlin/idea/refactoring/rename/KotlinRenameRefactoringSupport;", "<init>", "()V", "checkUsagesRetargeting", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "newName", "", "originalUsages", "", "Lcom/intellij/usageView/UsageInfo;", "newUsages", "getAllOverridenFunctions", "", "Lcom/intellij/psi/PsiElement;", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "mangleInternalName", "name", "moduleName", "demangleInternalName", "mangledName", "getJvmName", "element", "getJvmNamesForPropertyAccessors", "Lkotlin/Pair;", "isCompanionObjectClassReference", "", "psiReference", "Lcom/intellij/psi/PsiReference;", "shortenReferencesLater", "Lorg/jetbrains/kotlin/psi/KtElement;", "findAllOverridingMethods", "Lcom/intellij/psi/PsiMethod;", "scope", "Lcom/intellij/psi/search/SearchScope;", "getMethods", "dropOverrideKeywordIfNecessary", "isLightClassForRegularKotlinClass", "Lorg/jetbrains/kotlin/asJava/classes/KtLightClass;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nK1KotlinRenameRefactoringSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K1KotlinRenameRefactoringSupport.kt\norg/jetbrains/kotlin/idea/refactoring/rename/K1RenameRefactoringSupport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1617#2,9:112\n1869#2:121\n1870#2:123\n1626#2:124\n1#3:122\n1#3:125\n*S KotlinDebug\n*F\n+ 1 K1KotlinRenameRefactoringSupport.kt\norg/jetbrains/kotlin/idea/refactoring/rename/K1RenameRefactoringSupport\n*L\n44#1:112,9\n44#1:121\n44#1:123\n44#1:124\n44#1:122\n*E\n"})
public final class K1RenameRefactoringSupport
implements KotlinRenameRefactoringSupport {
    @Override
    public void checkUsagesRetargeting(@NotNull KtNamedDeclaration declaration, @NotNull String newName, @NotNull List<UsageInfo> originalUsages, @NotNull List<UsageInfo> newUsages) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(originalUsages, (String)"originalUsages");
        Intrinsics.checkNotNullParameter(newUsages, (String)"newUsages");
        RenameConflictUtilsKt.checkOriginalUsagesRetargeting(declaration, newName, originalUsages, newUsages);
        RenameConflictUtilsKt.checkNewNameUsagesRetargeting(declaration, newName, newUsages);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<PsiElement> getAllOverridenFunctions(@NotNull KtNamedFunction function) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.unsafeResolveToDescriptor$default((KtDeclaration)function, null, 1, null);
        Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
        FunctionDescriptor descriptor2 = (FunctionDescriptor)declarationDescriptor;
        Collection collection = descriptor2.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOverriddenDescriptors(...)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PsiElement it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FunctionDescriptor it = (FunctionDescriptor)element$iv$iv;
            boolean bl2 = false;
            SourceElement sourceElement = it.getSource();
            Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"getSource(...)");
            if (PsiSourceElementKt.getPsi((SourceElement)sourceElement) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public String mangleInternalName(@NotNull String name2, @NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        return name2 + "$" + NameUtils.sanitizeAsJavaIdentifier((String)moduleName);
    }

    @Override
    @Nullable
    public String demangleInternalName(@NotNull String mangledName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)mangledName, (String)"mangledName");
        int indexOfDollar = StringsKt.indexOf$default((CharSequence)mangledName, (char)'$', (int)0, (boolean)false, (int)6, null);
        if (indexOfDollar >= 0) {
            String string2 = mangledName.substring(0, indexOfDollar);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @Nullable
    public String getJvmName(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = LightClassUtilsKt.getUnwrapped((PsiElement)element);
        KtFunction ktFunction = psiElement instanceof KtFunction ? (KtFunction)psiElement : null;
        DeclarationDescriptor declarationDescriptor = ktFunction != null ? ResolutionUtils.unsafeResolveToDescriptor$default((KtDeclaration)ktFunction, null, 1, null) : null;
        FunctionDescriptor functionDescriptor = declarationDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)declarationDescriptor : null;
        if (functionDescriptor == null) {
            return null;
        }
        FunctionDescriptor descriptor2 = functionDescriptor;
        return DescriptorUtils.getJvmName((Annotated)((Annotated)descriptor2));
    }

    @Override
    @NotNull
    public Pair<String, String> getJvmNamesForPropertyAccessors(@NotNull PsiElement element) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = LightClassUtilsKt.getUnwrapped((PsiElement)element);
        KtDeclaration ktDeclaration = psiElement instanceof KtDeclaration ? (KtDeclaration)psiElement : null;
        DeclarationDescriptor declarationDescriptor = ktDeclaration != null ? ResolutionUtils.unsafeResolveToDescriptor$default(ktDeclaration, null, 1, null) : null;
        PropertyDescriptor propertyDescriptor = declarationDescriptor instanceof PropertyDescriptor ? (PropertyDescriptor)declarationDescriptor : null;
        if (propertyDescriptor == null) {
            return TuplesKt.to(null, null);
        }
        PropertyDescriptor descriptor2 = propertyDescriptor;
        PropertyGetterDescriptor propertyGetterDescriptor = descriptor2.getGetter();
        if (propertyGetterDescriptor != null) {
            PropertyGetterDescriptor it = propertyGetterDescriptor;
            boolean bl = false;
            string2 = DescriptorUtils.getJvmName((Annotated)((Annotated)it));
        } else {
            string2 = null;
        }
        String getterName = string2;
        PropertySetterDescriptor propertySetterDescriptor = descriptor2.getSetter();
        if (propertySetterDescriptor != null) {
            PropertySetterDescriptor it = propertySetterDescriptor;
            boolean bl = false;
            string = DescriptorUtils.getJvmName((Annotated)((Annotated)it));
        } else {
            string = null;
        }
        String setterName = string;
        return TuplesKt.to((Object)getterName, (Object)setterName);
    }

    @Override
    public boolean isCompanionObjectClassReference(@NotNull PsiReference psiReference) {
        Intrinsics.checkNotNullParameter((Object)psiReference, (String)"psiReference");
        if (!(psiReference instanceof KtSimpleNameReference)) {
            return false;
        }
        PsiElement psiElement = ((KtSimpleNameReference)psiReference).getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        BindingContext bindingContext = ResolutionUtils.analyze((KtElement)psiElement, BodyResolveMode.PARTIAL);
        return bindingContext.get((ReadOnlySlice)BindingContext.SHORT_REFERENCE_TO_COMPANION_OBJECT, (Object)((KtSimpleNameReference)psiReference).getElement()) != null;
    }

    @Override
    public void shortenReferencesLater(@NotNull KtElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        DelayedRequestsWaitingSetKt.addToShorteningWaitSet(element, ShortenReferences.Options.Companion.getALL_ENABLED());
    }

    @NotNull
    public List<PsiMethod> findAllOverridingMethods(@NotNull PsiElement element, @NotNull SearchScope scope) {
        List list2;
        Object object;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
                object = element instanceof PsiMethod ? (PsiMethod)element : null;
                if (object == null) break block5;
                PsiMethod it = object;
                boolean bl = false;
                List list3 = CollectionsKt.listOf((Object)it);
                object = list3;
                if (list3 != null) break block6;
            }
            if ((object = (List)ActionsKt.runReadAction(() -> K1RenameRefactoringSupport.findAllOverridingMethods$lambda$1(this, element))) == null) {
                return CollectionsKt.emptyList();
            }
        }
        Object psiMethods = object;
        List $this$findAllOverridingMethods_u24lambda_u242 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterator iterator2 = psiMethods.iterator();
        while (iterator2.hasNext()) {
            PsiMethod m = (PsiMethod)iterator2.next();
            OverridersSearchUtilsKt.forEachOverridingMethod(m, scope, (Function1<? super PsiMethod, Boolean>)((Function1)arg_0 -> K1RenameRefactoringSupport.findAllOverridingMethods$lambda$2$0($this$findAllOverridingMethods_u24lambda_u242, arg_0)));
        }
        return CollectionsKt.build((List)list2);
    }

    private final List<PsiMethod> getMethods(PsiElement element) {
        List list2;
        if (element instanceof KtFunction) {
            PsiMethod psiMethod = LightClassUtil.INSTANCE.getLightClassMethod((KtFunction)element);
            if (psiMethod != null) {
                PsiMethod it = psiMethod;
                boolean bl = false;
                list2 = CollectionsKt.listOf((Object)it);
            } else {
                list2 = null;
            }
        } else if (element instanceof KtProperty) {
            List list3;
            LightClassUtil.PropertyAccessorsPsiMethods propertyMethods = LightClassUtil.INSTANCE.getLightClassPropertyMethods((KtProperty)element);
            List $this$getMethods_u24lambda_u241 = list3 = CollectionsKt.createListBuilder();
            boolean bl = false;
            UtilKt.addIfNotNull((List)$this$getMethods_u24lambda_u241, (Object)propertyMethods.getGetter());
            UtilKt.addIfNotNull((List)$this$getMethods_u24lambda_u241, (Object)propertyMethods.getSetter());
            List it = list3 = CollectionsKt.build((List)list3);
            boolean bl2 = false;
            list2 = !((Collection)it).isEmpty() ? list3 : null;
        } else {
            list2 = null;
        }
        return list2;
    }

    @Override
    public void dropOverrideKeywordIfNecessary(@NotNull KtNamedDeclaration element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KotlinRefactoringUtilKt.dropOverrideKeywordIfNecessary(element);
    }

    @Override
    public boolean isLightClassForRegularKotlinClass(@NotNull KtLightClass element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof KtLightClassForSourceDeclaration;
    }

    private static final List findAllOverridingMethods$lambda$1(K1RenameRefactoringSupport this$0, PsiElement $element) {
        return this$0.getMethods($element);
    }

    private static final boolean findAllOverridingMethods$lambda$2$0(List $this_buildList, PsiMethod it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this_buildList.add(it);
        return true;
    }
}

