/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.ReportingClassSubstitutor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.quickfix.QuickFixWithDelegateFactoryKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\f\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J\b\u0010\u000f\u001a\u00020\tH\u0016J\b\u0010\u0010\u001a\u00020\tH\u0016J\"\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J%\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\t8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/QuickFixWithDelegateFactory;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/openapi/diagnostic/ReportingClassSubstitutor;", "delegateFactory", "Lkotlin/Function0;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "delegate", "familyName", "", "text", "startInWriteAction", "", "getSubstitutedClass", "Ljava/lang/Class;", "getFamilyName", "getText", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "invoke", "", "kotlin.idea"})
public class QuickFixWithDelegateFactory
implements IntentionAction,
ReportingClassSubstitutor {
    @Nullable
    private final IntentionAction delegate;
    @Nls
    @NotNull
    private final String familyName;
    @Nls
    @NotNull
    private final String text;
    private final boolean startInWriteAction;

    public QuickFixWithDelegateFactory(@NotNull Function0<? extends IntentionAction> delegateFactory) {
        Object object;
        Intrinsics.checkNotNullParameter(delegateFactory, (String)"delegateFactory");
        this.delegate = (IntentionAction)delegateFactory.invoke();
        Object object2 = this.delegate;
        if (object2 == null || (object2 = object2.getFamilyName()) == null) {
            object2 = this.familyName = "";
        }
        if ((object = this.delegate) == null || (object = object.getText()) == null) {
            object = "";
        }
        this.text = object;
        this.startInWriteAction = this.delegate != null && this.delegate.startInWriteAction();
    }

    @NotNull
    public Class<?> getSubstitutedClass() {
        Object object = this.delegate;
        if (object == null || (object = object.getClass()) == null) {
            object = this.getClass();
        }
        return object;
    }

    @NotNull
    public String getFamilyName() {
        return this.familyName;
    }

    @NotNull
    public String getText() {
        return this.text;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        IntentionAction intentionAction = this.delegate;
        return intentionAction != null ? intentionAction.isAvailable(project, editor, file) : false;
    }

    public boolean startInWriteAction() {
        return this.startInWriteAction;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        IntentionAction intentionAction = this.delegate;
        if (intentionAction == null) {
            return;
        }
        IntentionAction action2 = intentionAction;
        boolean bl2 = bl = QuickFixWithDelegateFactoryKt.detectPriority(action2) == QuickFixWithDelegateFactoryKt.detectPriority(this);
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Incorrect priority of QuickFixWithDelegateFactory wrapper for " + action2.getClass().getName();
            throw new AssertionError((Object)string);
        }
        action2.invoke(project, editor, file);
    }
}

