/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.presentation;

import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.presentation.DeclarationPresentersKt;
import org.jetbrains.kotlin.idea.presentation.KotlinDefaultNamedDeclarationPresentation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0005H\u0016J\u0012\u0010\t\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\n\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/presentation/KotlinFunctionPresentation;", "Lorg/jetbrains/kotlin/idea/presentation/KotlinDefaultNamedDeclarationPresentation;", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "name", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFunction;Ljava/lang/String;)V", "getPresentableText", "getTrimmedTypeText", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "getLocationString", "intellij.kotlin.base.analysis"})
@SourceDebugExtension(value={"SMAP\nDeclarationPresenters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarationPresenters.kt\norg/jetbrains/kotlin/idea/presentation/KotlinFunctionPresentation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n1#2:161\n*E\n"})
public class KotlinFunctionPresentation
extends KotlinDefaultNamedDeclarationPresentation {
    @NotNull
    private final KtFunction function;
    @Nullable
    private final String name;

    public KotlinFunctionPresentation(@NotNull KtFunction function, @Nullable String name2) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        super((KtNamedDeclaration)function);
        this.function = function;
        this.name = name2;
    }

    public /* synthetic */ KotlinFunctionPresentation(KtFunction ktFunction, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = ktFunction.getName();
        }
        this(ktFunction, string);
    }

    @Override
    @NotNull
    public String getPresentableText() {
        StringBuilder stringBuilder;
        StringBuilder $this$getPresentableText_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String receiverTypeText = this.getTrimmedTypeText(this.function.getReceiverTypeReference());
        if (((CharSequence)receiverTypeText).length() > 0) {
            $this$getPresentableText_u24lambda_u240.append(receiverTypeText + ".");
        }
        String string = this.name;
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            $this$getPresentableText_u24lambda_u240.append(it);
        }
        $this$getPresentableText_u24lambda_u240.append("(");
        List list2 = this.function.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
        $this$getPresentableText_u24lambda_u240.append(CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, arg_0 -> KotlinFunctionPresentation.getPresentableText$lambda$0$1(this, arg_0), (int)31, null));
        $this$getPresentableText_u24lambda_u240.append(")");
        return stringBuilder.toString();
    }

    private final String getTrimmedTypeText(KtTypeReference typeReference) {
        String string;
        KtTypeReference ktTypeReference = typeReference;
        Object typeElement2 = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
        KtTypeElement ktTypeElement = typeElement2;
        if (ktTypeElement == null) {
            string = "";
        } else if (ktTypeElement instanceof KtFunctionType) {
            string = typeReference.getShortTypeText();
        } else {
            KotlinPlaceHolderStub stub = (KotlinPlaceHolderStub)typeReference.getStub();
            if (stub != null || typeElement2 instanceof KtNullableType && ((KtNullableType)typeElement2).getInnerType() instanceof KtFunctionType) {
                string = typeReference.getShortTypeText();
            } else {
                String string2 = StringUtil.getShortName((String)typeReference.getTypeText());
                Intrinsics.checkNotNull((Object)string2);
                string = string2;
            }
        }
        String typeText = string;
        return typeText;
    }

    @Override
    @Nullable
    public String getLocationString() {
        if (this.function instanceof KtConstructor) {
            FqName fqName2 = ((KtConstructor)this.function).getContainingClassOrObject().getFqName();
            if (fqName2 == null) {
                return null;
            }
            FqName name2 = fqName2;
            return DeclarationPresentersKt.getPresentationInContainer(name2);
        }
        return super.getLocationString();
    }

    private static final CharSequence getPresentableText$lambda$0$1(KotlinFunctionPresentation this$0, KtParameter it) {
        KtTypeReference typeReference = it.getTypeReference();
        return (it.isVarArg() ? "vararg " : "") + this$0.getTrimmedTypeText(typeReference);
    }
}

