/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jvm.shared.scratch.ui;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ui.EditorLinesHighlighter;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ui.ScratchEditorLinesTranslator;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ui.ScratchEditorsState;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\fJ\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\b\u0010\u0014\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ui/ScratchEditorSyncHighlighter;", "", "state", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ui/ScratchEditorsState;", "sourceHighlighter", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ui/EditorLinesHighlighter;", "previewHighlighter", "translator", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ui/ScratchEditorLinesTranslator;", "<init>", "(Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ui/ScratchEditorsState;Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ui/EditorLinesHighlighter;Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ui/EditorLinesHighlighter;Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ui/ScratchEditorLinesTranslator;)V", "highlightSourceByPreview", "", "highlightPreviewBySource", "highlightByCurrentlyFocusedEditor", "highlightSourceByPreviewLine", "selectedPreviewLine", "", "highlightPreviewBySourceLine", "selectedSourceLine", "clearAllHighlights", "Companion", "kotlin.jvm.shared"})
@SourceDebugExtension(value={"SMAP\nScratchEditorSyncHighlighter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScratchEditorSyncHighlighter.kt\norg/jetbrains/kotlin/idea/jvm/shared/scratch/ui/ScratchEditorSyncHighlighter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,235:1\n1#2:236\n*E\n"})
final class ScratchEditorSyncHighlighter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScratchEditorsState state;
    @NotNull
    private final EditorLinesHighlighter sourceHighlighter;
    @NotNull
    private final EditorLinesHighlighter previewHighlighter;
    @NotNull
    private final ScratchEditorLinesTranslator translator;

    private ScratchEditorSyncHighlighter(ScratchEditorsState state, EditorLinesHighlighter sourceHighlighter, EditorLinesHighlighter previewHighlighter, ScratchEditorLinesTranslator translator) {
        this.state = state;
        this.sourceHighlighter = sourceHighlighter;
        this.previewHighlighter = previewHighlighter;
        this.translator = translator;
    }

    public final void highlightSourceByPreview() {
        block0: {
            this.clearAllHighlights();
            Integer n = this.state.getPreviewEditorCaretLine();
            if (n == null) break block0;
            int p0 = ((Number)n).intValue();
            boolean bl = false;
            this.highlightSourceByPreviewLine(p0);
        }
    }

    public final void highlightPreviewBySource() {
        block0: {
            this.clearAllHighlights();
            Integer n = this.state.getSourceEditorCaretLine();
            if (n == null) break block0;
            int p0 = ((Number)n).intValue();
            boolean bl = false;
            this.highlightPreviewBySourceLine(p0);
        }
    }

    public final void highlightByCurrentlyFocusedEditor() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.getFocusedEditor().ordinal()]) {
            case 1: {
                this.highlightPreviewBySource();
                break;
            }
            case 2: {
                this.highlightSourceByPreview();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void highlightSourceByPreviewLine(int selectedPreviewLine) {
        Pair<Integer, Integer> pair = this.translator.sourceLineToPreviewLines(selectedPreviewLine);
        if (pair == null) {
            return;
        }
        Pair<Integer, Integer> pair2 = pair;
        int from = ((Number)pair2.component1()).intValue();
        int to2 = ((Number)pair2.component2()).intValue();
        this.sourceHighlighter.highlightLines(from, to2);
    }

    private final void highlightPreviewBySourceLine(int selectedSourceLine) {
        Pair<Integer, Integer> pair = this.translator.previewLineToSourceLines(selectedSourceLine);
        if (pair == null) {
            return;
        }
        Pair<Integer, Integer> pair2 = pair;
        int from = ((Number)pair2.component1()).intValue();
        int to2 = ((Number)pair2.component2()).intValue();
        this.previewHighlighter.highlightLines(from, to2);
    }

    private final void clearAllHighlights() {
        this.sourceHighlighter.clearHighlights();
        this.previewHighlighter.clearHighlights();
    }

    public /* synthetic */ ScratchEditorSyncHighlighter(ScratchEditorsState state, EditorLinesHighlighter sourceHighlighter, EditorLinesHighlighter previewHighlighter, ScratchEditorLinesTranslator translator, DefaultConstructorMarker $constructor_marker) {
        this(state, sourceHighlighter, previewHighlighter, translator);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ui/ScratchEditorSyncHighlighter$Companion;", "", "<init>", "()V", "create", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ui/ScratchEditorSyncHighlighter;", "sourceEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "previewEditor", "translator", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ui/ScratchEditorLinesTranslator;", "kotlin.jvm.shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ScratchEditorSyncHighlighter create(@NotNull EditorEx sourceEditor, @NotNull EditorEx previewEditor, @NotNull ScratchEditorLinesTranslator translator) {
            Intrinsics.checkNotNullParameter((Object)sourceEditor, (String)"sourceEditor");
            Intrinsics.checkNotNullParameter((Object)previewEditor, (String)"previewEditor");
            Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
            return new ScratchEditorSyncHighlighter(new ScratchEditorsState(sourceEditor, previewEditor), new EditorLinesHighlighter((Editor)sourceEditor), new EditorLinesHighlighter((Editor)previewEditor), translator, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScratchEditorsState.FocusedEditor.values().length];
            try {
                nArray[ScratchEditorsState.FocusedEditor.SOURCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScratchEditorsState.FocusedEditor.PREVIEW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

