/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.j2k.post.processing.inference.common;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.BoundType;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.BoundTypeLabel;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.ClassReference;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.Constraint;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.ConstraintBound;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.DebugPrinter$addTypeVariablesNames$;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.DescriptorClassReference;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.EqualsConstraint;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.GenericLabel;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.InferenceContext;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.LiteralBound;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.LiteralLabel;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.Namer;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.NoClassReference;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.NullLiteralLabel;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.StarProjectionLabel;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.State;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.SubtypeConstraint;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.TypeParameter;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.TypeParameterLabel;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.TypeParameterReference;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.TypeVariable;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.TypeVariableBound;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.TypeVariableLabel;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.WithForcedStateBoundType;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\r\u001a\u00020\t*\u00020\u000eH\u0002J\n\u0010\r\u001a\u00020\t*\u00020\u000fJ\n\u0010\r\u001a\u00020\t*\u00020\u0010J\n\u0010\r\u001a\u00020\t*\u00020\u0011J\n\u0010\r\u001a\u00020\t*\u00020\u0012J\f\u0010\r\u001a\u00020\t*\u00020\u0013H\u0002J\n\u0010\u0014\u001a\u00020\u0015*\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\b\u001a\u00020\t*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/DebugPrinter;", "", "inferenceContext", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/InferenceContext;", "<init>", "(Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/InferenceContext;)V", "namer", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/Namer;", "name", "", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/TypeVariable;", "getName", "(Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/TypeVariable;)Ljava/lang/String;", "asString", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/ClassReference;", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/BoundTypeLabel;", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/State;", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/BoundType;", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/Constraint;", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/ConstraintBound;", "addTypeVariablesNames", "", "Lcom/intellij/psi/PsiElement;", "kotlin.j2k.k1.new.post-processing"})
@SourceDebugExtension(value={"SMAP\nDebugPrinter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugPrinter.kt\norg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/DebugPrinter\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,78:1\n463#2,15:79\n383#2,2:94\n395#2:96\n482#2:97\n*S KotlinDebug\n*F\n+ 1 DebugPrinter.kt\norg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/DebugPrinter\n*L\n62#1:79,15\n62#1:94,2\n62#1:96\n62#1:97\n*E\n"})
public final class DebugPrinter {
    @NotNull
    private final InferenceContext inferenceContext;
    @NotNull
    private final Namer namer;

    public DebugPrinter(@NotNull InferenceContext inferenceContext) {
        Intrinsics.checkNotNullParameter((Object)inferenceContext, (String)"inferenceContext");
        this.inferenceContext = inferenceContext;
        this.namer = new Namer(this.inferenceContext);
    }

    @NotNull
    public final String getName(@NotNull TypeVariable $this$name) {
        Intrinsics.checkNotNullParameter((Object)$this$name, (String)"<this>");
        return this.namer.name($this$name);
    }

    private final String asString(ClassReference $this$asString) {
        String string;
        ClassReference classReference = $this$asString;
        if (classReference instanceof DescriptorClassReference) {
            string = ((DescriptorClassReference)$this$asString).getDescriptor().getName().toString();
        } else if (classReference instanceof TypeParameterReference) {
            string = ((TypeParameterReference)$this$asString).getDescriptor().getName().toString();
        } else if (classReference instanceof NoClassReference) {
            string = "NoClassRef";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        return string2;
    }

    @NotNull
    public final String asString(@NotNull BoundTypeLabel $this$asString) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"<this>");
        BoundTypeLabel boundTypeLabel = $this$asString;
        if (boundTypeLabel instanceof TypeVariableLabel) {
            object = this.getName(((TypeVariableLabel)$this$asString).getTypeVariable()) + "@" + this.asString(((TypeVariableLabel)$this$asString).getTypeVariable().getClassReference());
        } else if (boundTypeLabel instanceof TypeParameterLabel) {
            String string = ((TypeParameterLabel)$this$asString).getTypeParameter().getName().asString();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        } else if (boundTypeLabel instanceof GenericLabel) {
            object = this.asString(((GenericLabel)$this$asString).getClassReference());
        } else if (Intrinsics.areEqual((Object)boundTypeLabel, (Object)StarProjectionLabel.INSTANCE)) {
            object = "*";
        } else if (Intrinsics.areEqual((Object)boundTypeLabel, (Object)NullLiteralLabel.INSTANCE)) {
            object = "NULL";
        } else if (Intrinsics.areEqual((Object)boundTypeLabel, (Object)LiteralLabel.INSTANCE)) {
            object = "LIT";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @NotNull
    public final String asString(@NotNull State $this$asString) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$asString), (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$asString.ordinal()]) {
            case 1 -> "L";
            case 2 -> "U";
            case 3 -> "?";
            case 4 -> "$";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final String asString(@NotNull BoundType $this$asString) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"<this>");
        StringBuilder $this$asString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$asString_u24lambda_u240.append(this.asString($this$asString.getLabel()));
        if (!((Collection)$this$asString.getTypeParameters()).isEmpty()) {
            CollectionsKt.joinTo$default((Iterable)$this$asString.getTypeParameters(), (Appendable)$this$asString_u24lambda_u240, (CharSequence)", ", (CharSequence)"<", (CharSequence)">", (int)0, null, arg_0 -> DebugPrinter.asString$lambda$0$0(this, arg_0), (int)48, null);
        }
        if ($this$asString instanceof WithForcedStateBoundType) {
            $this$asString_u24lambda_u240.append("!!");
            $this$asString_u24lambda_u240.append(this.asString(((WithForcedStateBoundType)$this$asString).getForcedState()));
        }
        return stringBuilder.toString();
    }

    @NotNull
    public final String asString(@NotNull Constraint $this$asString) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"<this>");
        Constraint constraint = $this$asString;
        if (constraint instanceof EqualsConstraint) {
            string = this.asString(((EqualsConstraint)$this$asString).getLeft()) + " := " + this.asString(((EqualsConstraint)$this$asString).getRight());
        } else if (constraint instanceof SubtypeConstraint) {
            string = this.asString(((SubtypeConstraint)$this$asString).getSubtype()) + " <: " + this.asString(((SubtypeConstraint)$this$asString).getSupertype());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string + " due to '" + $this$asString.getPriority() + "'";
    }

    private final String asString(ConstraintBound $this$asString) {
        String string;
        ConstraintBound constraintBound = $this$asString;
        if (constraintBound instanceof LiteralBound) {
            string = ((LiteralBound)$this$asString).getState().toString();
        } else if (constraintBound instanceof TypeVariableBound) {
            string = this.getName(((TypeVariableBound)$this$asString).getTypeVariable());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final void addTypeVariablesNames(@NotNull PsiElement $this$addTypeVariablesNames) {
        void $this$forEachDescendantOfType$iv$iv$iv$iv;
        void to$iv$iv$iv;
        void $this$collectDescendantsOfTypeTo$iv$iv$iv;
        void $this$collectDescendantsOfType$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$addTypeVariablesNames, (String)"<this>");
        Project project = $this$addTypeVariablesNames.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        PsiElement $this$collectDescendantsOfType_u24default$iv = $this$addTypeVariablesNames;
        Function1 predicate$iv = addTypeVariablesNames$$inlined$collectDescendantsOfType$default$1.INSTANCE;
        boolean $i$f$collectDescendantsOfType = false;
        PsiElement psiElement = $this$collectDescendantsOfType_u24default$iv;
        Function1 predicate$iv$iv = predicate$iv;
        boolean $i$f$collectDescendantsOfType2 = false;
        void var10_10 = $this$collectDescendantsOfType$iv$iv;
        Collection collection = new ArrayList();
        Function1 predicate$iv$iv$iv = predicate$iv$iv;
        boolean $i$f$collectDescendantsOfTypeTo = false;
        void var14_14 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Function1 action$iv$iv$iv$iv = (Function1)new Function1<KtTypeElement, Unit>(predicate$iv$iv$iv, (Collection)to$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Collection $to;
            {
                this.$predicate = $predicate;
                this.$to = $to;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                    this.$to.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv$iv$iv);
        $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtTypeElement) {
                    this.$action.invoke((Object)element);
                }
            }
        });
        for (KtTypeElement typeElement2 : (List)to$iv$iv$iv) {
            Object object = this.inferenceContext.getTypeElementToTypeVariable().get(typeElement2);
            if (object == null || (object = this.getName((TypeVariable)object)) == null) continue;
            Object typeVariableName = object;
            PsiComment comment = psiFactory.createComment("/*" + (String)typeVariableName + "@*/");
            typeElement2.getParent().addBefore((PsiElement)comment, (PsiElement)typeElement2);
        }
    }

    private static final CharSequence asString$lambda$0$0(DebugPrinter this$0, TypeParameter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.asString(it.getBoundType());
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.LOWER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.UPPER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.UNKNOWN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.UNUSED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

