/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.actions.generate.KotlinGenerateEqualsAndHashcodeAction;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u0082\u0001\u0002\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/GenerateEqualsOrHashCodeFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionName;", "Lorg/jetbrains/annotations/NotNull;", "startInWriteAction", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "Equals", "HashCode", "Lorg/jetbrains/kotlin/idea/inspections/GenerateEqualsOrHashCodeFix$Equals;", "Lorg/jetbrains/kotlin/idea/inspections/GenerateEqualsOrHashCodeFix$HashCode;", "kotlin.idea"})
public abstract sealed class GenerateEqualsOrHashCodeFix
implements LocalQuickFix {
    private GenerateEqualsOrHashCodeFix() {
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (!FileModificationService.getInstance().preparePsiElementForWrite(descriptor2.getPsiElement())) {
            return;
        }
        KotlinGenerateEqualsAndHashcodeAction kotlinGenerateEqualsAndHashcodeAction = new KotlinGenerateEqualsAndHashcodeAction();
        PsiElement psiElement = descriptor2.getPsiElement().getParent();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClass");
        kotlinGenerateEqualsAndHashcodeAction.doInvoke(project, null, (KtClassOrObject)((KtClass)psiElement));
    }

    public /* synthetic */ GenerateEqualsOrHashCodeFix(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/GenerateEqualsOrHashCodeFix$Equals;", "Lorg/jetbrains/kotlin/idea/inspections/GenerateEqualsOrHashCodeFix;", "<init>", "()V", "getName", "", "kotlin.idea"})
    public static final class Equals
    extends GenerateEqualsOrHashCodeFix {
        @NotNull
        public static final Equals INSTANCE = new Equals();

        private Equals() {
            super(null);
        }

        @NotNull
        public String getName() {
            return KotlinBundle.message((String)"equals.text", (Object[])new Object[0]);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/GenerateEqualsOrHashCodeFix$HashCode;", "Lorg/jetbrains/kotlin/idea/inspections/GenerateEqualsOrHashCodeFix;", "<init>", "()V", "getName", "", "kotlin.idea"})
    public static final class HashCode
    extends GenerateEqualsOrHashCodeFix {
        @NotNull
        public static final HashCode INSTANCE = new HashCode();

        private HashCode() {
            super(null);
        }

        @NotNull
        public String getName() {
            return KotlinBundle.message((String)"hash.code.text", (Object[])new Object[0]);
        }
    }
}

