/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stepping;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.LightOrRealThreadInfo;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.RealThreadInfo;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.statistics.Engine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.XSourcePosition;
import com.sun.jdi.Location;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.stepping.CoroutineJobInfo;
import org.jetbrains.kotlin.idea.debugger.core.stepping.DebuggerSteppingHelper;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinStepAction;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinSteppingCommandProviderKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u001c\u0010\u0010\u001a\u00060\u0011R\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u001a\u0010\u0014\u001a\u00060\bR\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ$\u0010\u0015\u001a\u00060\bR\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\"\u0010\u0018\u001a\u00060\bR\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\rR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/DebuggerSteppingHelper;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createStepOverCommand", "Lcom/intellij/debugger/engine/DebugProcessImpl$ResumeCommand;", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "ignoreBreakpoints", "", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "createStepOverCommandForSuspendSwitch", "Lcom/intellij/debugger/engine/DebugProcessImpl$StepOverCommand;", "nextLocationAfterResume", "Lcom/sun/jdi/Location;", "createStepOutCommand", "createStepIntoCommand", "methodFilter", "Lcom/intellij/debugger/engine/MethodFilter;", "createRunToCursorCommand", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "intellij.kotlin.jvm.debugger.core"})
public final class DebuggerSteppingHelper {
    @NotNull
    public static final DebuggerSteppingHelper INSTANCE = new DebuggerSteppingHelper();
    @NotNull
    private static final Logger LOG;

    private DebuggerSteppingHelper() {
    }

    @NotNull
    public final DebugProcessImpl.ResumeCommand createStepOverCommand(@NotNull SuspendContextImpl suspendContext, boolean ignoreBreakpoints, @Nullable SourcePosition sourcePosition) {
        DebugProcessImpl debugProcess;
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        DebugProcessImpl $this$createStepOverCommand_u24lambda_u240 = debugProcess = suspendContext.getDebugProcess();
        boolean bl = false;
        return new DebugProcessImpl.ResumeCommand($this$createStepOverCommand_u24lambda_u240, suspendContext, debugProcess, ignoreBreakpoints){
            final /* synthetic */ DebugProcessImpl $debugProcess;
            final /* synthetic */ boolean $ignoreBreakpoints;
            {
                this.$debugProcess = $debugProcess;
                this.$ignoreBreakpoints = $ignoreBreakpoints;
                super($receiver, $suspendContext);
            }

            public void contextAction(SuspendContextImpl suspendContext) {
                Location location;
                StackFrameProxyImpl frameProxy;
                Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                StackFrameProxyImpl stackFrameProxyImpl = frameProxy = suspendContext.getFrameProxy();
                Location location2 = location = stackFrameProxyImpl != null ? SafeUtilKt.safeLocation((StackFrameProxy)stackFrameProxyImpl) : null;
                if (location != null) {
                    try {
                        KotlinSteppingCommandProviderKt.getStepOverAction(location, suspendContext, frameProxy).createCommand(this.$debugProcess, suspendContext, this.$ignoreBreakpoints).contextAction(suspendContext);
                        return;
                    }
                    catch (Exception e) {
                        DebuggerSteppingHelper.access$getLOG$p().error((Throwable)e);
                    }
                }
                this.$debugProcess.createStepOverCommand(suspendContext, this.$ignoreBreakpoints).contextAction(suspendContext);
            }
        };
    }

    @NotNull
    public final DebugProcessImpl.StepOverCommand createStepOverCommandForSuspendSwitch(@NotNull SuspendContextImpl suspendContext, @Nullable Location nextLocationAfterResume) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        DebugProcessImpl $this$createStepOverCommandForSuspendSwitch_u24lambda_u240 = suspendContext.getDebugProcess();
        boolean bl = false;
        return new DebugProcessImpl.StepOverCommand($this$createStepOverCommandForSuspendSwitch_u24lambda_u240, suspendContext, nextLocationAfterResume){
            final /* synthetic */ Location $nextLocationAfterResume;
            {
                this.$nextLocationAfterResume = $nextLocationAfterResume;
                super($receiver, $suspendContext, false, null, -1);
            }

            public RequestHint getHint(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl stepThread, RequestHint parentHint) {
                Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                Intrinsics.checkNotNullParameter((Object)stepThread, (String)"stepThread");
                MethodFilter methodFilter = this.myMethodFilter;
                RequestHint hint2 = new RequestHint(stepThread, suspendContext, parentHint, this.$nextLocationAfterResume, methodFilter){
                    final /* synthetic */ Location $nextLocationAfterResume;
                    {
                        this.$nextLocationAfterResume = $nextLocationAfterResume;
                        super($stepThread, $suspendContext, -1, 2, $super_call_param$1, $parentHint);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public int getNextStepDepth(SuspendContextImpl context2) {
                        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                        StackFrameProxyImpl stackFrameProxyImpl = context2.getFrameProxy();
                        boolean bl = stackFrameProxyImpl != null ? DebuggerUtil.isOnSuspensionPoint(stackFrameProxyImpl) : false;
                        if (bl && this.$nextLocationAfterResume != null) {
                            void $this$debug_u24default$iv;
                            createStepOverCommandForSuspendSwitch.1.getHint.hint.1 $this$thisLogger$iv;
                            void var9_13;
                            void $this$debug_u24default$iv2;
                            LightOrRealThreadInfo filterThread = context2.getDebugProcess().getRequestsManager().getFilterThread();
                            createStepOverCommandForSuspendSwitch.1.getHint.hint.1 $this$thisLogger$iv2 = this;
                            boolean $i$f$thisLogger = false;
                            Logger logger = Logger.getInstance(createStepOverCommandForSuspendSwitch.1.getHint.hint.1.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                            $this$thisLogger$iv2 = logger;
                            Location location = this.$nextLocationAfterResume;
                            Throwable e$iv = null;
                            boolean $i$f$debug2 = false;
                            if ($this$debug_u24default$iv2.isDebugEnabled()) {
                                var9_13 = $this$debug_u24default$iv2;
                                boolean bl2 = false;
                                Location location2 = context2.getLocation();
                                var9_13.debug("Stepping to the resumeLocation in method " + context2.getLocation() + ",filterThread = " + filterThread + ",resumeLocationCodeIndex = " + location.codeIndex() + ",currentIndex = " + (location2 != null ? Long.valueOf(location2.codeIndex()) : null), e$iv);
                            }
                            Location location3 = context2.getLocation();
                            if (location3 == null) {
                                return super.getNextStepDepth(context2);
                            }
                            Location currentLocation = location3;
                            if (!Intrinsics.areEqual((Object)SafeUtilKt.safeMethod(this.$nextLocationAfterResume), (Object)SafeUtilKt.safeMethod(currentLocation))) {
                                $this$thisLogger$iv = this;
                                boolean $i$f$thisLogger2 = false;
                                Logger logger2 = Logger.getInstance(createStepOverCommandForSuspendSwitch.1.getHint.hint.1.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                                $this$thisLogger$iv = logger2;
                                Location $i$f$debug2 = this.$nextLocationAfterResume;
                                Throwable e$iv2 = null;
                                boolean $i$f$debug3 = false;
                                if ($this$debug_u24default$iv.isDebugEnabled()) {
                                    var9_13 = $this$debug_u24default$iv;
                                    boolean bl3 = false;
                                    var9_13.debug("Expected to step in the resumed method " + SafeUtilKt.safeMethod($i$f$debug2) + ", but currently stepping in " + SafeUtilKt.safeMethod(currentLocation), e$iv2);
                                }
                                return 2;
                            }
                            if (currentLocation.codeIndex() < this.$nextLocationAfterResume.codeIndex()) {
                                return 2;
                            }
                            if (currentLocation.codeIndex() == this.$nextLocationAfterResume.codeIndex()) {
                                $this$thisLogger$iv = this;
                                boolean $i$f$thisLogger3 = false;
                                Logger logger3 = Logger.getInstance(createStepOverCommandForSuspendSwitch.1.getHint.hint.1.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
                                $this$thisLogger$iv = logger3;
                                Throwable e$iv3 = null;
                                $i$f$debug2 = false;
                                if ($this$debug_u24default$iv.isDebugEnabled()) {
                                    var9_13 = $this$debug_u24default$iv;
                                    boolean bl4 = false;
                                    var9_13.debug("Reached resumeLocation, currentIndex = " + currentLocation.codeIndex() + ", filterThread = " + filterThread + " -> STOP", e$iv3);
                                }
                                return 0;
                            }
                        }
                        return super.getNextStepDepth(context2);
                    }
                };
                hint2.setIgnoreFilters(suspendContext.getDebugProcess().getSession().shouldIgnoreSteppingFilters());
                return hint2;
            }

            protected Engine getEngine() {
                return Engine.KOTLIN;
            }
        };
    }

    @NotNull
    public final DebugProcessImpl.ResumeCommand createStepOutCommand(@NotNull SuspendContextImpl suspendContext, boolean ignoreBreakpoints) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        DebugProcessImpl $this$createStepOutCommand_u24lambda_u240 = suspendContext.getDebugProcess();
        boolean bl = false;
        return new DebugProcessImpl.ResumeCommand($this$createStepOutCommand_u24lambda_u240, suspendContext, ignoreBreakpoints){
            final /* synthetic */ boolean $ignoreBreakpoints;
            {
                this.$ignoreBreakpoints = $ignoreBreakpoints;
                super($receiver, $suspendContext);
            }

            public void contextAction(SuspendContextImpl suspendContext) {
                Location location;
                StackFrameProxyImpl frameProxy;
                Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                StackFrameProxyImpl stackFrameProxyImpl = frameProxy = suspendContext.getFrameProxy();
                Location location2 = location = stackFrameProxyImpl != null ? SafeUtilKt.safeLocation((StackFrameProxy)stackFrameProxyImpl) : null;
                if (location != null) {
                    try {
                        KotlinSteppingCommandProviderKt.getStepOutAction(location, frameProxy).createCommand(suspendContext.getDebugProcess(), suspendContext, this.$ignoreBreakpoints).contextAction(suspendContext);
                        return;
                    }
                    catch (Exception e) {
                        DebuggerSteppingHelper.access$getLOG$p().error((Throwable)e);
                    }
                }
                suspendContext.getDebugProcess().createStepOutCommand(suspendContext).contextAction(suspendContext);
            }
        };
    }

    @NotNull
    public final DebugProcessImpl.ResumeCommand createStepIntoCommand(@NotNull SuspendContextImpl suspendContext, boolean ignoreBreakpoints, @Nullable MethodFilter methodFilter) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        DebugProcessImpl $this$createStepIntoCommand_u24lambda_u240 = suspendContext.getDebugProcess();
        boolean bl = false;
        return new DebugProcessImpl.ResumeCommand($this$createStepIntoCommand_u24lambda_u240, suspendContext, methodFilter, ignoreBreakpoints){
            final /* synthetic */ MethodFilter $methodFilter;
            final /* synthetic */ boolean $ignoreBreakpoints;
            {
                this.$methodFilter = $methodFilter;
                this.$ignoreBreakpoints = $ignoreBreakpoints;
                super($receiver, $suspendContext);
            }

            public void contextAction(SuspendContextImpl suspendContext) {
                Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                try {
                    new KotlinStepAction.KotlinStepInto(this.$methodFilter).createCommand(suspendContext.getDebugProcess(), suspendContext, this.$ignoreBreakpoints).contextAction(suspendContext);
                }
                catch (Exception e) {
                    suspendContext.getDebugProcess().createStepIntoCommand(suspendContext, this.$ignoreBreakpoints, this.$methodFilter).contextAction(suspendContext);
                }
            }
        };
    }

    @NotNull
    public final DebugProcessImpl.ResumeCommand createRunToCursorCommand(@NotNull SuspendContextImpl suspendContext, @NotNull XSourcePosition position, boolean ignoreBreakpoints) {
        DebugProcessImpl debugProcess;
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        DebugProcessImpl $this$createRunToCursorCommand_u24lambda_u240 = debugProcess = suspendContext.getDebugProcess();
        boolean bl = false;
        return (DebugProcessImpl.ResumeCommand)new DebugProcessImpl.RunToCursorCommand($this$createRunToCursorCommand_u24lambda_u240, suspendContext, position, ignoreBreakpoints){
            private final Lazy<LightOrRealThreadInfo> myThreadFilter;
            {
                this.myThreadFilter = LazyKt.lazy(() -> createRunToCursorCommand.1.1.myThreadFilter$lambda$0($suspendContext, this));
            }

            public final Lazy<LightOrRealThreadInfo> getMyThreadFilter() {
                return this.myThreadFilter;
            }

            protected boolean shouldExecuteRegardlessOfRequestWarnings() {
                return true;
            }

            public void contextAction(SuspendContextImpl context2) {
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                if (!(this.myThreadFilter.getValue() instanceof RealThreadInfo)) {
                    context2.getDebugProcess().getSession().clearSteppingThrough();
                }
                super.contextAction(context2);
            }

            public LightOrRealThreadInfo getThreadFilterFromContext(SuspendContextImpl suspendContext) {
                Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                return (LightOrRealThreadInfo)this.myThreadFilter.getValue();
            }

            private static final LightOrRealThreadInfo myThreadFilter$lambda$0(SuspendContextImpl $suspendContext, createRunToCursorCommand.1.1 this$0) {
                LightOrRealThreadInfo lightOrRealThreadInfo = CoroutineJobInfo.Companion.extractJobInfo($suspendContext);
                if (lightOrRealThreadInfo == null) {
                    lightOrRealThreadInfo = super.getThreadFilterFromContext($suspendContext);
                }
                return lightOrRealThreadInfo;
            }
        };
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance(DebuggerSteppingHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

