/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.k1.configuration;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.core.script.k1.ScriptDefinitionsManager;
import org.jetbrains.kotlin.idea.core.script.k1.configuration.KotlinScriptDefinitionsModel;
import org.jetbrains.kotlin.idea.core.script.k1.configuration.ModelDescriptor;
import org.jetbrains.kotlin.idea.core.script.k1.settings.KotlinScriptingSettingsImpl;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionProvider;

public class KotlinScriptingSettingsConfigurable
implements SearchableConfigurable {
    private JPanel root;
    private JPanel panelScriptDefinitionsChooser;
    private JPanel additionalSettingsPanel;
    private final KotlinScriptDefinitionsModel model;
    private final ScriptDefinitionsManager manager;
    private final KotlinScriptingSettingsImpl settings;

    public KotlinScriptingSettingsConfigurable(Project project) {
        this.$$$setupUI$$$();
        this.manager = ScriptDefinitionsManager.Companion.getInstance(project);
        this.settings = KotlinScriptingSettingsImpl.Companion.getInstance(project);
        this.model = KotlinScriptDefinitionsModel.Companion.createModel(StreamsKt.asStream(ScriptDefinitionProvider.Companion.getInstance(project).getCurrentDefinitions()).toList(), this.settings);
    }

    @Nullable
    public JComponent createComponent() {
        this.panelScriptDefinitionsChooser.setLayout((LayoutManager)new VerticalLayout(0));
        this.panelScriptDefinitionsChooser.add((Component)new TitledSeparator(KotlinBundle.message((String)"kotlin.script.definitions.title", (Object[])new Object[0])));
        JLabel commentLabel = new JLabel(KotlinBundle.message((String)"kotlin.script.definitions.model.name.autoReloadScriptDependencies.description", (Object[])new Object[0]));
        commentLabel.setForeground(UIUtil.getContextHelpForeground());
        this.panelScriptDefinitionsChooser.add(commentLabel);
        TableView table = new TableView((ListTableModel)this.model);
        this.panelScriptDefinitionsChooser.add(ToolbarDecorator.createDecorator((JTable)table).disableAddAction().disableRemoveAction().createPanel());
        table.setVisibleRowCount(12);
        this.additionalSettingsPanel.setLayout((LayoutManager)new VerticalLayout(0));
        return this.root;
    }

    public boolean isModified() {
        return this.isScriptDefinitionsChanged();
    }

    public void apply() throws ConfigurationException {
        if (this.isScriptDefinitionsChanged()) {
            for (ModelDescriptor item : this.model.getItems()) {
                ScriptDefinition definition = item.getDefinition();
                int order = this.model.getItems().indexOf(item);
                this.settings.setOrder(definition, order);
                this.settings.setEnabled(definition, item.isEnabled());
                this.settings.setAutoReloadConfigurations(definition, item.getAutoReloadConfigurations());
            }
            this.manager.reorderDefinitions();
        }
    }

    public void reset() {
        this.model.setDefinitions(StreamsKt.asStream(this.manager.getCurrentDefinitions()).toList(), this.settings);
    }

    private boolean isScriptDefinitionsChanged() {
        for (ModelDescriptor item : this.model.getItems()) {
            if (this.settings.isScriptDefinitionEnabled(item.getDefinition()) != item.isEnabled()) {
                return true;
            }
            if (this.settings.autoReloadConfigurations(item.getDefinition()) == item.getAutoReloadConfigurations()) continue;
            return true;
        }
        return !this.model.getDefinitions().equals(StreamsKt.asStream(this.manager.getCurrentDefinitions()).toList());
    }

    @Nls
    public String getDisplayName() {
        return KotlinBundle.message((String)"script.name.kotlin.scripting", (Object[])new Object[0]);
    }

    @NotNull
    public String getId() {
        return "preferences.language.Kotlin.scripting";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.root = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.panelScriptDefinitionsChooser = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.additionalSettingsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.root;
    }
}

