/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.handlers;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.completion.api.serialization.SerializableInsertHandler;
import org.jetbrains.kotlin.idea.completion.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.idea.completion.handlers.KeywordConstructorInsertionHandler$;
import org.jetbrains.kotlin.idea.core.GenerateUtilsKt;
import org.jetbrains.kotlin.idea.formatter.DocumentUtilsKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Serializable
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 -2\u00020\u0001:\u0002,-B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tBA\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\b\u0010\u000eJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010 \u001a\u00020\u00052\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020\u000bH\u00d6\u0001J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001J%\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0001\u00a2\u0006\u0002\b+R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/idea/completion/handlers/KeywordConstructorInsertionHandler;", "Lorg/jetbrains/kotlin/idea/completion/api/serialization/SerializableInsertHandler;", "keyword", "", "adjustLineIndent", "", "tailBeforeCaret", "tailAfterCaret", "<init>", "(Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;ZLjava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getKeyword", "()Ljava/lang/String;", "getAdjustLineIndent", "()Z", "getTailBeforeCaret", "getTailAfterCaret", "handleInsert", "", "insertionContext", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "toString", "write$Self", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$kotlin_completion_impl_shared", "$serializer", "Companion", "kotlin.completion.impl.shared"})
@ApiStatus.Internal
public final class KeywordConstructorInsertionHandler
implements SerializableInsertHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String keyword;
    private final boolean adjustLineIndent;
    @NotNull
    private final String tailBeforeCaret;
    @NotNull
    private final String tailAfterCaret;

    public KeywordConstructorInsertionHandler(@NotNull String keyword, boolean adjustLineIndent, @NotNull String tailBeforeCaret, @NotNull String tailAfterCaret) {
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        Intrinsics.checkNotNullParameter((Object)tailBeforeCaret, (String)"tailBeforeCaret");
        Intrinsics.checkNotNullParameter((Object)tailAfterCaret, (String)"tailAfterCaret");
        this.keyword = keyword;
        this.adjustLineIndent = adjustLineIndent;
        this.tailBeforeCaret = tailBeforeCaret;
        this.tailAfterCaret = tailAfterCaret;
    }

    @NotNull
    public final String getKeyword() {
        return this.keyword;
    }

    public final boolean getAdjustLineIndent() {
        return this.adjustLineIndent;
    }

    @NotNull
    public final String getTailBeforeCaret() {
        return this.tailBeforeCaret;
    }

    @NotNull
    public final String getTailAfterCaret() {
        return this.tailAfterCaret;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handleInsert(@NotNull InsertionContext insertionContext, @NotNull LookupElement item) {
        PsiElement sibling;
        int offset;
        int n;
        Intrinsics.checkNotNullParameter((Object)insertionContext, (String)"insertionContext");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (insertionContext.getCompletionChar() != '\n' && insertionContext.getCompletionChar() != '\t') {
            if (insertionContext.getCompletionChar() != '\u0000') return;
        }
        if (!this.adjustLineIndent) {
            n = insertionContext.getTailOffset() - this.keyword.length();
        } else {
            offset = insertionContext.getTailOffset() - this.keyword.length();
            Document document = insertionContext.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Project project = insertionContext.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            DocumentUtilsKt.adjustLineIndent(document, project, offset);
            n = insertionContext.getTailOffset() - this.keyword.length();
        }
        int keywordStartOffset = n;
        offset = keywordStartOffset + this.keyword.length();
        CharSequence charSequence = insertionContext.getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        String newIndent = HandlerUtilsKt.access$detectIndent(charSequence, keywordStartOffset);
        String beforeCaret = HandlerUtilsKt.access$indentLinesAfterFirst(this.tailBeforeCaret, newIndent);
        String afterCaret = HandlerUtilsKt.access$indentLinesAfterFirst(this.tailAfterCaret, newIndent);
        PsiElement element = insertionContext.getFile().findElementAt(offset);
        Object object = !(element instanceof PsiWhiteSpace) ? element : (sibling = ((PsiWhiteSpace)element).textContains('\n') ? null : PsiUtilsKt.getNextSiblingIgnoringWhitespace((PsiElement)element, (boolean)true));
        if (sibling != null) {
            String string2 = ((Object)StringsKt.trimStart((CharSequence)beforeCaret)).toString();
            string2 = insertionContext.getDocument().getText(TextRange.from((int)PsiUtilsKt.getStartOffset((PsiElement)sibling), (int)1));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            if (StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) {
                Editor editor = insertionContext.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                GenerateUtilsKt.moveCaret$default(editor, PsiUtilsKt.getStartOffset((PsiElement)sibling) + 1, null, 2, null);
                return;
            }
        }
        insertionContext.getDocument().insertString(offset, (CharSequence)(beforeCaret + afterCaret));
        Editor editor = insertionContext.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        GenerateUtilsKt.moveCaret$default(editor, offset + beforeCaret.length(), null, 2, null);
    }

    @NotNull
    public final String component1() {
        return this.keyword;
    }

    public final boolean component2() {
        return this.adjustLineIndent;
    }

    @NotNull
    public final String component3() {
        return this.tailBeforeCaret;
    }

    @NotNull
    public final String component4() {
        return this.tailAfterCaret;
    }

    @NotNull
    public final KeywordConstructorInsertionHandler copy(@NotNull String keyword, boolean adjustLineIndent, @NotNull String tailBeforeCaret, @NotNull String tailAfterCaret) {
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        Intrinsics.checkNotNullParameter((Object)tailBeforeCaret, (String)"tailBeforeCaret");
        Intrinsics.checkNotNullParameter((Object)tailAfterCaret, (String)"tailAfterCaret");
        return new KeywordConstructorInsertionHandler(keyword, adjustLineIndent, tailBeforeCaret, tailAfterCaret);
    }

    public static /* synthetic */ KeywordConstructorInsertionHandler copy$default(KeywordConstructorInsertionHandler keywordConstructorInsertionHandler, String string, boolean bl, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = keywordConstructorInsertionHandler.keyword;
        }
        if ((n & 2) != 0) {
            bl = keywordConstructorInsertionHandler.adjustLineIndent;
        }
        if ((n & 4) != 0) {
            string2 = keywordConstructorInsertionHandler.tailBeforeCaret;
        }
        if ((n & 8) != 0) {
            string3 = keywordConstructorInsertionHandler.tailAfterCaret;
        }
        return keywordConstructorInsertionHandler.copy(string, bl, string2, string3);
    }

    @NotNull
    public String toString() {
        return "KeywordConstructorInsertionHandler(keyword=" + this.keyword + ", adjustLineIndent=" + this.adjustLineIndent + ", tailBeforeCaret=" + this.tailBeforeCaret + ", tailAfterCaret=" + this.tailAfterCaret + ")";
    }

    public int hashCode() {
        int result2 = this.keyword.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.adjustLineIndent);
        result2 = result2 * 31 + this.tailBeforeCaret.hashCode();
        result2 = result2 * 31 + this.tailAfterCaret.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KeywordConstructorInsertionHandler)) {
            return false;
        }
        KeywordConstructorInsertionHandler keywordConstructorInsertionHandler = (KeywordConstructorInsertionHandler)other;
        if (!Intrinsics.areEqual((Object)this.keyword, (Object)keywordConstructorInsertionHandler.keyword)) {
            return false;
        }
        if (this.adjustLineIndent != keywordConstructorInsertionHandler.adjustLineIndent) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tailBeforeCaret, (Object)keywordConstructorInsertionHandler.tailBeforeCaret)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.tailAfterCaret, (Object)keywordConstructorInsertionHandler.tailAfterCaret);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$kotlin_completion_impl_shared(KeywordConstructorInsertionHandler self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeStringElement(serialDesc, 0, self.keyword);
        output.encodeBooleanElement(serialDesc, 1, self.adjustLineIndent);
        output.encodeStringElement(serialDesc, 2, self.tailBeforeCaret);
        output.encodeStringElement(serialDesc, 3, self.tailAfterCaret);
    }

    public /* synthetic */ KeywordConstructorInsertionHandler(int seen0, String keyword, boolean adjustLineIndent, String tailBeforeCaret, String tailAfterCaret, SerializationConstructorMarker serializationConstructorMarker) {
        if (15 != (0xF & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)15, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.keyword = keyword;
        this.adjustLineIndent = adjustLineIndent;
        this.tailBeforeCaret = tailBeforeCaret;
        this.tailAfterCaret = tailAfterCaret;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/completion/handlers/KeywordConstructorInsertionHandler$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/jetbrains/kotlin/idea/completion/handlers/KeywordConstructorInsertionHandler;", "kotlin.completion.impl.shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<KeywordConstructorInsertionHandler> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

