/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsight.utils;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaClassType;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.analysis.api.types.KaTypeNullability;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001a\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001*\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\t\u001a\u0004\u0018\u00010\b*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\n"}, d2={"extractPrimaryParameters", "", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaValueParameterSymbol;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "extractDataClassParameters", "type", "Lorg/jetbrains/kotlin/analysis/api/types/KaClassType;", "getClassType", "intellij.kotlin.codeInsight.utils"})
@JvmName(name="DestructuringUtils")
@SourceDebugExtension(value={"SMAP\nDestructuringUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DestructuringUtils.kt\norg/jetbrains/kotlin/idea/codeinsight/utils/DestructuringUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,41:1\n1#2:42\n*E\n"})
public final class DestructuringUtils {
    @Nullable
    public static final List<KaValueParameterSymbol> extractPrimaryParameters(@NotNull KaSession $this$extractPrimaryParameters, @NotNull KtDestructuringDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)$this$extractPrimaryParameters, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        KaClassType kaClassType = DestructuringUtils.getClassType($this$extractPrimaryParameters, declaration);
        if (kaClassType == null) {
            return null;
        }
        KaClassType type2 = kaClassType;
        return DestructuringUtils.extractDataClassParameters($this$extractPrimaryParameters, type2);
    }

    @Nullable
    public static final List<KaValueParameterSymbol> extractDataClassParameters(@NotNull KaSession $this$extractDataClassParameters, @NotNull KaClassType type2) {
        List<KaValueParameterSymbol> list2;
        Intrinsics.checkNotNullParameter((Object)$this$extractDataClassParameters, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (type2.getNullability() != KaTypeNullability.NON_NULLABLE) {
            return null;
        }
        KaClassSymbol classSymbol = $this$extractDataClassParameters.getExpandedSymbol(type2);
        if (classSymbol instanceof KaNamedClassSymbol && ((KaNamedClassSymbol)classSymbol).isData()) {
            Object v0;
            block5: {
                Sequence<KaConstructorSymbol> sequence = $this$extractDataClassParameters.getDeclaredMemberScope(classSymbol).getConstructors();
                for (Object e : sequence) {
                    KaConstructorSymbol it = (KaConstructorSymbol)e;
                    boolean bl = false;
                    if (!it.isPrimary()) continue;
                    v0 = e;
                    break block5;
                }
                v0 = null;
            }
            KaConstructorSymbol kaConstructorSymbol = v0;
            if (kaConstructorSymbol == null) {
                return null;
            }
            KaConstructorSymbol constructorSymbol = kaConstructorSymbol;
            list2 = constructorSymbol.getValueParameters();
        } else {
            list2 = null;
        }
        return list2;
    }

    private static final KaClassType getClassType(KaSession $this$getClassType, KtDestructuringDeclaration declaration) {
        Object type2;
        KaType kaType;
        Object object = declaration.getInitializer();
        if (object == null || (object = $this$getClassType.getExpressionType((KtExpression)object)) == null) {
            PsiElement psiElement = declaration.getParent();
            Object object2 = psiElement instanceof KtParameter ? (KtParameter)psiElement : null;
            if (object2 != null && (object2 = $this$getClassType.getSymbol((KtParameter)object2)) != null) {
                object = ((KaCallableSymbol)object2).getReturnType();
            } else {
                return null;
            }
        }
        return (kaType = $this$getClassType.lowerBoundIfFlexible((KaType)(type2 = object))) instanceof KaClassType ? (KaClassType)kaType : null;
    }
}

