/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.intentions.shared;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.intentions.shared.SwapBinaryExpressionIntention;
import org.jetbrains.kotlin.idea.codeInsight.intentions.shared.SwapBinaryExpressionIntentionKt;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.intentions.KotlinApplicableModCommandAction;
import org.jetbrains.kotlin.idea.util.PsiPrecedences;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0002H\u0014J-\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000b\u001a\u00020\u0002H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000b\u001a\u00020\u0002H\u0002J7\u0010\u001a\u001a\u0004\u0018\u00010\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0019\u0010\u001e\u001a\u0015\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u001f\u00a2\u0006\u0002\b H\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/SwapBinaryExpressionIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/intentions/KotlinApplicableModCommandAction$Simple;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "<init>", "()V", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "getApplicableRanges", "", "Lcom/intellij/openapi/util/TextRange;", "element", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "invoke", "", "actionContext", "elementContext", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "(Lcom/intellij/modcommand/ActionContext;Lorg/jetbrains/kotlin/psi/KtBinaryExpression;Lkotlin/Unit;Lcom/intellij/modcommand/ModPsiUpdater;)V", "leftSubject", "Lorg/jetbrains/kotlin/psi/KtExpression;", "rightSubject", "firstDescendantOfTighterPrecedence", "expression", "precedence", "", "getChild", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "kotlin.code-insight.intentions.shared"})
@SourceDebugExtension(value={"SMAP\nSwapBinaryExpressionIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwapBinaryExpressionIntention.kt\norg/jetbrains/kotlin/idea/codeInsight/intentions/shared/SwapBinaryExpressionIntention\n+ 2 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n*L\n1#1,95:1\n25#2:96\n25#2:97\n*S KotlinDebug\n*F\n+ 1 SwapBinaryExpressionIntention.kt\norg/jetbrains/kotlin/idea/codeInsight/intentions/shared/SwapBinaryExpressionIntention\n*L\n58#1:96\n59#1:97\n*E\n"})
public final class SwapBinaryExpressionIntention
extends KotlinApplicableModCommandAction.Simple<KtBinaryExpression> {
    public SwapBinaryExpressionIntention() {
        super(Reflection.getOrCreateKotlinClass(KtBinaryExpression.class));
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"flip.binary.expression", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public List<TextRange> getApplicableRanges(@NotNull KtBinaryExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return CollectionsKt.listOf((Object)element.getOperationReference().getTextRangeInParent());
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context2, @NotNull KtBinaryExpression element) {
        Presentation presentation;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (this.leftSubject(element) == null || this.rightSubject(element) == null) {
            return null;
        }
        IElementType iElementType = element.getOperationToken();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOperationToken(...)");
        IElementType operationToken = iElementType;
        String operationTokenText = element.getOperationReference().getText();
        if (CollectionsKt.contains((Iterable)SwapBinaryExpressionIntentionKt.access$getSUPPORTED_OPERATIONS(), (Object)operationToken) || Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.IDENTIFIER) && SwapBinaryExpressionIntentionKt.access$getSUPPORTED_OPERATION_NAMES().contains(operationTokenText)) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNull((Object)operationTokenText);
            objectArray[0] = operationTokenText;
            presentation = Presentation.of((String)KotlinBundle.message((String)"flip.0", (Object[])objectArray)).withPriority(PriorityAction.Priority.LOW);
        } else {
            presentation = null;
        }
        return presentation;
    }

    @Override
    public void invoke(@NotNull ActionContext actionContext, @NotNull KtBinaryExpression element, @NotNull Unit elementContext, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)elementContext, (String)"elementContext");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        String string = element.getOperationReference().getText();
        Intrinsics.checkNotNull((Object)string);
        String convertedOperator = switch (string) {
            case ">" -> "<";
            case "<" -> ">";
            case "<=" -> ">=";
            case ">=" -> "<=";
            default -> {
                String operator;
                yield operator;
            }
        };
        KtExpression ktExpression = this.leftSubject(element);
        if (ktExpression == null) {
            return;
        }
        KtExpression left = ktExpression;
        KtExpression ktExpression2 = this.rightSubject(element);
        if (ktExpression2 == null) {
            return;
        }
        KtExpression right = ktExpression2;
        PsiElement $this$copied$iv = (PsiElement)right;
        boolean $i$f$copied = false;
        PsiElement psiElement = $this$copied$iv.copy();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        }
        KtExpression rightCopy = (KtExpression)((PsiElement)((KtExpression)psiElement));
        PsiElement $this$copied$iv2 = (PsiElement)left;
        boolean $i$f$copied2 = false;
        PsiElement psiElement2 = $this$copied$iv2.copy();
        if (psiElement2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        }
        KtExpression leftCopy = (KtExpression)((PsiElement)((KtExpression)psiElement2));
        left.replace((PsiElement)rightCopy);
        right.replace((PsiElement)leftCopy);
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
        String string2 = "$0 " + convertedOperator + " $1";
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNull((Object)element.getLeft());
        Intrinsics.checkNotNull((Object)element.getRight());
        element.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)ktPsiFactory, (String)string2, (Object[])objectArray, (boolean)false, (int)4, null));
    }

    private final KtExpression leftSubject(KtBinaryExpression element) {
        return this.firstDescendantOfTighterPrecedence(element.getLeft(), PsiPrecedences.INSTANCE.getPrecedence((KtExpression)element), (Function1<? super KtBinaryExpression, ? extends KtExpression>)((Function1)leftSubject.1.INSTANCE));
    }

    private final KtExpression rightSubject(KtBinaryExpression element) {
        return this.firstDescendantOfTighterPrecedence(element.getRight(), PsiPrecedences.INSTANCE.getPrecedence((KtExpression)element), (Function1<? super KtBinaryExpression, ? extends KtExpression>)((Function1)rightSubject.1.INSTANCE));
    }

    private final KtExpression firstDescendantOfTighterPrecedence(KtExpression expression, int precedence, Function1<? super KtBinaryExpression, ? extends KtExpression> getChild) {
        int expressionPrecedence;
        if (expression instanceof KtBinaryExpression && !PsiPrecedences.INSTANCE.isTighter(expressionPrecedence = PsiPrecedences.INSTANCE.getPrecedence(expression), precedence)) {
            return this.firstDescendantOfTighterPrecedence((KtExpression)getChild.invoke((Object)expression), precedence, getChild);
        }
        return expression;
    }
}

