/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure.scope;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.scopes.LibraryScopeBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.projectStructure.scope.CombinableSourceAndClassRootsScope;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u0014J\u0013\u0010\u001b\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/scope/LibrarySourcesScope;", "Lcom/intellij/openapi/module/impl/scopes/LibraryScopeBase;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/scope/CombinableSourceAndClassRootsScope;", "project", "Lcom/intellij/openapi/project/Project;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/roots/libraries/Library;)V", "getFileRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "roots", "Lit/unimi/dsi/fastutil/objects/Object2IntMap;", "getRoots", "()Lit/unimi/dsi/fastutil/objects/Object2IntMap;", "modules", "", "Lcom/intellij/openapi/module/Module;", "getModules", "()Ljava/util/Set;", "includesLibraryClassRoots", "", "getIncludesLibraryClassRoots", "()Z", "includesLibrarySourceRoots", "getIncludesLibrarySourceRoots", "equals", "other", "", "calcHashCode", "", "toString", "", "intellij.kotlin.base.projectStructure"})
public final class LibrarySourcesScope
extends LibraryScopeBase
implements CombinableSourceAndClassRootsScope {
    @NotNull
    private final Library library;

    public LibrarySourcesScope(@NotNull Project project, @NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        super(project, VirtualFile.EMPTY_ARRAY, library.getFiles(OrderRootType.SOURCES));
        this.library = library;
    }

    @Nullable
    protected VirtualFile getFileRoot(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.myIndex.getSourceRootForFile(file);
    }

    @Override
    @NotNull
    public Object2IntMap<VirtualFile> getRoots() {
        Object2IntMap object2IntMap = this.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)object2IntMap, (String)"getEntries(...)");
        return object2IntMap;
    }

    @Override
    @NotNull
    public Set<Module> getModules() {
        return SetsKt.emptySet();
    }

    @Override
    public boolean getIncludesLibraryClassRoots() {
        return false;
    }

    @Override
    public boolean getIncludesLibrarySourceRoots() {
        return true;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LibrarySourcesScope)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.library, (Object)((LibrarySourcesScope)other).library);
    }

    public int calcHashCode() {
        return 31 * super.calcHashCode() + this.library.hashCode();
    }

    @NotNull
    public String toString() {
        return "LibrarySourcesScope(" + this.library + ")";
    }
}

