/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.fir.analysisApiPlatform.statistics;

import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.ehcache.sizeof.SizeOf;
import org.ehcache.sizeof.filters.SizeOfFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.platform.statistics.KotlinObjectSizeCalculator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016R7\u0010\u0004\u001a+\u0012\u0012\u0012\u0010\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b\u0012\u000e\u0012\f0\t\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/base/fir/analysisApiPlatform/statistics/K2IdeKotlinObjectSizeCalculator;", "Lorg/jetbrains/kotlin/analysis/api/platform/statistics/KotlinObjectSizeCalculator;", "<init>", "()V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "Lkotlin/reflect/KClass;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "shallowSize", "value", "", "intellij.kotlin.analysis.platform"})
public final class K2IdeKotlinObjectSizeCalculator
implements KotlinObjectSizeCalculator {
    @NotNull
    private final ConcurrentMap<KClass<?>, Long> cache;

    public K2IdeKotlinObjectSizeCalculator() {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakMap(...)");
        this.cache = concurrentMap;
    }

    @Override
    public long shallowSize(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Long l = this.cache.computeIfAbsent(Reflection.getOrCreateKotlinClass(value.getClass()), arg_0 -> K2IdeKotlinObjectSizeCalculator.shallowSize$lambda$1(arg_0 -> K2IdeKotlinObjectSizeCalculator.shallowSize$lambda$0(value, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"computeIfAbsent(...)");
        return ((Number)l).longValue();
    }

    private static final Long shallowSize$lambda$0(Object $value, KClass kClass) {
        Intrinsics.checkNotNull((Object)kClass);
        Class javaClass = JvmClassMappingKt.getJavaClass((KClass)kClass);
        if (javaClass.isArray() || javaClass.isPrimitive()) {
            throw new IllegalStateException(("Shallow size should not be naively calculated for arrays or primitives: '" + $value + "'.").toString());
        }
        return SizeOf.newInstance((SizeOfFilter[])new SizeOfFilter[0]).sizeOf($value);
    }

    private static final Long shallowSize$lambda$1(Function1 $tmp0, Object p0) {
        return (Long)$tmp0.invoke(p0);
    }
}

