/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.fir.FirEnumWhenTrackerComponent;
import org.jetbrains.kotlin.fir.FirEnumWhenTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.ExhaustivenessStatus;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirElseIfTrueCondition;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenOnBooleanExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenOnEnumExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenOnNothingExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenOnNullableExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenOnSealedClassExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenSelfTypeExhaustivenessChecker;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeRigidType;
import org.jetbrains.kotlin.fir.types.ConeTypeContext;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012*\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J8\u0010\u0015\u001a\u00020\u0016*\b\u0012\u0004\u0012\u00020\b0\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0018\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\f\u0010\u001e\u001a\u00020\u001f*\u00020\fH\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\"\u0010 \u001a\u0004\u0018\u00010\u001a2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\"\u00b2\u0006\n\u0010#\u001a\u00020\u001aX\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessComputer;", "", "<init>", "()V", "exhaustivenessCheckers", "", "Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenExhaustivenessChecker;", "computeAllMissingCases", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "whenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "getSubjectType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "minimumBoundIfFlexible", "Lorg/jetbrains/kotlin/fir/types/ConeRigidType;", "unwrapTypeParameterAndIntersectionTypes", "", "getCheckers", "subjectType", "collectMissingCases", "", "", "checkers", "computeExhaustivenessStatus", "Lorg/jetbrains/kotlin/fir/expressions/ExhaustivenessStatus;", "useSiteFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "processExhaustivenessCheck", "hasElseBranch", "", "computeStatusForNonIntersectionType", "unwrappedSubjectType", "resolve", "minimumStatus"})
@SourceDebugExtension(value={"SMAP\nFirWhenExhaustivenessComputer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWhenExhaustivenessComputer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessComputer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,680:1\n1#2:681\n1480#3,5:682\n1586#3:687\n1661#3,3:688\n873#3,2:691\n1807#3,3:693\n52#4:696\n*S KotlinDebug\n*F\n+ 1 FirWhenExhaustivenessComputer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessComputer\n*L\n87#1:682,5\n94#1:687\n94#1:688,3\n104#1:691,2\n180#1:693,3\n202#1:696\n*E\n"})
public final class FirWhenExhaustivenessComputer {
    @NotNull
    public static final FirWhenExhaustivenessComputer INSTANCE = new FirWhenExhaustivenessComputer();
    @NotNull
    private static final List<WhenExhaustivenessChecker> exhaustivenessCheckers;

    private FirWhenExhaustivenessComputer() {
    }

    @NotNull
    public final List<WhenMissingCase> computeAllMissingCases(@NotNull FirSession session2, @NotNull FirWhenExpression whenExpression) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
        Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
        ConeKotlinType coneKotlinType = this.getSubjectType(session2, whenExpression);
        if (coneKotlinType == null || (coneKotlinType = this.minimumBoundIfFlexible(coneKotlinType, session2)) == null) {
            return ExhaustivenessStatus.NotExhaustive.Companion.getNO_ELSE_BRANCH_REASONS();
        }
        ConeKotlinType subjectType = coneKotlinType;
        List $this$computeAllMissingCases_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (ConeKotlinType type2 : INSTANCE.unwrapTypeParameterAndIntersectionTypes(subjectType, session2)) {
            List<WhenExhaustivenessChecker> checkers = INSTANCE.getCheckers(type2, session2);
            INSTANCE.collectMissingCases($this$computeAllMissingCases_u24lambda_u240, checkers, whenExpression, type2, session2);
        }
        return CollectionsKt.build((List)list2);
    }

    private final ConeKotlinType getSubjectType(FirSession session2, FirWhenExpression whenExpression) {
        Object object;
        block6: {
            FirPureAbstractElement firPureAbstractElement;
            block5: {
                FirVariable firVariable;
                object = whenExpression.getSubjectVariable();
                if (object == null) break block5;
                FirVariable it = firVariable = object;
                boolean bl = false;
                object = !FirExpressionUtilKt.isImplicitWhenSubjectVariable(it) ? firVariable : null;
                if (object != null && (object = ((FirVariable)object).getReturnTypeRef()) != null && (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) != null) break block6;
            }
            if ((firPureAbstractElement = whenExpression.getSubjectVariable()) != null && (firPureAbstractElement = firPureAbstractElement.getInitializer()) != null) {
                object = FirTypeUtilsKt.getResolvedType((FirExpression)firPureAbstractElement);
            } else {
                return null;
            }
        }
        Object subjectType = object;
        return TypeExpansionUtilsKt.fullyExpandedType$default((ConeKotlinType)subjectType, session2, null, 2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ConeRigidType minimumBoundIfFlexible(ConeKotlinType $this$minimumBoundIfFlexible, FirSession session2) {
        ConeRigidType coneRigidType;
        ConeKotlinType coneKotlinType = $this$minimumBoundIfFlexible;
        if (coneKotlinType instanceof ConeDynamicType) {
            boolean bl = FirLanguageSettingsComponentKt.getLanguageVersionSettings(session2).supportsFeature(LanguageFeature.ImprovedExhaustivenessChecksIn21);
            if (bl) {
                coneRigidType = ((ConeDynamicType)$this$minimumBoundIfFlexible).getUpperBound();
                return coneRigidType;
            } else {
                if (bl) throw new NoWhenBranchMatchedException();
                coneRigidType = ((ConeDynamicType)$this$minimumBoundIfFlexible).getLowerBound();
            }
            return coneRigidType;
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            coneRigidType = ((ConeFlexibleType)$this$minimumBoundIfFlexible).getLowerBound();
            return coneRigidType;
        } else {
            if (!(coneKotlinType instanceof ConeRigidType)) throw new NoWhenBranchMatchedException();
            coneRigidType = (ConeRigidType)$this$minimumBoundIfFlexible;
        }
        return coneRigidType;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<ConeKotlinType> unwrapTypeParameterAndIntersectionTypes(ConeKotlinType $this$unwrapTypeParameterAndIntersectionTypes, FirSession session2) {
        Collection collection;
        ConeKotlinType coneKotlinType = $this$unwrapTypeParameterAndIntersectionTypes;
        if (coneKotlinType instanceof ConeIntersectionType) {
            collection = ((ConeIntersectionType)$this$unwrapTypeParameterAndIntersectionTypes).getIntersectedTypes();
        } else if (coneKotlinType instanceof ConeTypeParameterType && FirLanguageSettingsComponentKt.getLanguageVersionSettings(session2).supportsFeature(LanguageFeature.ImprovedExhaustivenessChecksIn21)) {
            void $this$flatMapTo$iv;
            List list2;
            List $this$unwrapTypeParameterAndIntersectionTypes_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            Iterable iterable = ((ConeTypeParameterType)$this$unwrapTypeParameterAndIntersectionTypes).getLookupTag().getTypeParameterSymbol().getResolvedBounds();
            Collection destination$iv = $this$unwrapTypeParameterAndIntersectionTypes_u24lambda_u240;
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv;
                boolean bl2 = false;
                Iterable list$iv = INSTANCE.unwrapTypeParameterAndIntersectionTypes(it.getConeType(), session2);
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            $this$unwrapTypeParameterAndIntersectionTypes_u24lambda_u240.add($this$unwrapTypeParameterAndIntersectionTypes);
            collection = CollectionsKt.build((List)list2);
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType && FirLanguageSettingsComponentKt.getLanguageVersionSettings(session2).supportsFeature(LanguageFeature.ImprovedExhaustivenessChecksIn21)) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.unwrapTypeParameterAndIntersectionTypes(((ConeDefinitelyNotNullType)$this$unwrapTypeParameterAndIntersectionTypes).getOriginal(), session2);
            boolean $i$f$map = false;
            void bl = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ConeKotlinType element$iv = (ConeKotlinType)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl3 = false;
                collection2.add(TypeUtilsKt.makeConeTypeDefinitelyNotNullOrNotNull$default((ConeKotlinType)it, (ConeTypeContext)TypeComponentsKt.getTypeContext(session2), false, false, 6, null));
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = CollectionsKt.listOf((Object)$this$unwrapTypeParameterAndIntersectionTypes);
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    private final List<WhenExhaustivenessChecker> getCheckers(ConeKotlinType subjectType, FirSession session2) {
        void $this$filterTo$iv;
        List list2;
        List $this$getCheckers_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable iterable = exhaustivenessCheckers;
        Collection destination$iv = $this$getCheckers_u24lambda_u240;
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            WhenExhaustivenessChecker it = (WhenExhaustivenessChecker)element$iv;
            boolean bl2 = false;
            if (!it.isApplicable(subjectType, session2)) continue;
            destination$iv.add(element$iv);
        }
        if (!((Collection)$this$getCheckers_u24lambda_u240).isEmpty() && ConeTypeUtilsKt.isMarkedNullable(subjectType)) {
            $this$getCheckers_u24lambda_u240.add(WhenOnNullableExhaustivenessChecker.INSTANCE);
        }
        if ($this$getCheckers_u24lambda_u240.isEmpty()) {
            $this$getCheckers_u24lambda_u240.add(WhenSelfTypeExhaustivenessChecker.INSTANCE);
        }
        return CollectionsKt.build((List)list2);
    }

    private final void collectMissingCases(List<WhenMissingCase> $this$collectMissingCases, List<? extends WhenExhaustivenessChecker> checkers, FirWhenExpression whenExpression, ConeKotlinType subjectType, FirSession session2) {
        for (WhenExhaustivenessChecker whenExhaustivenessChecker : checkers) {
            whenExhaustivenessChecker.computeMissingCases(whenExpression, subjectType, session2, (Collection<WhenMissingCase>)$this$collectMissingCases);
        }
        if ($this$collectMissingCases.isEmpty() && whenExpression.getBranches().isEmpty()) {
            $this$collectMissingCases.add((WhenMissingCase)WhenMissingCase.Unknown.INSTANCE);
        }
    }

    @NotNull
    public final ExhaustivenessStatus computeExhaustivenessStatus(@NotNull FirWhenExpression whenExpression, @NotNull FirSession session2, @NotNull FirFile useSiteFile) {
        ExhaustivenessStatus exhaustivenessStatus;
        block0: {
            Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
            Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
            Intrinsics.checkNotNullParameter((Object)useSiteFile, (String)"useSiteFile");
            ExhaustivenessStatus it = exhaustivenessStatus = this.processExhaustivenessCheck(whenExpression, session2);
            boolean bl = false;
            FirEnumWhenTrackerComponent firEnumWhenTrackerComponent = FirEnumWhenTrackerComponentKt.getEnumWhenTracker(session2);
            if (firEnumWhenTrackerComponent == null) break block0;
            KtSourceFile ktSourceFile = useSiteFile.getSourceFile();
            ConeKotlinType coneKotlinType = INSTANCE.getSubjectType(session2, whenExpression);
            FirEnumWhenTrackerComponentKt.reportEnumUsageInWhen(firEnumWhenTrackerComponent, ktSourceFile != null ? ktSourceFile.getPath() : null, coneKotlinType != null ? INSTANCE.minimumBoundIfFlexible(coneKotlinType, session2) : null);
        }
        return exhaustivenessStatus;
    }

    private final ExhaustivenessStatus processExhaustivenessCheck(FirWhenExpression whenExpression, FirSession session2) {
        ConeKotlinType subjectType = this.getSubjectType(session2, whenExpression);
        if (subjectType == null) {
            return this.hasElseBranch(whenExpression) ? (ExhaustivenessStatus)ExhaustivenessStatus.ProperlyExhaustive.INSTANCE : (ExhaustivenessStatus)ExhaustivenessStatus.NotExhaustive.Companion.noElseBranch(null);
        }
        ConeRigidType minimumBound = this.minimumBoundIfFlexible(subjectType, session2);
        Lazy minimumStatus$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> FirWhenExhaustivenessComputer.processExhaustivenessCheck$lambda$0(whenExpression, minimumBound, session2));
        ExhaustivenessStatus status = this.hasElseBranch(whenExpression) ? (Intrinsics.areEqual((Object)FirWhenExhaustivenessComputer.processExhaustivenessCheck$computeUpperBoundStatus(subjectType, minimumBound, whenExpression, session2, (Lazy<? extends ExhaustivenessStatus>)minimumStatus$delegate), (Object)ExhaustivenessStatus.ProperlyExhaustive.INSTANCE) ? (ExhaustivenessStatus)ExhaustivenessStatus.RedundantlyExhaustive.INSTANCE : (ExhaustivenessStatus)ExhaustivenessStatus.ProperlyExhaustive.INSTANCE) : FirWhenExhaustivenessComputer.processExhaustivenessCheck$lambda$1((Lazy<? extends ExhaustivenessStatus>)minimumStatus$delegate);
        return status;
    }

    private final boolean hasElseBranch(FirWhenExpression $this$hasElseBranch) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$hasElseBranch.getBranches();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirWhenBranch it = (FirWhenBranch)element$iv;
                    boolean bl2 = false;
                    if (!(it.getCondition() instanceof FirElseIfTrueCondition)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final ExhaustivenessStatus computeExhaustivenessStatus(FirWhenExpression whenExpression, ConeKotlinType subjectType, FirSession session2) {
        ExhaustivenessStatus exhaustivenessStatus;
        ConeKotlinType approximatedType;
        ConeKotlinType coneKotlinType = TypeComponentsKt.getTypeApproximator(session2).approximateToSuperType(subjectType, (TypeApproximatorConfiguration)TypeApproximatorConfiguration.FinalApproximationAfterResolutionAndInference.INSTANCE);
        if (coneKotlinType == null) {
            coneKotlinType = approximatedType = subjectType;
        }
        if (whenExpression.getBranches().isEmpty() && ConeBuiltinTypeUtilsKt.isNothing(approximatedType)) {
            return ExhaustivenessStatus.ExhaustiveAsNothing.INSTANCE;
        }
        ExhaustivenessStatus status = null;
        Collection<ConeKotlinType> unwrappedIntersectionTypes = this.unwrapTypeParameterAndIntersectionTypes(approximatedType, session2);
        for (ConeKotlinType unwrappedSubjectType : unwrappedIntersectionTypes) {
            boolean bl;
            FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(unwrappedSubjectType, session2);
            if (firRegularClassSymbol != null) {
                FirClassLikeSymbol $this$isExpect$iv = firRegularClassSymbol;
                boolean $i$f$isExpect = false;
                bl = $this$isExpect$iv.getRawStatus().isExpect();
            } else {
                bl = false;
            }
            if (bl && !Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId(unwrappedSubjectType), (Object)StandardClassIds.INSTANCE.getBoolean())) continue;
            ExhaustivenessStatus localStatus = this.computeStatusForNonIntersectionType(unwrappedSubjectType, session2, whenExpression);
            if (localStatus == ExhaustivenessStatus.ProperlyExhaustive.INSTANCE) {
                status = localStatus;
                break;
            }
            if (status != null || localStatus == null) continue;
            status = localStatus;
        }
        if ((exhaustivenessStatus = status) == null) {
            exhaustivenessStatus = ExhaustivenessStatus.NotExhaustive.Companion.noElseBranch(approximatedType);
        }
        return exhaustivenessStatus;
    }

    private final ExhaustivenessStatus computeStatusForNonIntersectionType(ConeKotlinType unwrappedSubjectType, FirSession session2, FirWhenExpression whenExpression) {
        List<WhenExhaustivenessChecker> checkers = this.getCheckers(unwrappedSubjectType, session2);
        if (checkers.isEmpty()) {
            return null;
        }
        List whenMissingCases = new ArrayList();
        this.collectMissingCases(whenMissingCases, checkers, whenExpression, unwrappedSubjectType, session2);
        return whenMissingCases.isEmpty() ? (ExhaustivenessStatus)ExhaustivenessStatus.ProperlyExhaustive.INSTANCE : (ExhaustivenessStatus)new ExhaustivenessStatus.NotExhaustive(whenMissingCases, unwrappedSubjectType);
    }

    private static final ExhaustivenessStatus processExhaustivenessCheck$lambda$1(Lazy<? extends ExhaustivenessStatus> $minimumStatus$delegate) {
        Lazy<? extends ExhaustivenessStatus> lazy = $minimumStatus$delegate;
        return (ExhaustivenessStatus)lazy.getValue();
    }

    private static final ExhaustivenessStatus processExhaustivenessCheck$lambda$0(FirWhenExpression $whenExpression, ConeRigidType $minimumBound, FirSession $session) {
        return INSTANCE.computeExhaustivenessStatus($whenExpression, $minimumBound, $session);
    }

    private static final ExhaustivenessStatus processExhaustivenessCheck$computeUpperBoundStatus(ConeKotlinType subjectType, ConeRigidType minimumBound, FirWhenExpression $whenExpression, FirSession $session, Lazy<? extends ExhaustivenessStatus> minimumStatus$delegate) {
        ConeRigidType upperBound = ConeTypeUtilsKt.upperBoundIfFlexible(subjectType);
        if (Intrinsics.areEqual((Object)upperBound, (Object)minimumBound)) {
            return FirWhenExhaustivenessComputer.processExhaustivenessCheck$lambda$1(minimumStatus$delegate);
        }
        return INSTANCE.computeExhaustivenessStatus($whenExpression, upperBound, $session);
    }

    static {
        Object[] objectArray = new WhenExhaustivenessChecker[]{WhenOnBooleanExhaustivenessChecker.INSTANCE, WhenOnEnumExhaustivenessChecker.INSTANCE, WhenOnSealedClassExhaustivenessChecker.INSTANCE, WhenOnNothingExhaustivenessChecker.INSTANCE};
        exhaustivenessCheckers = CollectionsKt.listOf((Object[])objectArray);
    }
}

