/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.console.KotlinConsoleRunner;
import org.jetbrains.kotlin.console.gutter.ConsoleIndicatorRenderer;
import org.jetbrains.kotlin.console.gutter.IconWithTooltip;
import org.jetbrains.kotlin.console.gutter.ReplIcons;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J(\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/console/HistoryUpdater;", "", "runner", "Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;", "<init>", "(Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;)V", "consoleView", "Lcom/intellij/execution/console/LanguageConsoleImpl;", "getConsoleView", "()Lcom/intellij/execution/console/LanguageConsoleImpl;", "consoleView$delegate", "Lkotlin/Lazy;", "printNewCommandInHistory", "Lcom/intellij/openapi/util/TextRange;", "trimmedCommandText", "", "addCommandTextToHistoryEditor", "", "addLineBreakIfNeeded", "historyEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "addFoldingRegion", "startOffset", "", "endOffset", "command", "kotlin.repl"})
public final class HistoryUpdater {
    @NotNull
    private final KotlinConsoleRunner runner;
    @NotNull
    private final Lazy consoleView$delegate;

    public HistoryUpdater(@NotNull KotlinConsoleRunner runner) {
        Intrinsics.checkNotNullParameter((Object)((Object)runner), (String)"runner");
        this.runner = runner;
        this.consoleView$delegate = LazyKt.lazy(() -> HistoryUpdater.consoleView_delegate$lambda$0(this));
    }

    private final LanguageConsoleImpl getConsoleView() {
        Lazy lazy = this.consoleView$delegate;
        return (LanguageConsoleImpl)lazy.getValue();
    }

    @NotNull
    public final TextRange printNewCommandInHistory(@NotNull String trimmedCommandText) {
        RangeHighlighter rangeHighlighter;
        Intrinsics.checkNotNullParameter((Object)trimmedCommandText, (String)"trimmedCommandText");
        EditorEx historyEditor = this.getConsoleView().getHistoryViewer();
        this.addLineBreakIfNeeded(historyEditor);
        int startOffset = historyEditor.getDocument().getTextLength();
        this.addCommandTextToHistoryEditor(trimmedCommandText);
        int endOffset = historyEditor.getDocument().getTextLength();
        this.addFoldingRegion(historyEditor, startOffset, endOffset, trimmedCommandText);
        RangeHighlighter $this$printNewCommandInHistory_u24lambda_u240 = rangeHighlighter = historyEditor.getMarkupModel().addRangeHighlighter(startOffset, endOffset, 6000, null, HighlighterTargetArea.EXACT_RANGE);
        boolean bl = false;
        IconWithTooltip historyMarker = this.runner.isReadLineMode() ? ReplIcons.INSTANCE.getREADLINE_MARKER() : ReplIcons.INSTANCE.getCOMMAND_MARKER();
        $this$printNewCommandInHistory_u24lambda_u240.setGutterIconRenderer((GutterIconRenderer)new ConsoleIndicatorRenderer(historyMarker));
        historyEditor.getScrollingModel().scrollVertically(endOffset);
        return new TextRange(startOffset, endOffset);
    }

    private final void addCommandTextToHistoryEditor(String trimmedCommandText) {
        EditorEx consoleEditor = this.getConsoleView().getConsoleEditor();
        DocumentEx documentEx = consoleEditor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx consoleDocument = documentEx;
        consoleDocument.setText((CharSequence)trimmedCommandText);
        LanguageConsoleImpl.Companion.printWithHighlighting((LanguageConsoleView)this.getConsoleView(), (Editor)consoleEditor, new TextRange(0, consoleDocument.getTextLength()));
        this.getConsoleView().flushDeferredText();
        consoleDocument.setText((CharSequence)"");
    }

    private final void addLineBreakIfNeeded(EditorEx historyEditor) {
        if (this.runner.isReadLineMode()) {
            return;
        }
        DocumentEx documentEx = historyEditor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx historyDocument = documentEx;
        String string = historyDocument.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String historyText = string;
        int textLength = historyText.length();
        if (!StringsKt.endsWith$default((CharSequence)historyText, (char)'\n', (boolean)false, (int)2, null)) {
            historyDocument.insertString(textLength, (CharSequence)"\n");
            if (textLength == 0) {
                this.runner.addGutterIndicator(historyEditor, ReplIcons.INSTANCE.getHISTORY_INDICATOR());
            } else {
                historyDocument.insertString(textLength + 1, (CharSequence)"\n");
            }
        } else if (!StringsKt.endsWith$default((String)historyText, (String)"\n\n", (boolean)false, (int)2, null)) {
            historyDocument.insertString(textLength, (CharSequence)"\n");
        }
    }

    private final void addFoldingRegion(EditorEx historyEditor, int startOffset, int endOffset, String command2) {
        List cmdLines = StringsKt.lines((CharSequence)command2);
        int linesCount = cmdLines.size();
        if (linesCount < 2) {
            return;
        }
        FoldingModelEx foldingModelEx = historyEditor.getFoldingModel();
        Intrinsics.checkNotNullExpressionValue((Object)foldingModelEx, (String)"getFoldingModel(...)");
        FoldingModelEx foldingModel = foldingModelEx;
        foldingModel.runBatchFoldingOperation(() -> HistoryUpdater.addFoldingRegion$lambda$0(foldingModel, startOffset, endOffset, cmdLines));
    }

    private static final LanguageConsoleImpl consoleView_delegate$lambda$0(HistoryUpdater this$0) {
        LanguageConsoleView languageConsoleView = this$0.runner.getConsoleView();
        Intrinsics.checkNotNull((Object)languageConsoleView, (String)"null cannot be cast to non-null type com.intellij.execution.console.LanguageConsoleImpl");
        return (LanguageConsoleImpl)languageConsoleView;
    }

    private static final void addFoldingRegion$lambda$0(FoldingModelEx $foldingModel, int $startOffset, int $endOffset, List $cmdLines) {
        $foldingModel.addFoldRegion($startOffset, $endOffset, $cmdLines.get(0) + " ...");
    }
}

