/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.base.fir.scripting.projectStructure.modules;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModelKt;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import java.util.Objects;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KaModuleBase;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibraryModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaScriptModule;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.idea.base.projectStructure.ApiKt;
import org.jetbrains.kotlin.idea.core.script.v1.KotlinScriptSearchScope;
import org.jetbrains.kotlin.idea.core.script.v1.ScriptDependencyAware;
import org.jetbrains.kotlin.idea.core.script.v1.ScriptingTargetPlatformDetectorKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.scripting.definitions.DefinitionsKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.resolve.KtFileScriptSource;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u000101H\u0096\u0002J\b\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u000205H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001fR\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0016\u00106\u001a\u0004\u0018\u0001078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u001a\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010\u001f\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/base/fir/scripting/projectStructure/modules/KaScriptModuleBase;", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaScriptModule;", "Lorg/jetbrains/kotlin/analysis/api/platform/projectStructure/KaModuleBase;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "virtualFileUrlManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "getVirtualFileUrlManager", "()Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "currentSnapshot", "Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "getCurrentSnapshot", "()Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "scriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "getScriptDefinition", "()Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "scriptDefinition$delegate", "Lkotlin/Lazy;", "directDependsOnDependencies", "", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "getDirectDependsOnDependencies", "()Ljava/util/List;", "transitiveDependsOnDependencies", "getTransitiveDependsOnDependencies", "baseContentScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getBaseContentScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "targetPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getTargetPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "equals", "", "other", "", "hashCode", "", "toString", "", "sdkDependency", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaLibraryModule;", "getSdkDependency", "()Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaLibraryModule;", "directFriendDependencies", "getDirectFriendDependencies", "intellij.kotlin.scripting"})
public abstract class KaScriptModuleBase
extends KaModuleBase
implements KaScriptModule {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile virtualFile;
    @NotNull
    private final Lazy scriptDefinition$delegate;

    public KaScriptModuleBase(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        this.project = project;
        this.virtualFile = virtualFile;
        this.scriptDefinition$delegate = LazyKt.lazy(() -> KaScriptModuleBase.scriptDefinition_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    @NotNull
    protected final VirtualFileUrlManager getVirtualFileUrlManager() {
        return WorkspaceModelKt.getWorkspaceModel((Project)this.getProject()).getVirtualFileUrlManager();
    }

    @NotNull
    protected final ImmutableEntityStorage getCurrentSnapshot() {
        return WorkspaceModelKt.getWorkspaceModel((Project)this.getProject()).getCurrentSnapshot();
    }

    private final ScriptDefinition getScriptDefinition() {
        Lazy lazy = this.scriptDefinition$delegate;
        return (ScriptDefinition)((Object)lazy.getValue());
    }

    @Override
    @NotNull
    public List<KaModule> getDirectDependsOnDependencies() {
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public List<KaModule> getTransitiveDependsOnDependencies() {
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public GlobalSearchScope getBaseContentScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((Project)this.getProject(), (VirtualFile)this.getVirtualFile());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"fileScope(...)");
        GlobalSearchScope basicScriptScope = globalSearchScope;
        return (GlobalSearchScope)new KotlinScriptSearchScope(this.getProject(), basicScriptScope);
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        return ScriptingTargetPlatformDetectorKt.getPlatform(this.getProject(), this.getVirtualFile(), this.getScriptDefinition());
    }

    @Override
    @NotNull
    public LanguageVersionSettings getLanguageVersionSettings() {
        return ScriptingTargetPlatformDetectorKt.getLanguageVersionSettings(this.getProject(), this.getVirtualFile(), this.getScriptDefinition());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.base.fir.scripting.projectStructure.modules.KaScriptModuleBase");
        KaScriptModuleBase cfr_ignored_0 = (KaScriptModuleBase)object2;
        if (!Intrinsics.areEqual((Object)this.getProject(), (Object)((KaScriptModuleBase)other).getProject())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getVirtualFile(), (Object)((KaScriptModuleBase)other).getVirtualFile());
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getVirtualFile(), this.getProject()};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "(" + this.getVirtualFile() + "), platform=" + this.getTargetPlatform() + ", moduleDescription=`" + this.getModuleDescription() + "`, scriptDefinition=`" + this.getScriptDefinition() + "`";
    }

    @Nullable
    protected KaLibraryModule getSdkDependency() {
        Sdk sdk2 = ScriptDependencyAware.Companion.getInstance(this.getProject()).getScriptSdk(this.getVirtualFile());
        return sdk2 != null ? ApiKt.toKaLibraryModule(sdk2, this.getProject()) : null;
    }

    @Override
    @NotNull
    public List<KaModule> getDirectFriendDependencies() {
        return CollectionsKt.emptyList();
    }

    private static final ScriptDefinition scriptDefinition_delegate$lambda$0(KaScriptModuleBase this$0) {
        return DefinitionsKt.findScriptDefinition(this$0.getProject(), new KtFileScriptSource(this$0.getFile(), null, 2, null));
    }
}

