/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.structure;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibraryModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaScriptModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaSourceModule;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.structure.LLSessionStatistics;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00000\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001b\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\"\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/structure/LLSessionStructureGraphNode;", "", "id", "", "session", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "statistics", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/structure/LLSessionStatistics;", "<init>", "(ILorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/structure/LLSessionStatistics;)V", "getId", "()I", "getSession", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "getStatistics", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/structure/LLSessionStatistics;", "dependencies", "", "getDependencies", "()Ljava/util/List;", "setDependencies", "(Ljava/util/List;)V", "analysisRootDistance", "getAnalysisRootDistance", "()Ljava/lang/Integer;", "setAnalysisRootDistance", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "label", "", "getLabel", "()Ljava/lang/String;", "isSignificant", "", "()Z", "low-level-api-fir"})
public final class LLSessionStructureGraphNode {
    private final int id;
    @NotNull
    private final LLFirSession session;
    @NotNull
    private final LLSessionStatistics statistics;
    @NotNull
    private List<LLSessionStructureGraphNode> dependencies;
    @Nullable
    private Integer analysisRootDistance;

    public LLSessionStructureGraphNode(int id, @NotNull LLFirSession session2, @NotNull LLSessionStatistics statistics) {
        Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
        Intrinsics.checkNotNullParameter((Object)statistics, (String)"statistics");
        this.id = id;
        this.session = session2;
        this.statistics = statistics;
        this.dependencies = CollectionsKt.emptyList();
    }

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final LLFirSession getSession() {
        return this.session;
    }

    @NotNull
    public final LLSessionStatistics getStatistics() {
        return this.statistics;
    }

    @NotNull
    public final List<LLSessionStructureGraphNode> getDependencies() {
        return this.dependencies;
    }

    public final void setDependencies(@NotNull List<LLSessionStructureGraphNode> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.dependencies = list2;
    }

    @Nullable
    public final Integer getAnalysisRootDistance() {
        return this.analysisRootDistance;
    }

    public final void setAnalysisRootDistance(@Nullable Integer n) {
        this.analysisRootDistance = n;
    }

    @NotNull
    public final String getLabel() {
        KaModule module = this.session.getKtModule();
        return module instanceof KaSourceModule ? "[SRC] " + ((KaSourceModule)module).getName() : (module instanceof KaLibraryModule ? "[LIB] " + ((KaLibraryModule)module).getLibraryName() : (module instanceof KaScriptModule ? "[SCRIPT]" : module.getModuleDescription()));
    }

    public final boolean isSignificant() {
        return this.statistics.getWeight() > 0L;
    }
}

