/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.platform.projectStructure;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KaDanglingFileModuleImpl;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KotlinProjectStructureProvider;
import org.jetbrains.kotlin.analysis.api.projectStructure.ContextModuleKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.DanglingFilesKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileResolutionMode;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaNotUnderContentRootModule;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H$J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/analysis/api/platform/projectStructure/KotlinProjectStructureProviderBase;", "Lorg/jetbrains/kotlin/analysis/api/platform/projectStructure/KotlinProjectStructureProvider;", "<init>", "()V", "getNotUnderContentRootModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaNotUnderContentRootModule;", "project", "Lcom/intellij/openapi/project/Project;", "computeSpecialModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "file", "Lcom/intellij/psi/PsiFile;", "computeDefaultDanglingFileResolutionMode", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaDanglingFileResolutionMode;", "Lorg/jetbrains/kotlin/psi/KtFile;", "computeContextModule", "isSupportedContextElement", "", "context", "Lcom/intellij/psi/PsiElement;", "analysis-api-platform-interface"})
@SourceDebugExtension(value={"SMAP\nKotlinProjectStructureProviderBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinProjectStructureProviderBase.kt\norg/jetbrains/kotlin/analysis/api/platform/projectStructure/KotlinProjectStructureProviderBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1#2:105\n*E\n"})
public abstract class KotlinProjectStructureProviderBase
implements KotlinProjectStructureProvider {
    @NotNull
    protected abstract KaNotUnderContentRootModule getNotUnderContentRootModule(@NotNull Project var1);

    @Nullable
    protected final KaModule computeSpecialModule(@NotNull PsiFile file) {
        KaModule contextModule;
        KaModule explicitModule;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file instanceof KtFile && (explicitModule = DanglingFilesKt.getExplicitModule((KtFile)file)) != null) {
            return explicitModule;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null && (contextModule = ContextModuleKt.getAnalysisContextModule(virtualFile)) != null) {
            return contextModule;
        }
        if (file instanceof KtFile && DanglingFilesKt.isDangling((KtFile)file)) {
            contextModule = this.computeContextModule((KtFile)file);
            KaDanglingFileResolutionMode kaDanglingFileResolutionMode = DanglingFilesKt.getDanglingFileResolutionMode((KtFile)file);
            if (kaDanglingFileResolutionMode == null) {
                kaDanglingFileResolutionMode = this.computeDefaultDanglingFileResolutionMode((KtFile)file);
            }
            KaDanglingFileResolutionMode resolutionMode = kaDanglingFileResolutionMode;
            return new KaDanglingFileModuleImpl(CollectionsKt.listOf((Object)file), contextModule, resolutionMode);
        }
        return null;
    }

    private final KaDanglingFileResolutionMode computeDefaultDanglingFileResolutionMode(KtFile file) {
        if (!file.isPhysical() && !file.getViewProvider().isEventSystemEnabled() && DanglingFilesKt.getCopyOrigin((PsiFile)file) != null) {
            return KaDanglingFileResolutionMode.IGNORE_SELF;
        }
        return KaDanglingFileResolutionMode.PREFER_SELF;
    }

    private final KaModule computeContextModule(KtFile file) {
        PsiElement contextElement;
        Object object;
        block11: {
            Object object2;
            PsiFile originalFile;
            block10: {
                PsiElement psiElement;
                KaModule kaModule;
                Object object3;
                originalFile = DanglingFilesKt.getCopyOrigin((PsiFile)file);
                if (originalFile != null && (object3 = originalFile.getVirtualFile()) != null && (kaModule = ContextModuleKt.getAnalysisContextModule(object3)) != null) {
                    KaModule it = kaModule;
                    boolean bl = false;
                    return it;
                }
                object3 = DanglingFilesKt.getContextModule(file);
                if (object3 != null) {
                    Object it = object3;
                    boolean bl = false;
                    return it;
                }
                object = file.getContext();
                if (object == null) break block10;
                PsiElement p0 = psiElement = object;
                boolean bl = false;
                object = this.isSupportedContextElement(p0) ? psiElement : null;
                if (object != null) break block11;
            }
            PsiElement psiElement = KtPsiFactoryKt.getAnalysisContext((KtFile)file);
            if (psiElement != null) {
                PsiElement psiElement2;
                PsiElement p0 = psiElement2 = psiElement;
                boolean bl = false;
                object2 = this.isSupportedContextElement(p0) ? psiElement2 : null;
            } else {
                object2 = object = null;
            }
            if (object2 == null) {
                object = (PsiElement)originalFile;
            }
        }
        if ((contextElement = object) != null) {
            KaModule contextModule = this.getModule(contextElement, null);
            if (contextModule instanceof KaDanglingFileModule && !(file instanceof KtCodeFragment)) {
                return DanglingFilesKt.getBaseContextModule((KaDanglingFileModule)contextModule);
            }
            return contextModule;
        }
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return this.getNotUnderContentRootModule(project);
    }

    private final boolean isSupportedContextElement(PsiElement context2) {
        return Intrinsics.areEqual((Object)context2.getLanguage(), (Object)KotlinLanguage.INSTANCE) || context2 instanceof PsiDirectory;
    }
}

