/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.shadow;

import androidx.compose.ui.geometry.CornerRadius;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.BlendMode;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.BrushKt;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.CanvasKt;
import androidx.compose.ui.graphics.ColorFilter;
import androidx.compose.ui.graphics.CompositeShaderBrush;
import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.graphics.ImageBitmapConfig;
import androidx.compose.ui.graphics.ImageBitmapKt;
import androidx.compose.ui.graphics.Matrix;
import androidx.compose.ui.graphics.Outline;
import androidx.compose.ui.graphics.Paint;
import androidx.compose.ui.graphics.PaintingStyle;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.ShaderBrush;
import androidx.compose.ui.graphics.ShaderKt;
import androidx.compose.ui.graphics.SkiaBackedPaint_skikoKt;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.shadow.BlurKt;
import androidx.compose.ui.graphics.shadow.Blur_skikoKt;
import androidx.compose.ui.graphics.shadow.Shadow;
import androidx.compose.ui.graphics.shadow.ShadowRenderer;
import androidx.compose.ui.unit.DpOffset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.MaskFilter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\u0011\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J-\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0018\u0010\u001f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!H\u0002JQ\u0010\"\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010'\u001a\u00020(H\u0014\u00a2\u0006\u0004\b)\u0010*J?\u0010+\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020$2\u0006\u0010/\u001a\u00020$H\u0002\u00a2\u0006\u0004\b0\u00101J?\u00102\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020$2\u0006\u0010/\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b3\u00104R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u00065"}, d2={"Landroidx/compose/ui/graphics/shadow/InnerShadowRenderer;", "Landroidx/compose/ui/graphics/shadow/ShadowRenderer;", "shadow", "Landroidx/compose/ui/graphics/shadow/Shadow;", "outline", "Landroidx/compose/ui/graphics/Outline;", "<init>", "(Landroidx/compose/ui/graphics/shadow/Shadow;Landroidx/compose/ui/graphics/Outline;)V", "paint", "Landroidx/compose/ui/graphics/Paint;", "shadowMask", "Landroidx/compose/ui/graphics/ShaderBrush;", "compositeShader", "Landroidx/compose/ui/graphics/CompositeShaderBrush;", "matrix", "Landroidx/compose/ui/graphics/Matrix;", "[F", "obtainMatrix", "obtainMatrix-sQKQjiQ", "()[F", "buildShadow", "", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "size", "Landroidx/compose/ui/geometry/Size;", "cornerRadius", "Landroidx/compose/ui/geometry/CornerRadius;", "path", "Landroidx/compose/ui/graphics/Path;", "buildShadow-_SMYjrA", "(Landroidx/compose/ui/graphics/drawscope/DrawScope;JJLandroidx/compose/ui/graphics/Path;)V", "obtainCompositeBrush", "brush", "Landroidx/compose/ui/graphics/Brush;", "onDrawShadow", "alpha", "", "colorFilter", "Landroidx/compose/ui/graphics/ColorFilter;", "blendMode", "Landroidx/compose/ui/graphics/BlendMode;", "onDrawShadow-MLmccfk", "(Landroidx/compose/ui/graphics/drawscope/DrawScope;JJLandroidx/compose/ui/graphics/Path;FLandroidx/compose/ui/graphics/ColorFilter;Landroidx/compose/ui/graphics/Brush;I)V", "createInnerPathShadowBrush", "radius", "spread", "offsetX", "offsetY", "createInnerPathShadowBrush-LjSzlW0", "(JLandroidx/compose/ui/graphics/Path;FFFF)Landroidx/compose/ui/graphics/ShaderBrush;", "createInnerShadowBrush", "createInnerShadowBrush-u1Psq-8", "(JFFFFJ)Landroidx/compose/ui/graphics/ShaderBrush;", "ui-graphics"})
@SourceDebugExtension(value={"SMAP\nInnerShadowPainter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InnerShadowPainter.kt\nandroidx/compose/ui/graphics/shadow/InnerShadowRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Size.kt\nandroidx/compose/ui/geometry/Size\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 5 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 6 Rect.kt\nandroidx/compose/ui/geometry/Rect\n+ 7 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n+ 8 CornerRadius.kt\nandroidx/compose/ui/geometry/CornerRadius\n*L\n1#1,387:1\n1#2:388\n57#3:389\n61#3:392\n57#3:401\n61#3:404\n57#3:407\n61#3:410\n60#4:390\n70#4:393\n53#4,3:398\n60#4:402\n70#4:405\n60#4:408\n70#4:411\n60#4:414\n70#4:417\n22#5:391\n22#5:394\n22#5:403\n22#5:406\n22#5:409\n22#5:412\n22#5:415\n22#5:418\n57#6:395\n62#6:396\n30#7:397\n48#8:413\n53#8:416\n*S KotlinDebug\n*F\n+ 1 InnerShadowPainter.kt\nandroidx/compose/ui/graphics/shadow/InnerShadowRenderer\n*L\n235#1:389\n236#1:392\n348#1:401\n349#1:404\n356#1:407\n357#1:410\n235#1:390\n236#1:393\n295#1:398,3\n348#1:402\n349#1:405\n356#1:408\n357#1:411\n364#1:414\n365#1:417\n235#1:391\n236#1:394\n348#1:403\n349#1:406\n356#1:409\n357#1:412\n364#1:415\n365#1:418\n244#1:395\n245#1:396\n295#1:397\n364#1:413\n365#1:416\n*E\n"})
public final class InnerShadowRenderer
extends ShadowRenderer {
    @NotNull
    private final Shadow shadow;
    @NotNull
    private final Paint paint;
    @Nullable
    private ShaderBrush shadowMask;
    @Nullable
    private CompositeShaderBrush compositeShader;
    @Nullable
    private float[] matrix;

    public InnerShadowRenderer(@NotNull Shadow shadow, @NotNull Outline outline) {
        Intrinsics.checkNotNullParameter((Object)shadow, (String)"shadow");
        Intrinsics.checkNotNullParameter((Object)outline, (String)"outline");
        super(outline);
        this.shadow = shadow;
        this.paint = SkiaBackedPaint_skikoKt.Paint();
    }

    private final float[] obtainMatrix-sQKQjiQ() {
        float[] fArray = this.matrix;
        if (this.matrix == null) {
            float[] fArray2;
            float[] it = fArray2 = Matrix.constructor-impl$default(null, 1, null);
            boolean bl = false;
            this.matrix = it;
            fArray = fArray2;
        }
        return fArray;
    }

    @Override
    protected void buildShadow-_SMYjrA(@NotNull DrawScope $this$buildShadow_u2d_SMYjrA, long l, long l2, @Nullable Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$buildShadow_u2d_SMYjrA, (String)"$this$buildShadow");
        float radius = $this$buildShadow_u2d_SMYjrA.toPx-0680j_4(this.shadow.getRadius-D9Ej5fM());
        float spread = $this$buildShadow_u2d_SMYjrA.toPx-0680j_4(this.shadow.getSpread-D9Ej5fM());
        float offsetX = $this$buildShadow_u2d_SMYjrA.toPx-0680j_4(DpOffset.getX-D9Ej5fM(this.shadow.getOffset-RKDOV3M()));
        float offsetY = $this$buildShadow_u2d_SMYjrA.toPx-0680j_4(DpOffset.getY-D9Ej5fM(this.shadow.getOffset-RKDOV3M()));
        this.shadowMask = path != null ? this.createInnerPathShadowBrush-LjSzlW0(l, path, radius, spread, offsetX, offsetY) : this.createInnerShadowBrush-u1Psq-8(l, radius, spread, offsetX, offsetY, l2);
    }

    private final CompositeShaderBrush obtainCompositeBrush(ShaderBrush shadowMask, Brush brush) {
        CompositeShaderBrush shader = this.compositeShader;
        if (shader == null || !Intrinsics.areEqual((Object)shader.getSrcBrush(), (Object)brush)) {
            CompositeShaderBrush compositeShaderBrush;
            CompositeShaderBrush it = compositeShaderBrush = new CompositeShaderBrush(BrushKt.toShaderBrush(shadowMask), BrushKt.toShaderBrush(brush), BlendMode.Companion.getSrcIn-0nO6VwU(), null);
            boolean bl = false;
            this.compositeShader = it;
            shader = compositeShaderBrush;
        }
        return shader;
    }

    @Override
    protected void onDrawShadow-MLmccfk(@NotNull DrawScope $this$onDrawShadow_u2dMLmccfk, long l, long l2, @Nullable Path path, float alpha, @Nullable ColorFilter colorFilter, @Nullable Brush brush, int n) {
        block4: {
            ShaderBrush targetBrush;
            Intrinsics.checkNotNullParameter((Object)$this$onDrawShadow_u2dMLmccfk, (String)"$this$onDrawShadow");
            ShaderBrush shaderBrush = this.shadowMask;
            if (shaderBrush == null) break block4;
            ShaderBrush mask = shaderBrush;
            boolean bl = false;
            ShaderBrush shaderBrush2 = targetBrush = this.shadow.getBrush() instanceof ShaderBrush ? (ShaderBrush)this.obtainCompositeBrush(mask, this.shadow.getBrush()) : mask;
            if (path != null) {
                Path path2 = path;
                DrawScope.drawPath-GBMwjPU$default($this$onDrawShadow_u2dMLmccfk, path2, targetBrush, alpha, null, colorFilter, n, 8, null);
            } else if (CornerRadius.equals-impl0(l2, CornerRadius.Companion.getZero-kKHJgLs())) {
                DrawScope.drawRect-AsUm42w$default($this$onDrawShadow_u2dMLmccfk, targetBrush, 0L, 0L, alpha, null, colorFilter, n, 22, null);
            } else {
                int n2 = this.shadow.getBlendMode-0nO6VwU();
                DrawScope.drawRoundRect-ZuiqVtQ$default($this$onDrawShadow_u2dMLmccfk, targetBrush, 0L, 0L, l2, alpha, null, colorFilter, n2, 38, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ShaderBrush createInnerPathShadowBrush-LjSzlW0(long l, Path path, float radius, float spread, float offsetX, float offsetY) {
        Canvas shadowCanvas;
        ImageBitmap pathBitmap = null;
        long l2 = l;
        boolean bl = false;
        long value$iv$iv = l2;
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        boolean $i$f$floatFromBits = false;
        int widthPx = (int)Math.ceil(Float.intBitsToFloat(bits$iv$iv$iv));
        $v$c$androidx-compose-ui-geometry-Size$-this$0$iv = l;
        boolean bl2 = false;
        long value$iv$iv2 = $v$c$androidx-compose-ui-geometry-Size$-this$0$iv;
        boolean $i$f$unpackFloat2 = false;
        int bits$iv$iv$iv22 = (int)(value$iv$iv2 & 0xFFFFFFFFL);
        int $i$f$floatFromBits22 = 0;
        int heightPx = (int)Math.ceil(Float.intBitsToFloat(bits$iv$iv$iv22));
        if (spread > 0.0f) {
            void $this$createInnerPathShadowBrush_LjSzlW0_u24lambda_u240_u240;
            Canvas pathCanvas;
            Rect pathBounds;
            Rect this_$iv = pathBounds = path.getBounds();
            boolean $i$f$getWidth = false;
            float pathWidth = this_$iv.getRight() - this_$iv.getLeft();
            Rect this_$iv2 = pathBounds;
            boolean $i$f$getHeight = false;
            float pathHeight = this_$iv2.getBottom() - this_$iv2.getTop();
            pathBitmap = ImageBitmapKt.ImageBitmap-x__-hDU$default((int)Math.ceil(pathWidth), (int)Math.ceil(pathHeight), ImageBitmapConfig.Companion.getAlpha8-_sVssgQ(), false, null, 24, null);
            Canvas $this$createInnerPathShadowBrush_LjSzlW0_u24lambda_u240 = pathCanvas = CanvasKt.Canvas(pathBitmap);
            boolean bl3 = false;
            $this$createInnerPathShadowBrush_LjSzlW0_u24lambda_u240.drawPath(path, this.paint);
            Canvas.clipRect-N_I0leg$default($this$createInnerPathShadowBrush_LjSzlW0_u24lambda_u240, 0.0f, 0.0f, pathWidth, pathHeight, 0, 16, null);
            Paint bits$iv$iv$iv22 = this.paint;
            $i$f$floatFromBits22 = PaintingStyle.Companion.getStroke-TiuSbCo();
            int n = BlendMode.Companion.getClear-0nO6VwU();
            Paint $i$f$floatFromBits22 = bits$iv$iv$iv22 = BlurKt.configureShadow-FoewPVk$default(bits$iv$iv$iv22, 0L, n, null, $i$f$floatFromBits22, 5, null);
            Path path2 = path;
            Canvas canvas = $this$createInnerPathShadowBrush_LjSzlW0_u24lambda_u240;
            boolean bl4 = false;
            $this$createInnerPathShadowBrush_LjSzlW0_u24lambda_u240_u240.setStrokeWidth(spread * 2.0f);
            Unit unit = Unit.INSTANCE;
            canvas.drawPath(path2, bits$iv$iv$iv22);
        } else {
            pathBitmap = null;
        }
        int clampPadding = (int)Math.ceil(radius);
        ImageBitmap shadowBitmap = ImageBitmapKt.ImageBitmap-x__-hDU$default(widthPx + clampPadding * 2, heightPx + clampPadding * 2, ImageBitmapConfig.Companion.getAlpha8-_sVssgQ(), false, null, 24, null);
        Canvas $this$createInnerPathShadowBrush_LjSzlW0_u24lambda_u241 = shadowCanvas = CanvasKt.Canvas(shadowBitmap);
        boolean bl5 = false;
        if (pathBitmap != null) {
            void val1$iv$iv;
            void x$iv;
            $this$createInnerPathShadowBrush_LjSzlW0_u24lambda_u241.drawRect(0.0f, 0.0f, shadowBitmap.getWidth(), shadowBitmap.getHeight(), BlurKt.configureShadow-FoewPVk$default(this.paint, 0L, 0, null, 0, 15, null));
            float bl3 = offsetX;
            float y$iv = offsetY;
            boolean $i$f$Offset = false;
            void bl4 = x$iv;
            float val2$iv$iv = y$iv;
            boolean $i$f$packFloats = false;
            long v1$iv$iv = Float.floatToRawIntBits((float)val1$iv$iv);
            long v2$iv$iv = Float.floatToRawIntBits(val2$iv$iv);
            Paint paint = this.paint;
            MaskFilter maskFilter = radius > 0.0f ? Blur_skikoKt.BlurFilter(radius) : null;
            int n = BlendMode.Companion.getXor-0nO6VwU();
            $this$createInnerPathShadowBrush_LjSzlW0_u24lambda_u241.drawImage-d-4ec7I(pathBitmap, Offset.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL), BlurKt.configureShadow-FoewPVk$default(paint, 0L, n, maskFilter, 0, 9, null));
            return BrushKt.ShaderBrush(ShaderKt.ImageShader-F49vj9s$default(shadowBitmap, 0, 0, 6, null));
        }
        $this$createInnerPathShadowBrush_LjSzlW0_u24lambda_u241.save();
        $this$createInnerPathShadowBrush_LjSzlW0_u24lambda_u241.translate(offsetX, offsetY);
        $this$createInnerPathShadowBrush_LjSzlW0_u24lambda_u241.drawPath(path, BlurKt.configureShadow-FoewPVk$default(this.paint, 0L, 0, radius > 0.0f ? Blur_skikoKt.BlurFilter(radius) : null, 0, 11, null));
        $this$createInnerPathShadowBrush_LjSzlW0_u24lambda_u241.restore();
        $this$createInnerPathShadowBrush_LjSzlW0_u24lambda_u241.drawRect(0.0f, 0.0f, shadowBitmap.getWidth(), shadowBitmap.getHeight(), BlurKt.configureShadow-FoewPVk$default(this.paint, 0L, BlendMode.Companion.getXor-0nO6VwU(), null, 0, 13, null));
        return BrushKt.ShaderBrush(ShaderKt.ImageShader-F49vj9s$default(shadowBitmap, 0, 0, 6, null));
    }

    private final ShaderBrush createInnerShadowBrush-u1Psq-8(long l, float radius, float spread, float offsetX, float offsetY, long l2) {
        Canvas shadowCanvas;
        long l3 = l;
        boolean bl = false;
        long value$iv$iv = l3;
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        boolean $i$f$floatFromBits = false;
        int n = (int)Math.ceil(Float.intBitsToFloat(bits$iv$iv$iv));
        l3 = l;
        boolean bl2 = false;
        value$iv$iv = l3;
        boolean $i$f$unpackFloat2 = false;
        bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
        $i$f$floatFromBits = false;
        ImageBitmap shadowBitmap = ImageBitmapKt.ImageBitmap-x__-hDU$default(n, (int)Math.ceil(Float.intBitsToFloat(bits$iv$iv$iv)), ImageBitmapConfig.Companion.getAlpha8-_sVssgQ(), false, null, 24, null);
        Canvas $this$createInnerShadowBrush_u1Psq_8_u24lambda_u240 = shadowCanvas = CanvasKt.Canvas(shadowBitmap);
        boolean bl3 = false;
        float left = offsetX + spread;
        float top = offsetY + spread;
        $v$c$androidx-compose-ui-geometry-Size$-this$0$iv = l;
        $i$f$getWidth-impl = false;
        long value$iv$iv2 = $v$c$androidx-compose-ui-geometry-Size$-this$0$iv;
        boolean $i$f$unpackFloat12 = false;
        int bits$iv$iv$iv2 = (int)(value$iv$iv2 >> 32);
        boolean $i$f$floatFromBits2 = false;
        float f = offsetX + Float.intBitsToFloat(bits$iv$iv$iv2) - spread;
        float right = Math.max(left, f);
        $v$c$androidx-compose-ui-geometry-Size$-this$0$iv = l;
        $i$f$getHeight-impl = false;
        long value$iv$iv3 = $v$c$androidx-compose-ui-geometry-Size$-this$0$iv;
        boolean $i$f$unpackFloat22 = false;
        int bits$iv$iv$iv3 = (int)(value$iv$iv3 & 0xFFFFFFFFL);
        boolean $i$f$floatFromBits3 = false;
        float f2 = offsetY + Float.intBitsToFloat(bits$iv$iv$iv3) - spread;
        float bottom = Math.max(top, f2);
        long l4 = l2;
        boolean bl4 = false;
        value$iv$iv3 = l4;
        boolean $i$f$unpackFloat13 = false;
        bits$iv$iv$iv3 = (int)(value$iv$iv3 >> 32);
        $i$f$floatFromBits3 = false;
        float f3 = Float.intBitsToFloat(bits$iv$iv$iv3);
        l4 = l2;
        boolean bl5 = false;
        value$iv$iv3 = l4;
        $i$f$unpackFloat22 = false;
        bits$iv$iv$iv3 = (int)(value$iv$iv3 & 0xFFFFFFFFL);
        $i$f$floatFromBits3 = false;
        $this$createInnerShadowBrush_u1Psq_8_u24lambda_u240.drawRoundRect(left, top, right, bottom, f3, Float.intBitsToFloat(bits$iv$iv$iv3), BlurKt.configureShadow-FoewPVk$default(this.paint, 0L, 0, radius > 0.0f ? Blur_skikoKt.BlurFilter(radius) : null, 0, 11, null));
        $this$createInnerShadowBrush_u1Psq_8_u24lambda_u240.drawRect(0.0f, 0.0f, shadowBitmap.getWidth(), shadowBitmap.getHeight(), BlurKt.configureShadow-FoewPVk$default(this.paint, 0L, BlendMode.Companion.getXor-0nO6VwU(), null, 0, 13, null));
        return BrushKt.ShaderBrush(ShaderKt.ImageShader-F49vj9s$default(shadowBitmap, 0, 0, 6, null));
    }
}

