/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.lower.loops.ForLoopBodyTransformer;
import org.jetbrains.kotlin.backend.common.lower.loops.RangeLoopTransformer;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@PhaseDescription(name="ForLoopsLowering")
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/ForLoopsLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "loopBodyTransformer", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ForLoopBodyTransformer;", "getLoopBodyTransformer", "()Lorg/jetbrains/kotlin/backend/common/lower/loops/ForLoopBodyTransformer;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "ir.backend.common"})
public class ForLoopsLowering
implements BodyLoweringPass {
    @NotNull
    private final CommonBackendContext context;

    public ForLoopsLowering(@NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    @Nullable
    public ForLoopBodyTransformer getLoopBodyTransformer() {
        return null;
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Map oldLoopToNewLoop = new LinkedHashMap();
        RangeLoopTransformer transformer2 = new RangeLoopTransformer(this.context, container, oldLoopToNewLoop, this.getLoopBodyTransformer());
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, transformer2);
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new IrElementTransformerVoid(oldLoopToNewLoop){
            final /* synthetic */ Map<IrLoop, IrLoop> $oldLoopToNewLoop;
            {
                this.$oldLoopToNewLoop = $oldLoopToNewLoop;
            }

            public IrExpression visitBreakContinue(IrBreakContinue jump) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
                    IrLoop irLoop = this.$oldLoopToNewLoop.get(jump.getLoop());
                    if (irLoop == null) break block0;
                    IrLoop it = irLoop;
                    boolean bl = false;
                    jump.setLoop(it);
                }
                return jump;
            }
        });
    }
}

