/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Actuals_jvmKt;
import org.jetbrains.skia.FourByteTag;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\nJ\b\u0010\u0012\u001a\u00020\tH\u0016J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/skia/FontVariation;", "", "_tag", "", "value", "", "<init>", "(IF)V", "feature", "", "(Ljava/lang/String;F)V", "get_tag", "()I", "getValue", "()F", "tag", "getTag", "()Ljava/lang/String;", "toString", "equals", "", "other", "hashCode", "Companion", "skiko"})
public final class FontVariation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int _tag;
    private final float value;
    @NotNull
    private static final FontVariation[] EMPTY = new FontVariation[0];
    @NotNull
    private static final Pattern _splitPattern = Actuals_jvmKt.compilePattern("\\s+");
    @NotNull
    private static final Pattern _variationPattern = Actuals_jvmKt.compilePattern("([a-z0-9]{4})=(\\d+)");
    private static final int tagIx = 1;
    private static final int valueIx = 2;

    public FontVariation(int _tag, float value) {
        this._tag = _tag;
        this.value = value;
    }

    public final int get_tag() {
        return this._tag;
    }

    public final float getValue() {
        return this.value;
    }

    public FontVariation(@NotNull String feature, float value) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        this(FourByteTag.Companion.fromString(feature), value);
    }

    @NotNull
    public final String getTag() {
        return FourByteTag.Companion.toString(this._tag);
    }

    @NotNull
    public String toString() {
        return this.getTag() + '=' + this.value;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FontVariation)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getTag(), (Object)((FontVariation)other).getTag())) {
            return false;
        }
        return Float.compare(this.value, ((FontVariation)other).value) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * PRIME + this._tag;
        result = result * PRIME + Float.floatToIntBits(this.value);
        return result;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017J\u0019\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0019\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u001aR\u001b\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\n\u001a\u00060\fj\u0002`\u000bX\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0010\u001a\u00060\fj\u0002`\u000bX\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u0011\u0010\u000eR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/skia/FontVariation$Companion;", "", "<init>", "()V", "EMPTY", "", "Lorg/jetbrains/skia/FontVariation;", "getEMPTY", "()[Lorg/jetbrains/skia/FontVariation;", "[Lorg/jetbrains/skia/FontVariation;", "_splitPattern", "Lorg/jetbrains/skia/Pattern;", "Ljava/util/regex/Pattern;", "get_splitPattern$skiko", "()Ljava/util/regex/Pattern;", "Ljava/util/regex/Pattern;", "_variationPattern", "get_variationPattern$skiko", "tagIx", "", "valueIx", "parseOne", "s", "", "parse", "str", "(Ljava/lang/String;)[Lorg/jetbrains/skia/FontVariation;", "skiko"})
    @SourceDebugExtension(value={"SMAP\nFontVariation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FontVariation.kt\norg/jetbrains/skia/FontVariation$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,54:1\n1#2:55\n11102#3:56\n11437#3,3:57\n37#4,2:60\n*S KotlinDebug\n*F\n+ 1 FontVariation.kt\norg/jetbrains/skia/FontVariation$Companion\n*L\n50#1:56\n50#1:57,3\n50#1:60,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FontVariation[] getEMPTY() {
            return EMPTY;
        }

        @NotNull
        public final Pattern get_splitPattern$skiko() {
            return _splitPattern;
        }

        @NotNull
        public final Pattern get_variationPattern$skiko() {
            return _variationPattern;
        }

        @NotNull
        public final FontVariation parseOne(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            Matcher m = this.get_variationPattern$skiko().matcher(s);
            if (!m.matches()) {
                boolean $i$a$-require-FontVariation$Companion$parseOne$22 = false;
                String $i$a$-require-FontVariation$Companion$parseOne$22 = "Can\u2019t parse FontVariation: " + s;
                throw new IllegalArgumentException($i$a$-require-FontVariation$Companion$parseOne$22.toString());
            }
            String string = m.group(2);
            Intrinsics.checkNotNull((Object)string);
            float value = Float.parseFloat(string);
            String string2 = m.group(1);
            Intrinsics.checkNotNull((Object)string2);
            String tag = string2;
            return new FontVariation(tag, value);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final FontVariation[] parse(@NotNull String str) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            String[] $this$map$iv = this.get_splitPattern$skiko().split(str);
            boolean $i$f$map = false;
            String[] stringArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void s;
                void item$iv$iv;
                void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.parseOne((String)s));
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new FontVariation[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

