/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.thrift.partial;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;

public final class Validate {
    private Validate() {
    }

    public static void checkNotNull(Object obj, String argName) {
        Validate.checkArgument(obj != null, "'%s' must not be null.", argName);
    }

    public static void checkPositiveInteger(long value, String argName) {
        Validate.checkArgument(value > 0L, "'%s' must be a positive integer.", argName);
    }

    public static void checkNotNegative(long value, String argName) {
        Validate.checkArgument(value >= 0L, "'%s' must not be negative.", argName);
    }

    public static void checkRequired(boolean isPresent, String argName) {
        Validate.checkArgument(isPresent, "'%s' is required.", argName);
    }

    public static void checkValid(boolean isValid, String argName) {
        Validate.checkArgument(isValid, "'%s' is invalid.", argName);
    }

    public static void checkValid(boolean isValid, String argName, String validValues) {
        Validate.checkArgument(isValid, "'%s' is invalid. Valid values are: %s.", argName, validValues);
    }

    public static void checkNotNullAndNotEmpty(String arg, String argName) {
        Validate.checkNotNull(arg, argName);
        Validate.checkArgument(arg.length() > 0, "'%s' must not be empty.", argName);
    }

    public static <T> void checkNotNullAndNotEmpty(T[] array, String argName) {
        Validate.checkNotNull(array, argName);
        Validate.checkNotEmpty(array.length, argName);
    }

    public static void checkNotNullAndNotEmpty(byte[] array, String argName) {
        Validate.checkNotNull(array, argName);
        Validate.checkNotEmpty(array.length, argName);
    }

    public static void checkNotNullAndNotEmpty(short[] array, String argName) {
        Validate.checkNotNull(array, argName);
        Validate.checkNotEmpty(array.length, argName);
    }

    public static void checkNotNullAndNotEmpty(int[] array, String argName) {
        Validate.checkNotNull(array, argName);
        Validate.checkNotEmpty(array.length, argName);
    }

    public static void checkNotNullAndNotEmpty(long[] array, String argName) {
        Validate.checkNotNull(array, argName);
        Validate.checkNotEmpty(array.length, argName);
    }

    public static <T> void checkNotNullAndNotEmpty(Iterable<T> iter, String argName) {
        Validate.checkNotNull(iter, argName);
        int minNumElements = iter.iterator().hasNext() ? 1 : 0;
        Validate.checkNotEmpty(minNumElements, argName);
    }

    public static <T> void checkNotNullAndNumberOfElements(Collection<T> collection, int numElements, String argName) {
        Validate.checkNotNull(collection, argName);
        Validate.checkArgument(collection.size() == numElements, "Number of elements in '%s' must be exactly %s, %s given.", argName, numElements, collection.size());
    }

    public static void checkValuesEqual(long value1, String value1Name, long value2, String value2Name) {
        Validate.checkArgument(value1 == value2, "'%s' (%s) must equal '%s' (%s).", value1Name, value1, value2Name, value2);
    }

    public static void checkIntegerMultiple(long value1, String value1Name, long value2, String value2Name) {
        Validate.checkArgument(value1 % value2 == 0L, "'%s' (%s) must be an integer multiple of '%s' (%s).", value1Name, value1, value2Name, value2);
    }

    public static void checkGreater(long value1, String value1Name, long value2, String value2Name) {
        Validate.checkArgument(value1 > value2, "'%s' (%s) must be greater than '%s' (%s).", value1Name, value1, value2Name, value2);
    }

    public static void checkGreaterOrEqual(long value1, String value1Name, long value2, String value2Name) {
        Validate.checkArgument(value1 >= value2, "'%s' (%s) must be greater than or equal to '%s' (%s).", value1Name, value1, value2Name, value2);
    }

    public static void checkLessOrEqual(long value1, String value1Name, long value2, String value2Name) {
        Validate.checkArgument(value1 <= value2, "'%s' (%s) must be less than or equal to '%s' (%s).", value1Name, value1, value2Name, value2);
    }

    public static void checkWithinRange(long value, String valueName, long minValueInclusive, long maxValueInclusive) {
        Validate.checkArgument(value >= minValueInclusive && value <= maxValueInclusive, "'%s' (%s) must be within the range [%s, %s].", valueName, value, minValueInclusive, maxValueInclusive);
    }

    public static void checkWithinRange(double value, String valueName, double minValueInclusive, double maxValueInclusive) {
        Validate.checkArgument(value >= minValueInclusive && value <= maxValueInclusive, "'%s' (%s) must be within the range [%s, %s].", valueName, value, minValueInclusive, maxValueInclusive);
    }

    public static void checkPathExists(Path path, String argName) {
        Validate.checkNotNull(path, argName);
        Validate.checkArgument(Files.exists(path, new LinkOption[0]), "Path %s (%s) does not exist.", argName, path);
    }

    public static void checkPathExistsAsDir(Path path, String argName) {
        Validate.checkPathExists(path, argName);
        Validate.checkArgument(Files.isDirectory(path, new LinkOption[0]), "Path %s (%s) must point to a directory.", argName, path);
    }

    public static void checkPathExistsAsFile(Path path, String argName) {
        Validate.checkPathExists(path, argName);
        Validate.checkArgument(Files.isRegularFile(path, new LinkOption[0]), "Path %s (%s) must point to a file.", argName, path);
    }

    public static void checkArgument(boolean expression, String format, Object ... args) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(format, args));
        }
    }

    private static void checkNotEmpty(int arraySize, String argName) {
        Validate.checkArgument(arraySize > 0, "'%s' must have at least one element.", argName);
    }
}

