/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.InvocationEvent;
import java.awt.peer.WindowPeer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.cef.OS;
import org.cef.misc.CefLog;
import sun.awt.AWTAccessor;

public class JdkEx {
    public static final int INVOKE_ON_EDT_TIMEOUT;
    public static final boolean INVOKE_ON_EDT_TIMEOUT_LOG;

    public static boolean isJetBrainsJDK() {
        String vendor = System.getProperty("java.vendor");
        return vendor != null && vendor.toLowerCase().contains("jetbrains");
    }

    public static void invokeOnEDTAndWait(Runnable runnable, Object source) {
        JdkEx.invokeOnEDTAndWait(() -> {
            runnable.run();
            return null;
        }, null, source);
    }

    public static <T> T invokeOnEDTAndWait(Callable<T> callable, T defaultValue, Object source) {
        SyncCallable<T> syncCallable = new SyncCallable<T>(callable, defaultValue);
        if (EventQueue.isDispatchThread()) {
            return syncCallable.call();
        }
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new InvocationEvent(source, syncCallable));
        return syncCallable.waitGet(INVOKE_ON_EDT_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    static {
        int timeout = Integer.getInteger("com.jetbrains.cef.invokeOnEdtTimeout", 200);
        INVOKE_ON_EDT_TIMEOUT = timeout > 0 ? timeout : Integer.MAX_VALUE;
        INVOKE_ON_EDT_TIMEOUT_LOG = Boolean.getBoolean("com.jetbrains.cef.invokeOnEdtTimeout.log.enabled");
    }

    private static class SyncCallable<T>
    implements Callable<T>,
    Runnable {
        volatile Callable<T> callable;
        volatile T result;
        volatile T defaultValue;
        final CountDownLatch latch = new CountDownLatch(1);

        public SyncCallable(Callable<T> callable, T defaultValue) {
            this.callable = callable;
            this.defaultValue = defaultValue;
        }

        @Override
        public void run() {
            try {
                this.result = this.callable.call();
            }
            catch (Exception e) {
                this.result = this.defaultValue;
                e.printStackTrace();
            }
            finally {
                this.latch.countDown();
            }
        }

        @Override
        public T call() {
            this.run();
            return this.get();
        }

        public T get() {
            return this.result;
        }

        public T waitGet(long timeout, TimeUnit unit) {
            try {
                if (!this.latch.await(timeout, unit)) {
                    if (INVOKE_ON_EDT_TIMEOUT_LOG) {
                        new Throwable("SyncCallable timed out").printStackTrace();
                    }
                    return this.defaultValue;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return this.get();
        }
    }

    public static class WindowHandleAccessor {
        private static final Method mGetWindowHandle;

        public static long getWindowHandle(Component comp) {
            if (comp == null) {
                return 0L;
            }
            if (!(comp instanceof Window)) {
                comp = SwingUtilities.getWindowAncestor(comp);
            }
            if (comp == null) {
                return 0L;
            }
            WindowPeer peer = (WindowPeer)AWTAccessor.getComponentAccessor().getPeer(comp);
            if (peer == null) {
                return 0L;
            }
            try {
                return (Long)mGetWindowHandle.invoke((Object)peer, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                return 0L;
            }
        }

        public static boolean isEnabled() {
            return OS.isMacintosh() && mGetWindowHandle != null;
        }

        static {
            Method m;
            try {
                m = WindowPeer.class.getDeclaredMethod("getWindowHandle", new Class[0]);
                m.setAccessible(true);
            }
            catch (Throwable ignore) {
                CefLog.Warn("failed to retrieve platform window handle", new Object[0]);
                m = null;
            }
            mGetWindowHandle = m;
        }
    }

    public static class InvokeOnToolkitHelperAccessor {
        private static final Method mInvoke;

        public static <T> T invokeAndBlock(Callable<T> callback, T defValue) {
            if (!InvokeOnToolkitHelperAccessor.isEnabled()) {
                try {
                    return callback.call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                return (T)mInvoke.invoke(null, callback);
            }
            catch (IllegalAccessException | InvocationTargetException ignore) {
                return defValue;
            }
        }

        public static boolean isEnabled() {
            return OS.isMacintosh() && mInvoke != null;
        }

        static {
            Method m = null;
            try {
                Class<?> c = Class.forName("sun.awt.InvokeOnToolkitHelper");
                m = c.getDeclaredMethod("invokeAndBlock", Callable.class);
                m.setAccessible(true);
            }
            catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
            mInvoke = m;
        }
    }
}

