/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInspection;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.execution.junit.JunitLibrarySetupKt;
import com.intellij.execution.junit.codeInspection.JUnitMixedAnnotationVisitor;
import com.intellij.lang.jvm.JvmElementVisitor;
import com.intellij.lang.jvm.inspection.JvmLocalInspection;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J&\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u0005H\u0014\u00a8\u0006\u0012"}, d2={"Lcom/intellij/execution/junit/codeInspection/JUnitMixedFrameworkInspection;", "Lcom/intellij/lang/jvm/inspection/JvmLocalInspection;", "<init>", "()V", "shouldInspect", "", "file", "Lcom/intellij/psi/PsiFile;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "Lcom/intellij/lang/jvm/JvmElementVisitor;", "project", "Lcom/intellij/openapi/project/Project;", "sink", "Lcom/intellij/lang/jvm/inspection/JvmLocalInspection$HighlightSink;", "intellij.junit"})
public final class JUnitMixedFrameworkInspection
extends JvmLocalInspection {
    private final boolean shouldInspect(PsiFile file) {
        int frameworkCount = 0;
        if (JunitLibrarySetupKt.isJUnit3InScope(file)) {
            ++frameworkCount;
        }
        if (JunitLibrarySetupKt.isJUnit4InScope(file)) {
            ++frameworkCount;
        }
        if (JunitLibrarySetupKt.isJUnit5Or6InScope(file)) {
            ++frameworkCount;
        }
        return frameworkCount > 1;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        if (!this.shouldInspect(psiFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
        Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"buildVisitor(...)");
        return psiElementVisitor;
    }

    @NotNull
    protected JvmElementVisitor<Boolean> buildVisitor(@NotNull Project project, @NotNull JvmLocalInspection.HighlightSink sink, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        return (JvmElementVisitor)new JUnitMixedAnnotationVisitor(sink);
    }
}

