/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.measure.Unit;
import org.languagetool.Tag;
import org.languagetool.rules.AbstractUnitConversionRule;
import tech.units.indriya.unit.Units;

public class UnitConversionRule
extends AbstractUnitConversionRule {
    protected NumberFormat format;

    public UnitConversionRule(ResourceBundle messages) {
        super(messages);
        this.setTags(Arrays.asList(Tag.picky));
        this.format = NumberFormat.getNumberInstance(Locale.ENGLISH);
        this.format.setMaximumFractionDigits(2);
        this.format.setRoundingMode(RoundingMode.HALF_UP);
        this.addUnit("miles per hour", MILE.divide(Units.HOUR), "miles per hour", 1.0, false);
        this.addUnit("kilograms?", (Unit)Units.KILOGRAM, "kilogram", 1.0, true);
        this.addUnit("grams?", (Unit)Units.KILOGRAM, "gram", 0.001, true);
        this.addUnit("tons?", (Unit)Units.KILOGRAM, "ton", 1000.0, true);
        this.addUnit("pounds?", POUND, "pounds", 1.0, false);
        this.addUnit("ounces?", OUNCE, "ounces", 1.0, false);
        this.addUnit("feet", FEET, "feet", 1.0, false);
        this.addUnit("miles?", MILE, "miles", 1.0, false);
        this.addUnit("yards?", YARD, "yards", 1.0, false);
        this.addUnit("inch(es)?", INCH, "inches", 1.0, false);
        this.addUnit("(?:degrees?)? Fahrenheit", FAHRENHEIT, "degree Fahrenheit", 1.0, false);
        this.addUnit("(?:degrees?)? Celsius", (Unit)Units.CELSIUS, "degree Celsius", 1.0, true);
    }

    public String getId() {
        return "METRIC_UNITS_EN_GENERAL";
    }

    public String getDescription() {
        return "Suggests or checks conversion of units to their metric equivalents.";
    }

    protected NumberFormat getNumberFormat() {
        return this.format;
    }
}

