/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.remotedriver;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a2\u0010\u0000\u001a\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u001a\u000e\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006\u00a8\u0006\u000f"}, d2={"waitFor", "", "duration", "Ljava/time/Duration;", "interval", "errorMessage", "", "condition", "Lkotlin/Function0;", "", "sanitizeXmlContent", "node", "Lorg/w3c/dom/Node;", "sanitizeXmlChars", "xml", "intellij.performanceTesting.remoteDriver"})
@SourceDebugExtension(value={"SMAP\nRobotUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RobotUtils.kt\ncom/jetbrains/performancePlugin/remotedriver/RobotUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1617#2,9:53\n1869#2:62\n1870#2:64\n1626#2:65\n1869#2,2:66\n1617#2,9:68\n1869#2:77\n1870#2:79\n1626#2:80\n1869#2,2:81\n1#3:63\n1#3:78\n*S KotlinDebug\n*F\n+ 1 RobotUtils.kt\ncom/jetbrains/performancePlugin/remotedriver/RobotUtilsKt\n*L\n33#1:53,9\n33#1:62\n33#1:64\n33#1:65\n34#1:66,2\n41#1:68,9\n41#1:77\n41#1:79\n41#1:80\n42#1:81,2\n33#1:63\n41#1:78\n*E\n"})
public final class RobotUtilsKt {
    public static final void waitFor(@NotNull Duration duration, @NotNull Duration interval, @NotNull String errorMessage, @NotNull Function0<Boolean> condition) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        long endTime = System.currentTimeMillis() + duration.toMillis();
        long now = System.currentTimeMillis();
        while (now < endTime && !((Boolean)condition.invoke()).booleanValue()) {
            Thread.sleep(interval.toMillis());
            now = System.currentTimeMillis();
        }
        if (!((Boolean)condition.invoke()).booleanValue()) {
            throw new IllegalStateException("Timeout(" + duration + "): " + errorMessage);
        }
    }

    public static /* synthetic */ void waitFor$default(Duration duration, Duration duration2, String string, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            Duration duration3 = Duration.ofSeconds(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofSeconds(...)");
            duration = duration3;
        }
        if ((n & 2) != 0) {
            Duration duration4 = Duration.ofSeconds(2L);
            Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"ofSeconds(...)");
            duration2 = duration4;
        }
        if ((n & 4) != 0) {
            string = "";
        }
        RobotUtilsKt.waitFor(duration, duration2, string, (Function0<Boolean>)function0);
    }

    /*
     * WARNING - void declaration
     */
    public static final void sanitizeXmlContent(@NotNull Node node) {
        void $this$mapNotNullTo$iv$iv;
        Object attrs;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            void $this$forEach$iv;
            Iterator $this$mapNotNullTo$iv$iv2;
            attrs = namedNodeMap;
            boolean bl = false;
            Iterable $this$mapNotNull$iv = (Iterable)new IntRange(0, attrs.getLength());
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Node it$iv$iv;
                int element$iv$iv$iv;
                int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator2).nextInt();
                boolean bl2 = false;
                int it = element$iv$iv;
                boolean bl3 = false;
                if (attrs.item(it) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                Node it = (Node)element$iv;
                boolean bl5 = false;
                String string = it.getTextContent();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextContent(...)");
                it.setTextContent(RobotUtilsKt.sanitizeXmlChars(string));
            }
        }
        if (node instanceof Text) {
            Text text = (Text)node;
            String string = ((Text)node).getTextContent();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextContent(...)");
            text.setTextContent(RobotUtilsKt.sanitizeXmlChars(string));
        }
        Iterable $this$mapNotNull$iv = (Iterable)new IntRange(0, node.getChildNodes().getLength());
        boolean $i$f$mapNotNull = false;
        attrs = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
        while (iterator3.hasNext()) {
            Node it$iv$iv;
            int element$iv$iv$iv;
            int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator3).nextInt();
            boolean bl = false;
            int it = element$iv$iv;
            boolean bl6 = false;
            if (node.getChildNodes().item(it) == null) continue;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it = (Node)element$iv;
            boolean bl = false;
            RobotUtilsKt.sanitizeXmlContent(it);
        }
    }

    @NotNull
    public static final String sanitizeXmlChars(@NotNull String xml) {
        Intrinsics.checkNotNullParameter((Object)xml, (String)"xml");
        if (((CharSequence)xml).length() == 0) {
            return "";
        }
        Regex xmlInvalidChars = new Regex("[^\\u0009\\u000A\\u000D\\u0020-\\uD7FF\\uE000-\\uFFFD\\x{10000}-\\x{10FFFF}]");
        return xmlInvalidChars.replace((CharSequence)xml, "");
    }
}

