/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.THash;
import gnu.trove.TIntHashingStrategy;
import gnu.trove.TIntObjectIterator;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TIntProcedure;
import gnu.trove.TObjectFunction;
import gnu.trove.TObjectHash;
import gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Objects;

@Deprecated
public class TIntObjectHashMap<V>
extends THash
implements TIntHashingStrategy {
    protected transient V[] _values;
    transient int[] _set;
    private final TIntHashingStrategy _hashingStrategy;

    public TIntObjectHashMap() {
        this._hashingStrategy = this;
    }

    public TIntObjectHashMap(int initialCapacity) {
        super(initialCapacity);
        this._hashingStrategy = this;
    }

    public TIntObjectHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = this;
    }

    public TIntObjectHashMap(TIntHashingStrategy strategy) {
        this._hashingStrategy = strategy;
    }

    public TIntObjectHashMap(int initialCapacity, TIntHashingStrategy strategy) {
        super(initialCapacity);
        this._hashingStrategy = strategy;
    }

    public TIntObjectHashMap(int initialCapacity, float loadFactor, TIntHashingStrategy strategy) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = strategy;
    }

    @Override
    public TIntObjectHashMap<V> clone() {
        TIntObjectHashMap m = (TIntObjectHashMap)super.clone();
        m._values = this._values == EMPTY_OBJECT_ARRAY ? EMPTY_OBJECT_ARRAY : (Object[])this._values.clone();
        m._set = this._values == EMPTY_OBJECT_ARRAY ? null : (int[])this._set.clone();
        return m;
    }

    public TIntObjectIterator<V> iterator() {
        return new TIntObjectIterator(this);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = initialCapacity == -1 ? EMPTY_OBJECT_ARRAY : new Object[capacity];
        this._set = initialCapacity == -1 ? null : new int[capacity];
        return capacity;
    }

    public boolean contains(int val) {
        return this.index(val) >= 0;
    }

    @Override
    protected int capacity() {
        return this._values.length;
    }

    public boolean forEach(TIntProcedure procedure) {
        int[] set = this._set;
        Object[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (!TIntObjectHashMap.isFull(values, i) || procedure.execute(set[i])) continue;
            return false;
        }
        return true;
    }

    public V put(int key, V value) {
        boolean wasFree = false;
        V previous = null;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = TIntObjectHashMap.unwrapNull(this._values[index]);
            isNewMapping = false;
        } else {
            wasFree = TIntObjectHashMap.isFree(this._values, index);
        }
        this._set[index] = key;
        this._values[index] = TIntObjectHashMap.wrapNull(value);
        if (isNewMapping) {
            this.postInsertHook(wasFree);
        }
        return previous;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        int[] oldKeys = this._set;
        Object[] oldVals = this._values;
        this._set = new int[newCapacity];
        this._values = new Object[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (!TIntObjectHashMap.isFull(oldVals, i)) continue;
            int o = oldKeys[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._values[index] = oldVals[i];
        }
    }

    public V get(int key) {
        int index = this.index(key);
        return index < 0 ? null : (V)TIntObjectHashMap.unwrapNull(this._values[index]);
    }

    private static <V> V unwrapNull(V value) {
        return value == TObjectHash.NULL ? null : (V)value;
    }

    private static <V> V wrapNull(V value) {
        return (V)(value == null ? TObjectHash.NULL : value);
    }

    @Override
    public void clear() {
        super.clear();
        int[] keys = this._set;
        V[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            keys[i] = 0;
            values[i] = null;
        }
    }

    public V remove(int key) {
        V prev = null;
        int index = this.index(key);
        if (index >= 0) {
            prev = TIntObjectHashMap.unwrapNull(this._values[index]);
            this.removeAt(index);
        }
        return prev;
    }

    protected int index(int val) {
        int[] set = this._set;
        Object[] values = this._values;
        if (values == EMPTY_OBJECT_ARRAY) {
            return -1;
        }
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (!TIntObjectHashMap.isFree(values, index) && (TIntObjectHashMap.isRemoved(values, index) || set[index] != val)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (!TIntObjectHashMap.isFree(values, index) && (TIntObjectHashMap.isRemoved(values, index) || set[index] != val));
        }
        return TIntObjectHashMap.isFree(values, index) ? -1 : index;
    }

    private int insertionIndex(int val) {
        int firstRemoved;
        if (this._values == EMPTY_OBJECT_ARRAY) {
            this.setUp(6);
        }
        Object[] values = this._values;
        int[] set = this._set;
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (TIntObjectHashMap.isFree(values, index)) {
            return index;
        }
        if (TIntObjectHashMap.isFull(values, index) && set[index] == val) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        int n = firstRemoved = TIntObjectHashMap.isRemoved(values, index) ? index : -1;
        do {
            if ((index -= probe) < 0) {
                index += length;
            }
            if (firstRemoved != -1 || !TIntObjectHashMap.isRemoved(values, index)) continue;
            firstRemoved = index;
        } while (TIntObjectHashMap.isFull(values, index) && set[index] != val);
        if (TIntObjectHashMap.isRemoved(values, index)) {
            while (!TIntObjectHashMap.isFree(values, index) && (TIntObjectHashMap.isRemoved(values, index) || set[index] != val)) {
                if ((index -= probe) >= 0) continue;
                index += length;
            }
        }
        if (TIntObjectHashMap.isFull(values, index)) {
            return -index - 1;
        }
        return firstRemoved == -1 ? index : firstRemoved;
    }

    static boolean isFull(Object[] values, int index) {
        Object value = values[index];
        return value != null && value != TObjectHash.REMOVED;
    }

    private static boolean isRemoved(Object[] values, int index) {
        return values[index] == TObjectHash.REMOVED;
    }

    private static boolean isFree(Object[] values, int index) {
        return values[index] == null;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TIntObjectHashMap)) {
            return false;
        }
        TIntObjectHashMap that = (TIntObjectHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    @Override
    protected void removeAt(int index) {
        this._values[index] = TObjectHash.REMOVED;
        super.removeAt(index);
    }

    public Object[] getValues() {
        Object[] vals = new Object[this.size()];
        Object[] values = this._values;
        int i = values.length;
        int j = 0;
        while (i-- > 0) {
            if (!TIntObjectHashMap.isFull(values, i)) continue;
            vals[j++] = TIntObjectHashMap.unwrapNull(values[i]);
        }
        return vals;
    }

    public int[] keys() {
        int[] keys = new int[this.size()];
        int[] k = this._set;
        Object[] values = this._values;
        int i = values.length;
        int j = 0;
        while (i-- > 0) {
            if (!TIntObjectHashMap.isFull(values, i)) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    public boolean containsValue(V val) {
        Object[] values = this._values;
        if (null == val) {
            int i = values.length;
            while (i-- > 0) {
                if (TObjectHash.NULL != values[i]) continue;
                return true;
            }
        } else {
            int i = values.length;
            while (i-- > 0) {
                V value = TIntObjectHashMap.unwrapNull(values[i]);
                if (!TIntObjectHashMap.isFull(values, i) || val != value && !val.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(int key) {
        return this.contains(key);
    }

    public boolean forEachValue(TObjectProcedure<V> procedure) {
        Object[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (!TIntObjectHashMap.isFull(values, i) || procedure.execute(TIntObjectHashMap.unwrapNull(values[i]))) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TIntObjectProcedure<V> procedure) {
        int[] keys = this._set;
        Object[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (!TIntObjectHashMap.isFull(values, i) || procedure.execute(keys[i], TIntObjectHashMap.unwrapNull(values[i]))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainEntries(TIntObjectProcedure<V> procedure) {
        boolean modified = false;
        int[] keys = this._set;
        Object[] values = this._values;
        this.stopCompactingOnRemove();
        try {
            int i = values.length;
            while (i-- > 0) {
                if (!TIntObjectHashMap.isFull(values, i) || procedure.execute(keys[i], TIntObjectHashMap.unwrapNull(values[i]))) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        finally {
            this.startCompactingOnRemove(modified);
        }
        return modified;
    }

    public void transformValues(TObjectFunction<V, V> function) {
        Object[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (!TIntObjectHashMap.isFull(values, i)) continue;
            values[i] = TIntObjectHashMap.wrapNull(function.execute(TIntObjectHashMap.unwrapNull(values[i])));
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            int key = stream.readInt();
            Object val = stream.readObject();
            this.put(key, val);
        }
    }

    @Override
    public final int computeHashCode(int val) {
        return HashFunctions.hash(val);
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEachEntry(new TIntObjectProcedure<V>(){

            @Override
            public boolean execute(int key, V value) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(key);
                sb.append('=');
                sb.append((Object)(value == this ? "(this Map)" : value));
                return true;
            }
        });
        sb.append('}');
        sb.insert(0, '{');
        return sb.toString();
    }

    private static final class EqProcedure<V>
    implements TIntObjectProcedure<V> {
        private final TIntObjectHashMap<V> _otherMap;

        EqProcedure(TIntObjectHashMap<V> otherMap) {
            this._otherMap = otherMap;
        }

        @Override
        public boolean execute(int key, V value) {
            int index = this._otherMap.index(key);
            return index >= 0 && EqProcedure.eq(value, this._otherMap.get(key));
        }

        private static boolean eq(Object o1, Object o2) {
            return Objects.equals(o1, o2);
        }
    }

    private final class HashProcedure
    implements TIntObjectProcedure<V> {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public boolean execute(int key, V value) {
            this.h += TIntObjectHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }
    }
}

