/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.files;

import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.model.notifications.NotificationTypeReference;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradlePropertiesFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleVersionCatalogFile;
import com.google.common.base.Charsets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleDslFileCache {
    @NotNull
    private final Project myProject;
    @NotNull
    private final List<GradleDslFile> myParsedDslFiles;
    @NotNull
    private final Map<String, GradleBuildFile> myParsedBuildFiles;
    @NotNull
    private final Map<String, GradleSettingsFile> myParsedSettingsFiles;
    @NotNull
    private final Map<String, GradlePropertiesFile> myParsedPropertiesFiles;
    @NotNull
    private final Map<String, GradleVersionCatalogFile> myParsedVersionCatalogFiles;
    @NotNull
    private Deque<VirtualFile> myParsingStack;

    public GradleDslFileCache(@NotNull Project project) {
        if (project == null) {
            GradleDslFileCache.$$$reportNull$$$0(0);
        }
        this.myParsedDslFiles = new ArrayList<GradleDslFile>();
        this.myParsedBuildFiles = new LinkedHashMap<String, GradleBuildFile>();
        this.myParsedSettingsFiles = new LinkedHashMap<String, GradleSettingsFile>();
        this.myParsedPropertiesFiles = new LinkedHashMap<String, GradlePropertiesFile>();
        this.myParsedVersionCatalogFiles = new LinkedHashMap<String, GradleVersionCatalogFile>();
        this.myParsingStack = new ArrayDeque<VirtualFile>();
        this.myProject = project;
    }

    public void clearAllFiles() {
        this.myParsedBuildFiles.clear();
    }

    @NotNull
    public GradleBuildFile getOrCreateBuildFile(@NotNull VirtualFile file, @NotNull String name2, @NotNull BuildModelContext context, boolean isApplied) {
        GradleBuildFile dslFile;
        if (file == null) {
            GradleDslFileCache.$$$reportNull$$$0(1);
        }
        if (name2 == null) {
            GradleDslFileCache.$$$reportNull$$$0(2);
        }
        if (context == null) {
            GradleDslFileCache.$$$reportNull$$$0(3);
        }
        if ((dslFile = this.myParsedBuildFiles.get(file.getUrl())) == null) {
            if (!this.myParsingStack.contains(file)) {
                this.myParsingStack.push(file);
                dslFile = context.parseBuildFile(this.myProject, file, name2, isApplied);
                this.myParsingStack.pop();
                this.myParsedBuildFiles.put(file.getUrl(), dslFile);
                this.myParsedDslFiles.add(dslFile);
            } else {
                dslFile = new GradleBuildFile(file, this.myProject, name2, context);
                dslFile.notification(NotificationTypeReference.CIRCULAR_APPLICATION);
            }
        }
        GradleBuildFile gradleBuildFile = dslFile;
        if (gradleBuildFile == null) {
            GradleDslFileCache.$$$reportNull$$$0(4);
        }
        return gradleBuildFile;
    }

    public void putBuildFile(@NotNull String name2, @NotNull GradleBuildFile buildFile) {
        if (name2 == null) {
            GradleDslFileCache.$$$reportNull$$$0(5);
        }
        if (buildFile == null) {
            GradleDslFileCache.$$$reportNull$$$0(6);
        }
        this.myParsedBuildFiles.put(name2, buildFile);
        this.myParsedDslFiles.add(buildFile);
    }

    @Nullable
    public VirtualFile getCurrentParsingRoot() {
        return this.myParsingStack.isEmpty() ? null : this.myParsingStack.getLast();
    }

    @NotNull
    public GradleSettingsFile getOrCreateSettingsFile(@NotNull VirtualFile settingsFile, @NotNull BuildModelContext context) {
        GradleSettingsFile dslFile;
        if (settingsFile == null) {
            GradleDslFileCache.$$$reportNull$$$0(7);
        }
        if (context == null) {
            GradleDslFileCache.$$$reportNull$$$0(8);
        }
        if ((dslFile = this.myParsedSettingsFiles.get(settingsFile.getUrl())) == null) {
            dslFile = new GradleSettingsFile(settingsFile, this.myProject, "settings", context);
            dslFile.parse();
            this.myParsedSettingsFiles.put(settingsFile.getUrl(), dslFile);
            this.myParsedDslFiles.add(dslFile);
        }
        GradleSettingsFile gradleSettingsFile = dslFile;
        if (gradleSettingsFile == null) {
            GradleDslFileCache.$$$reportNull$$$0(9);
        }
        return gradleSettingsFile;
    }

    @Nullable
    public GradlePropertiesFile getOrCreatePropertiesFile(@NotNull VirtualFile file, @NotNull String moduleName, @NotNull BuildModelContext context) {
        GradlePropertiesFile dslFile;
        if (file == null) {
            GradleDslFileCache.$$$reportNull$$$0(10);
        }
        if (moduleName == null) {
            GradleDslFileCache.$$$reportNull$$$0(11);
        }
        if (context == null) {
            GradleDslFileCache.$$$reportNull$$$0(12);
        }
        if ((dslFile = this.myParsedPropertiesFiles.get(file.getUrl())) == null) {
            try {
                Properties properties = GradleDslFileCache.getProperties(file);
                dslFile = new GradlePropertiesFile(properties, file, this.myProject, moduleName, context);
                this.myParsedPropertiesFiles.put(file.getUrl(), dslFile);
                this.myParsedDslFiles.add(dslFile);
            }
            catch (IOException e) {
                Logger.getInstance(GradleDslFileCache.class).warn("Failed to process properties file " + file.getPath(), (Throwable)e);
                return null;
            }
        }
        return dslFile;
    }

    private static Properties getProperties(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            GradleDslFileCache.$$$reportNull$$$0(13);
        }
        Properties properties = new Properties();
        try (InputStreamReader reader = new InputStreamReader(file.getInputStream(), Charsets.UTF_8);){
            properties.load(reader);
        }
        return properties;
    }

    @NotNull
    public GradleVersionCatalogFile getOrCreateVersionCatalogFile(@NotNull VirtualFile file, @NotNull String catalogName, @NotNull BuildModelContext context) {
        GradleVersionCatalogFile dslFile;
        if (file == null) {
            GradleDslFileCache.$$$reportNull$$$0(14);
        }
        if (catalogName == null) {
            GradleDslFileCache.$$$reportNull$$$0(15);
        }
        if (context == null) {
            GradleDslFileCache.$$$reportNull$$$0(16);
        }
        if ((dslFile = this.myParsedVersionCatalogFiles.get(file.getUrl())) == null) {
            dslFile = new GradleVersionCatalogFile(file, this.myProject, "versionCatalog", catalogName, context);
            dslFile.parse();
            this.myParsedVersionCatalogFiles.put(file.getUrl(), dslFile);
            this.myParsedDslFiles.add(dslFile);
        }
        GradleVersionCatalogFile gradleVersionCatalogFile = dslFile;
        if (gradleVersionCatalogFile == null) {
            GradleDslFileCache.$$$reportNull$$$0(17);
        }
        return gradleVersionCatalogFile;
    }

    @NotNull
    public List<GradleDslFile> getAllFiles() {
        List<GradleDslFile> list = this.myParsedDslFiles;
        if (list == null) {
            GradleDslFileCache.$$$reportNull$$$0(18);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 9, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 8: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 9: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/files/GradleDslFileCache";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catalogName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/files/GradleDslFileCache";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateBuildFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateSettingsFile";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateVersionCatalogFile";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateBuildFile";
                break;
            }
            case 4: 
            case 9: 
            case 17: 
            case 18: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "putBuildFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateSettingsFile";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreatePropertiesFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateVersionCatalogFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 9, 17, 18 -> new IllegalStateException(string);
        };
    }
}

