/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.embedder;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.model.Model;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.apache.maven.project.interpolation.StringSearchModelInterpolator;
import org.apache.maven.project.path.DefaultPathTranslator;
import org.apache.maven.project.path.PathTranslator;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.ValueSource;

public class CustomMaven3ModelInterpolator
extends StringSearchModelInterpolator {
    public CustomMaven3ModelInterpolator() {
    }

    public CustomMaven3ModelInterpolator(DefaultPathTranslator pathTranslator) {
        super((PathTranslator)pathTranslator);
    }

    public Model interpolate(Model model, File projectDir, ProjectBuilderConfiguration config, boolean debugEnabled) throws ModelInterpolationException {
        this.interpolateObject(new Object[]{model.getParent(), model}, model, projectDir, config, debugEnabled);
        return model;
    }

    protected List<ValueSource> createValueSources(Model model, File projectDir, ProjectBuilderConfiguration config) {
        List sources = super.createValueSources(model, projectDir, config);
        int firstMapIndex = -1;
        for (int i = 0; i < sources.size(); ++i) {
            if (!(sources.get(i) instanceof MapBasedValueSource)) continue;
            firstMapIndex = i;
            break;
        }
        HashMap<String, String> rightOrderProperties = new HashMap<String, String>(3);
        if (config.getExecutionProperties().containsKey("revision")) {
            rightOrderProperties.put("revision", config.getExecutionProperties().getProperty("revision"));
        }
        if (config.getExecutionProperties().containsKey("changelist")) {
            rightOrderProperties.put("changelist", config.getExecutionProperties().getProperty("changelist"));
        }
        if (config.getExecutionProperties().containsKey("sha1")) {
            rightOrderProperties.put("sha1", config.getExecutionProperties().getProperty("sha1"));
        }
        sources.add(firstMapIndex + 1, new MapBasedValueSource(rightOrderProperties));
        return sources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void interpolateObject(Object obj, Model model, File projectDir, ProjectBuilderConfiguration config, boolean debugEnabled) throws ModelInterpolationException {
        if (obj == null) {
            return;
        }
        Class<CustomMaven3ModelInterpolator> clazz = CustomMaven3ModelInterpolator.class;
        synchronized (CustomMaven3ModelInterpolator.class) {
            try {
                super.interpolateObject(obj, model, projectDir, config, debugEnabled);
            }
            catch (NullPointerException e) {
                throw new ModelInterpolationException("Cannot interpolate", (Throwable)e);
            }
            return;
        }
    }
}

