/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.schema;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.full.KTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.columns.ColumnKind;
import org.jetbrains.kotlinx.dataframe.schema.CompareResult;
import org.jetbrains.kotlinx.dataframe.schema.CompareResultKt;
import org.jetbrains.kotlinx.dataframe.schema.ComparisonMode;
import org.jetbrains.kotlinx.dataframe.schema.DataFrameSchema;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u001a\u001b\u001cB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0012\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u0004\u0018\u00010\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\u0082\u0001\u0003\u001d\u001e\u001f\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlinx/dataframe/schema/ColumnSchema;", "", "<init>", "()V", "kind", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnKind;", "getKind", "()Lorg/jetbrains/kotlinx/dataframe/columns/ColumnKind;", "nullable", "", "getNullable", "()Z", "type", "Lkotlin/reflect/KType;", "getType", "()Lkotlin/reflect/KType;", "contentType", "getContentType", "equals", "other", "compare", "Lorg/jetbrains/kotlinx/dataframe/schema/CompareResult;", "comparisonMode", "Lorg/jetbrains/kotlinx/dataframe/schema/ComparisonMode;", "hashCode", "", "Value", "Group", "Frame", "Lorg/jetbrains/kotlinx/dataframe/schema/ColumnSchema$Frame;", "Lorg/jetbrains/kotlinx/dataframe/schema/ColumnSchema$Group;", "Lorg/jetbrains/kotlinx/dataframe/schema/ColumnSchema$Value;", "core"})
public abstract class ColumnSchema {
    private ColumnSchema() {
    }

    @NotNull
    public abstract ColumnKind getKind();

    public abstract boolean getNullable();

    @NotNull
    public abstract KType getType();

    @Nullable
    public abstract KType getContentType();

    public boolean equals(@Nullable Object other) {
        boolean bl;
        ColumnSchema columnSchema = other instanceof ColumnSchema ? (ColumnSchema)other : null;
        if (columnSchema == null) {
            return false;
        }
        ColumnSchema otherType = columnSchema;
        if (otherType.getKind() != this.getKind()) {
            return false;
        }
        if (otherType.getNullable() != this.getNullable()) {
            return false;
        }
        ColumnSchema columnSchema2 = this;
        if (columnSchema2 instanceof Value) {
            bl = Intrinsics.areEqual((Object)((Value)this).getType(), (Object)((Value)otherType).getType());
        } else if (columnSchema2 instanceof Group) {
            bl = Intrinsics.areEqual((Object)((Group)this).getSchema(), (Object)((Group)otherType).getSchema());
        } else if (columnSchema2 instanceof Frame) {
            bl = Intrinsics.areEqual((Object)((Frame)this).getSchema(), (Object)((Frame)otherType).getSchema());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @NotNull
    public final CompareResult compare(@NotNull ColumnSchema other, @NotNull ComparisonMode comparisonMode) {
        CompareResult compareResult;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)((Object)comparisonMode), (String)"comparisonMode");
        if (this.getKind() != other.getKind()) {
            return CompareResult.None;
        }
        if (this == other) {
            return CompareResult.Equals;
        }
        ColumnSchema columnSchema = this;
        if (columnSchema instanceof Value) {
            compareResult = ((Value)this).compare((Value)other, comparisonMode);
        } else if (columnSchema instanceof Group) {
            compareResult = ((Group)this).compare((Group)other, comparisonMode);
        } else if (columnSchema instanceof Frame) {
            compareResult = ((Frame)this).compare((Frame)other, comparisonMode);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return compareResult;
    }

    public static /* synthetic */ CompareResult compare$default(ColumnSchema columnSchema, ColumnSchema columnSchema2, ComparisonMode comparisonMode, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: compare");
        }
        if ((n & 2) != 0) {
            comparisonMode = ComparisonMode.LENIENT;
        }
        return columnSchema.compare(columnSchema2, comparisonMode);
    }

    public int hashCode() {
        int n;
        int result = Boolean.hashCode(this.getNullable());
        result = 31 * result + this.getKind().hashCode();
        ColumnSchema columnSchema = this;
        if (columnSchema instanceof Value) {
            n = ((Value)this).getType().hashCode();
        } else if (columnSchema instanceof Group) {
            n = ((Group)this).getSchema().hashCode();
        } else if (columnSchema instanceof Frame) {
            n = ((Frame)this).getSchema().hashCode();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        result = 31 * result + n;
        return result;
    }

    public /* synthetic */ ColumnSchema(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlinx/dataframe/schema/ColumnSchema$Frame;", "Lorg/jetbrains/kotlinx/dataframe/schema/ColumnSchema;", "schema", "Lorg/jetbrains/kotlinx/dataframe/schema/DataFrameSchema;", "nullable", "", "contentType", "Lkotlin/reflect/KType;", "<init>", "(Lorg/jetbrains/kotlinx/dataframe/schema/DataFrameSchema;ZLkotlin/reflect/KType;)V", "getSchema", "()Lorg/jetbrains/kotlinx/dataframe/schema/DataFrameSchema;", "getNullable", "()Z", "getContentType", "()Lkotlin/reflect/KType;", "kind", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnKind;", "getKind", "()Lorg/jetbrains/kotlinx/dataframe/columns/ColumnKind;", "type", "getType", "compare", "Lorg/jetbrains/kotlinx/dataframe/schema/CompareResult;", "other", "comparisonMode", "Lorg/jetbrains/kotlinx/dataframe/schema/ComparisonMode;", "core"})
    public static final class Frame
    extends ColumnSchema {
        @NotNull
        private final DataFrameSchema schema;
        private final boolean nullable;
        @Nullable
        private final KType contentType;
        @NotNull
        private final ColumnKind kind;

        public Frame(@NotNull DataFrameSchema schema, boolean nullable, @Nullable KType contentType) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super(null);
            this.schema = schema;
            this.nullable = nullable;
            this.contentType = contentType;
            this.kind = ColumnKind.Frame;
        }

        @NotNull
        public final DataFrameSchema getSchema() {
            return this.schema;
        }

        @Override
        public boolean getNullable() {
            return this.nullable;
        }

        @Override
        @Nullable
        public KType getContentType() {
            return this.contentType;
        }

        @Override
        @NotNull
        public ColumnKind getKind() {
            return this.kind;
        }

        @Override
        @NotNull
        public KType getType() {
            return Reflection.typeOf(DataFrame.class, (KTypeProjection)KTypeProjection.Companion.getSTAR());
        }

        @NotNull
        public final CompareResult compare(@NotNull Frame other, @NotNull ComparisonMode comparisonMode) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            Intrinsics.checkNotNullParameter((Object)((Object)comparisonMode), (String)"comparisonMode");
            return CompareResultKt.plus(this.schema.compare(other.schema, comparisonMode), CompareResult.Companion.compareNullability(this.getNullable(), other.getNullable()));
        }

        public static /* synthetic */ CompareResult compare$default(Frame frame, Frame frame2, ComparisonMode comparisonMode, int n, Object object) {
            if ((n & 2) != 0) {
                comparisonMode = ComparisonMode.LENIENT;
            }
            return frame.compare(frame2, comparisonMode);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlinx/dataframe/schema/ColumnSchema$Group;", "Lorg/jetbrains/kotlinx/dataframe/schema/ColumnSchema;", "schema", "Lorg/jetbrains/kotlinx/dataframe/schema/DataFrameSchema;", "contentType", "Lkotlin/reflect/KType;", "<init>", "(Lorg/jetbrains/kotlinx/dataframe/schema/DataFrameSchema;Lkotlin/reflect/KType;)V", "getSchema", "()Lorg/jetbrains/kotlinx/dataframe/schema/DataFrameSchema;", "getContentType", "()Lkotlin/reflect/KType;", "kind", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnKind;", "getKind", "()Lorg/jetbrains/kotlinx/dataframe/columns/ColumnKind;", "nullable", "", "getNullable", "()Z", "type", "getType", "compare", "Lorg/jetbrains/kotlinx/dataframe/schema/CompareResult;", "other", "comparisonMode", "Lorg/jetbrains/kotlinx/dataframe/schema/ComparisonMode;", "core"})
    public static final class Group
    extends ColumnSchema {
        @NotNull
        private final DataFrameSchema schema;
        @Nullable
        private final KType contentType;
        @NotNull
        private final ColumnKind kind;
        private final boolean nullable;

        public Group(@NotNull DataFrameSchema schema, @Nullable KType contentType) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super(null);
            this.schema = schema;
            this.contentType = contentType;
            this.kind = ColumnKind.Group;
        }

        @NotNull
        public final DataFrameSchema getSchema() {
            return this.schema;
        }

        @Override
        @Nullable
        public KType getContentType() {
            return this.contentType;
        }

        @Override
        @NotNull
        public ColumnKind getKind() {
            return this.kind;
        }

        @Override
        public boolean getNullable() {
            return this.nullable;
        }

        @Override
        @NotNull
        public KType getType() {
            return Reflection.typeOf(DataRow.class, (KTypeProjection)KTypeProjection.Companion.getSTAR());
        }

        @NotNull
        public final CompareResult compare(@NotNull Group other, @NotNull ComparisonMode comparisonMode) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            Intrinsics.checkNotNullParameter((Object)((Object)comparisonMode), (String)"comparisonMode");
            return this.schema.compare(other.schema, comparisonMode);
        }

        public static /* synthetic */ CompareResult compare$default(Group group, Group group2, ComparisonMode comparisonMode, int n, Object object) {
            if ((n & 2) != 0) {
                comparisonMode = ComparisonMode.LENIENT;
            }
            return group.compare(group2, comparisonMode);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0015\u001a\u00020\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlinx/dataframe/schema/ColumnSchema$Value;", "Lorg/jetbrains/kotlinx/dataframe/schema/ColumnSchema;", "type", "Lkotlin/reflect/KType;", "<init>", "(Lkotlin/reflect/KType;)V", "getType", "()Lkotlin/reflect/KType;", "kind", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnKind;", "getKind", "()Lorg/jetbrains/kotlinx/dataframe/columns/ColumnKind;", "nullable", "", "getNullable", "()Z", "contentType", "getContentType", "compare", "Lorg/jetbrains/kotlinx/dataframe/schema/CompareResult;", "other", "comparisonMode", "Lorg/jetbrains/kotlinx/dataframe/schema/ComparisonMode;", "core"})
    public static final class Value
    extends ColumnSchema {
        @NotNull
        private final KType type;
        @NotNull
        private final ColumnKind kind;
        private final boolean nullable;
        @Nullable
        private final KType contentType;

        public Value(@NotNull KType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            super(null);
            this.type = type;
            this.kind = ColumnKind.Value;
            this.nullable = this.getType().isMarkedNullable();
        }

        @Override
        @NotNull
        public KType getType() {
            return this.type;
        }

        @Override
        @NotNull
        public ColumnKind getKind() {
            return this.kind;
        }

        @Override
        public boolean getNullable() {
            return this.nullable;
        }

        @Override
        @Nullable
        public KType getContentType() {
            return this.contentType;
        }

        @NotNull
        public final CompareResult compare(@NotNull Value other, @NotNull ComparisonMode comparisonMode) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            Intrinsics.checkNotNullParameter((Object)((Object)comparisonMode), (String)"comparisonMode");
            return Intrinsics.areEqual((Object)this.getType(), (Object)other.getType()) ? CompareResult.Equals : (comparisonMode == ComparisonMode.STRICT ? CompareResult.None : (KTypes.isSubtypeOf((KType)this.getType(), (KType)other.getType()) ? CompareResult.IsDerived : (KTypes.isSupertypeOf((KType)this.getType(), (KType)other.getType()) ? CompareResult.IsSuper : CompareResult.None)));
        }

        public static /* synthetic */ CompareResult compare$default(Value value, Value value2, ComparisonMode comparisonMode, int n, Object object) {
            if ((n & 2) != 0) {
                comparisonMode = ComparisonMode.LENIENT;
            }
            return value.compare(value2, comparisonMode);
        }
    }
}

