/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.codeGen;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.ColumnsContainer;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.codeGen.BaseField;
import org.jetbrains.kotlinx.dataframe.codeGen.FieldType;
import org.jetbrains.kotlinx.dataframe.columns.ColumnGroup;
import org.jetbrains.kotlinx.dataframe.impl.codeGen.CodeGeneratorImplKt;
import org.jetbrains.kotlinx.dataframe.impl.codeGen.TypeRenderingStrategy;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\r\u001a\u00060\u0005j\u0002`\u000e*\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00060\u0005j\u0002`\u000e*\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00060\u0005j\u0002`\u000e*\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/codeGen/FullyQualifiedNames;", "Lorg/jetbrains/kotlinx/dataframe/impl/codeGen/TypeRenderingStrategy;", "<init>", "()V", "dataRow", "", "columnsContainer", "dataFrame", "dataColumn", "columnGroup", "renderRowTypeName", "markerName", "renderColumnsContainerTypeName", "renderColumnType", "Lorg/jetbrains/kotlinx/dataframe/codeGen/Code;", "Lorg/jetbrains/kotlinx/dataframe/codeGen/BaseField;", "renderAccessorFieldType", "renderFieldType", "core"})
public final class FullyQualifiedNames
implements TypeRenderingStrategy {
    @NotNull
    public static final FullyQualifiedNames INSTANCE = new FullyQualifiedNames();
    @NotNull
    private static final String dataRow;
    @NotNull
    private static final String columnsContainer;
    @NotNull
    private static final String dataFrame;
    @NotNull
    private static final String dataColumn;
    @NotNull
    private static final String columnGroup;

    private FullyQualifiedNames() {
    }

    @Override
    @NotNull
    public String renderRowTypeName(@NotNull String markerName) {
        Intrinsics.checkNotNullParameter((Object)markerName, (String)"markerName");
        return dataRow + '<' + markerName + '>';
    }

    @Override
    @NotNull
    public String renderColumnsContainerTypeName(@NotNull String markerName) {
        Intrinsics.checkNotNullParameter((Object)markerName, (String)"markerName");
        return columnsContainer + '<' + markerName + '>';
    }

    @Override
    @NotNull
    public String renderColumnType(@NotNull BaseField $this$renderColumnType) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$renderColumnType, (String)"<this>");
        FieldType fieldType = $this$renderColumnType.getFieldType();
        if (fieldType instanceof FieldType.ValueFieldType) {
            string = dataColumn + '<' + ((FieldType.ValueFieldType)fieldType).getTypeFqName() + '>';
        } else if (fieldType instanceof FieldType.GroupFieldType) {
            string = columnGroup + '<' + ((FieldType.GroupFieldType)fieldType).getMarkerName() + '>';
        } else if (fieldType instanceof FieldType.FrameFieldType) {
            string = dataColumn + '<' + dataFrame + '<' + ((FieldType.FrameFieldType)fieldType).getMarkerName() + '>' + CodeGeneratorImplKt.access$renderNullability(((FieldType.FrameFieldType)fieldType).getNullable()) + '>';
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @Override
    @NotNull
    public String renderAccessorFieldType(@NotNull BaseField $this$renderAccessorFieldType) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$renderAccessorFieldType, (String)"<this>");
        FieldType fieldType = $this$renderAccessorFieldType.getFieldType();
        if (fieldType instanceof FieldType.ValueFieldType) {
            string = ((FieldType.ValueFieldType)fieldType).getTypeFqName();
        } else if (fieldType instanceof FieldType.GroupFieldType) {
            string = dataRow + '<' + ((FieldType.GroupFieldType)fieldType).getMarkerName() + '>';
        } else if (fieldType instanceof FieldType.FrameFieldType) {
            string = dataFrame + '<' + ((FieldType.FrameFieldType)fieldType).getMarkerName() + '>' + CodeGeneratorImplKt.access$renderNullability(((FieldType.FrameFieldType)fieldType).getNullable());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @Override
    @NotNull
    public String renderFieldType(@NotNull BaseField $this$renderFieldType) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$renderFieldType, (String)"<this>");
        FieldType fieldType = $this$renderFieldType.getFieldType();
        if (fieldType instanceof FieldType.ValueFieldType) {
            string = ((FieldType.ValueFieldType)fieldType).getTypeFqName();
        } else if (fieldType instanceof FieldType.GroupFieldType) {
            string = ((FieldType.GroupFieldType)fieldType).getRenderAsObject() ? ((FieldType.GroupFieldType)fieldType).getMarkerName() : this.renderAccessorFieldType($this$renderFieldType);
        } else if (fieldType instanceof FieldType.FrameFieldType) {
            string = ((FieldType.FrameFieldType)fieldType).getRenderAsList() ? "List<" + ((FieldType.FrameFieldType)fieldType).getMarkerName() + '>' + CodeGeneratorImplKt.access$renderNullability(((FieldType.FrameFieldType)fieldType).getNullable()) : this.renderAccessorFieldType($this$renderFieldType);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    static {
        String string = Reflection.getOrCreateKotlinClass(DataRow.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        dataRow = string;
        String string2 = Reflection.getOrCreateKotlinClass(ColumnsContainer.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string2);
        columnsContainer = string2;
        String string3 = Reflection.getOrCreateKotlinClass(DataFrame.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string3);
        dataFrame = string3;
        String string4 = Reflection.getOrCreateKotlinClass(DataColumn.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string4);
        dataColumn = string4;
        String string5 = Reflection.getOrCreateKotlinClass(ColumnGroup.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string5);
        columnGroup = string5;
    }
}

