/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataFrameKt;
import org.jetbrains.kotlinx.dataframe.DataRowKt;
import org.jetbrains.kotlinx.dataframe.annotations.AccessApiOverload;
import org.jetbrains.kotlinx.dataframe.annotations.HasSchema;
import org.jetbrains.kotlinx.dataframe.columns.ColumnKind;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnReference;
import org.jetbrains.kotlinx.dataframe.impl.DataRowImplKt;
import org.jetbrains.kotlinx.dataframe.impl.UtilsKt;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@HasSchema(schemaArg=0)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0010\u0006\n\u0002\b\u0006\bg\u0018\u0000 =*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002:\u0001=J\b\u0010\u0003\u001a\u00020\u0004H&J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H&J\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\u0004H\u00a6\u0002J^\u0010\u0007\u001a\u0002H\t\"\u0004\b\u0001\u0010\t2H\u0010\n\u001aD\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\u0000\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u0002H\t0\u000bj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\t`\u0010\u00a2\u0006\u0002\b\u000fH\u0096\u0002\u00a2\u0006\u0002\u0010\u0011J\"\u0010\u0007\u001a\u0002H\t\"\u0004\b\u0001\u0010\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\t0\u0013H\u00a7\u0002\u00a2\u0006\u0002\u0010\u0014J)\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\t0\u0015\"\u0004\b\u0001\u0010\t2\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\u00130\u0015H\u0097\u0002J\"\u0010\u0007\u001a\u0002H\t\"\u0004\b\u0001\u0010\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\t0\u0018H\u0097\u0002\u00a2\u0006\u0002\u0010\u0019JH\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010\u001a\u001a\n\u0012\u0002\b\u00030\u0013j\u0002`\u001b2\"\u0010\u001c\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0002\b\u00030\u0013j\u0002`\u001b0\u001d\"\n\u0012\u0002\b\u00030\u0013j\u0002`\u001bH\u0097\u0002\u00a2\u0006\u0002\u0010\u001eJ0\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u001a\u001a\u00020\u001f2\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\u001d\"\u00020\u001fH\u0096\u0002\u00a2\u0006\u0002\u0010 J\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010!\u001a\u00020\"H\u0096\u0002J\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u001fH\u00a6\u0002J\u0018\u0010#\u001a\n\u0012\u0002\b\u00030\u0000j\u0002`$2\u0006\u0010%\u001a\u00020\u001fH\u0016J\u0018\u0010&\u001a\n\u0012\u0002\b\u00030\u0006j\u0002`'2\u0006\u0010%\u001a\u00020\u001fH\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u001fH&J#\u0010)\u001a\u0004\u0018\u0001H\t\"\u0004\b\u0001\u0010\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\t0\u0013H'\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0015H&J&\u0010\u0007\u001a\u00020\"*\u00020\u001f2\u0012\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\u001d\"\u00020\u001fH\u0096\u0002\u00a2\u0006\u0002\u0010+J\u001e\u0010,\u001a\u0002H\t\"\u0004\b\u0001\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\u0013H\u0097\u0002\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010,\u001a\u0002H\t\"\u0004\b\u0001\u0010\t*\u00020\u001fH\u0096\u0002\u00a2\u0006\u0002\u0010-J\u0018\u0010,\u001a\u0002H\t\"\u0004\b\u0001\u0010\t*\u00020\"H\u0096\u0002\u00a2\u0006\u0002\u0010.J\u0014\u0010/\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000000H\u0016J\u0014\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000000H\u0016J0\u00102\u001a\u00020\u0004\"\u000e\b\u0001\u0010\t*\b\u0012\u0004\u0012\u0002H\t03*\b\u0012\u0004\u0012\u0002H\t0\u00132\u0006\u0010\u001c\u001a\u0002H\tH\u0096\u0002\u00a2\u0006\u0002\u00104J\u001b\u00105\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00040\u00132\u0006\u00106\u001a\u00020\u0004H\u0096\u0002J\u001b\u00105\u001a\u000207*\b\u0012\u0004\u0012\u0002070\u00132\u0006\u00106\u001a\u000207H\u0096\u0002J\u001b\u00105\u001a\u000208*\b\u0012\u0004\u0012\u0002080\u00132\u0006\u00106\u001a\u000208H\u0096\u0002J\u001b\u00105\u001a\u00020\u001f*\b\u0012\u0004\u0012\u00020\u001f0\u00132\u0006\u00106\u001a\u00020\u001fH\u0096\u0002J\u001b\u00105\u001a\u00020\u0004*\u00020\u00042\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013H\u0096\u0002J\u001b\u00105\u001a\u000207*\u0002072\f\u00109\u001a\b\u0012\u0004\u0012\u0002070\u0013H\u0096\u0002J\u001b\u00105\u001a\u000208*\u0002082\f\u00109\u001a\b\u0012\u0004\u0012\u0002080\u0013H\u0096\u0002J\u001b\u0010:\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00040\u00132\u0006\u00106\u001a\u00020\u0004H\u0096\u0002J\u001b\u0010:\u001a\u000207*\b\u0012\u0004\u0012\u0002070\u00132\u0006\u00106\u001a\u000207H\u0096\u0002J\u001b\u0010:\u001a\u000208*\b\u0012\u0004\u0012\u0002080\u00132\u0006\u00106\u001a\u000208H\u0096\u0002J\u001b\u0010:\u001a\u00020\u0004*\u00020\u00042\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013H\u0096\u0002J\u001b\u0010:\u001a\u000207*\u0002072\f\u00109\u001a\b\u0012\u0004\u0012\u0002070\u0013H\u0096\u0002J\u001b\u0010:\u001a\u000208*\u0002082\f\u00109\u001a\b\u0012\u0004\u0012\u0002080\u0013H\u0096\u0002J\u001b\u0010;\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00040\u00132\u0006\u00106\u001a\u00020\u0004H\u0096\u0002J\u001b\u0010;\u001a\u000207*\b\u0012\u0004\u0012\u0002070\u00132\u0006\u00106\u001a\u000207H\u0096\u0002J\u001b\u0010;\u001a\u000208*\b\u0012\u0004\u0012\u0002080\u00132\u0006\u00106\u001a\u000208H\u0096\u0002J\u001b\u0010;\u001a\u000208*\b\u0012\u0004\u0012\u0002080\u00132\u0006\u00106\u001a\u00020\u0004H\u0096\u0002J\u001b\u0010;\u001a\u000207*\b\u0012\u0004\u0012\u0002070\u00132\u0006\u00106\u001a\u00020\u0004H\u0096\u0002J\u001b\u0010;\u001a\u000208*\b\u0012\u0004\u0012\u0002080\u00132\u0006\u00106\u001a\u000207H\u0096\u0002J\u001b\u0010<\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00040\u00132\u0006\u00106\u001a\u00020\u0004H\u0096\u0002J\u001b\u0010<\u001a\u000207*\b\u0012\u0004\u0012\u0002070\u00132\u0006\u00106\u001a\u000207H\u0096\u0002J\u001b\u0010<\u001a\u000208*\b\u0012\u0004\u0012\u0002080\u00132\u0006\u00106\u001a\u000208H\u0096\u0002J\u001b\u0010<\u001a\u000208*\b\u0012\u0004\u0012\u0002080\u00132\u0006\u00106\u001a\u00020\u0004H\u0096\u0002J\u001b\u0010<\u001a\u000207*\b\u0012\u0004\u0012\u0002070\u00132\u0006\u00106\u001a\u00020\u0004H\u0096\u0002J\u001b\u0010<\u001a\u000208*\b\u0012\u0004\u0012\u0002080\u00132\u0006\u00106\u001a\u000207H\u0096\u0002\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006>\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlinx/dataframe/DataRow;", "T", "", "index", "", "df", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "get", "columnIndex", "R", "expression", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "it", "Lkotlin/ExtensionFunctionType;", "Lorg/jetbrains/kotlinx/dataframe/RowExpression;", "(Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "column", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;", "(Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;)Ljava/lang/Object;", "", "columns", "property", "Lkotlin/reflect/KProperty;", "(Lkotlin/reflect/KProperty;)Ljava/lang/Object;", "first", "Lorg/jetbrains/kotlinx/dataframe/AnyColumnReference;", "other", "", "(Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;[Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;)Lorg/jetbrains/kotlinx/dataframe/DataRow;", "", "(Ljava/lang/String;[Ljava/lang/String;)Lorg/jetbrains/kotlinx/dataframe/DataRow;", "path", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;", "getColumnGroup", "Lorg/jetbrains/kotlinx/dataframe/AnyRow;", "columnName", "getFrameColumn", "Lorg/jetbrains/kotlinx/dataframe/AnyFrame;", "getOrNull", "getValueOrNull", "values", "(Ljava/lang/String;[Ljava/lang/String;)Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;", "invoke", "(Ljava/lang/String;)Ljava/lang/Object;", "(Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;)Ljava/lang/Object;", "forwardIterable", "", "backwardIterable", "compareTo", "", "(Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;Ljava/lang/Comparable;)I", "plus", "a", "", "", "col", "minus", "times", "div", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nDataRow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataRow.kt\norg/jetbrains/kotlinx/dataframe/DataRow\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,165:1\n1563#2:166\n1634#2,3:167\n*S KotlinDebug\n*F\n+ 1 DataRow.kt\norg/jetbrains/kotlinx/dataframe/DataRow\n*L\n41#1:166\n41#1:167,3\n*E\n"})
public interface DataRow<T> {
    @NotNull
    public static final Companion Companion = org.jetbrains.kotlinx.dataframe.DataRow$Companion.$$INSTANCE;

    public int index();

    @NotNull
    public DataFrame<T> df();

    @Nullable
    public Object get(int var1);

    default public <R> R get(@NotNull Function2<? super DataRow<? extends T>, ? super DataRow<? extends T>, ? extends R> expression) {
        Intrinsics.checkNotNullParameter(expression, (String)"expression");
        return (R)expression.invoke((Object)this, (Object)this);
    }

    @Deprecated(message="Accessing a DataRow by ColumnReference (row[col]) is deprecated. Prefer String or extension property access (e.g., row[\"name\"] or row.name). The reverse indexing col[row] remains supported.")
    @AccessApiOverload
    public <R> R get(@NotNull ColumnReference<? extends R> var1);

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="It's recommended to migrate to the String or Extension Properties Access API https://kotlin.github.io/dataframe/apilevels.html")
    @AccessApiOverload
    @NotNull
    default public <R> List<R> get(@NotNull List<? extends ColumnReference<? extends R>> columns2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        Iterable $this$map$iv = columns2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ColumnReference columnReference = (ColumnReference)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.get((ColumnReference<? extends R>)it));
        }
        return (List)destination$iv$iv;
    }

    @Deprecated(message="It's recommended to migrate to the String or Extension Properties Access API https://kotlin.github.io/dataframe/apilevels.html")
    @AccessApiOverload
    default public <R> R get(@NotNull KProperty<? extends R> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        return (R)this.get(UtilsKt.getColumnName(property));
    }

    @Deprecated(message="It's recommended to migrate to the String or Extension Properties Access API https://kotlin.github.io/dataframe/apilevels.html")
    @AccessApiOverload
    @NotNull
    default public DataRow<T> get(@NotNull ColumnReference<?> first, ColumnReference<?> ... other) {
        Intrinsics.checkNotNullParameter(first, (String)"first");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return DataFrameKt.get(DataRowImplKt.getOwner(this), first, Arrays.copyOf(other, other.length)).get(DataRowKt.getIndex(this));
    }

    @NotNull
    default public DataRow<T> get(@NotNull String first, String ... other) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return DataFrameKt.get(DataRowImplKt.getOwner(this), first, Arrays.copyOf(other, other.length)).get(DataRowKt.getIndex(this));
    }

    @Nullable
    default public Object get(@NotNull ColumnPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return DataRowImplKt.getOwner(this).get(path).get(DataRowKt.getIndex(this));
    }

    @Nullable
    public Object get(@NotNull String var1);

    @NotNull
    default public DataRow<?> getColumnGroup(@NotNull String columnName) {
        ColumnKind kind;
        Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
        Object value = this.get(columnName);
        if (value == null && (kind = this.df().get(columnName).kind()) != ColumnKind.Group) {
            throw new IllegalStateException(("Cannot cast null value of a " + (Object)((Object)kind) + " to a " + Reflection.getOrCreateKotlinClass(DataRow.class)).toString());
        }
        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.dataframe.DataRow<*>");
        return (DataRow)value;
    }

    @NotNull
    default public DataFrame<?> getFrameColumn(@NotNull String columnName) {
        ColumnKind kind;
        Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
        Object value = this.get(columnName);
        if (value == null && (kind = this.df().get(columnName).kind()) != ColumnKind.Frame) {
            throw new IllegalStateException(("Cannot cast null value of a " + (Object)((Object)kind) + " to a " + Reflection.getOrCreateKotlinClass(DataFrame.class)).toString());
        }
        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.dataframe.DataFrame<*>");
        return (DataFrame)value;
    }

    @Nullable
    public Object getOrNull(@NotNull String var1);

    @Deprecated(message="It's recommended to migrate to the String or Extension Properties Access API https://kotlin.github.io/dataframe/apilevels.html")
    @AccessApiOverload
    @Nullable
    public <R> R getValueOrNull(@NotNull ColumnReference<? extends R> var1);

    @NotNull
    public List<Object> values();

    @NotNull
    default public ColumnPath get(@NotNull String $this$get, String ... path) {
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new ColumnPath(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)$this$get), (Object[])path));
    }

    @Deprecated(message="It's recommended to migrate to the String or Extension Properties Access API https://kotlin.github.io/dataframe/apilevels.html")
    @AccessApiOverload
    default public <R> R invoke(@NotNull ColumnReference<? extends R> $this$invoke) {
        Intrinsics.checkNotNullParameter($this$invoke, (String)"<this>");
        return this.get($this$invoke);
    }

    default public <R> R invoke(@NotNull String $this$invoke) {
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"<this>");
        return (R)this.get($this$invoke);
    }

    default public <R> R invoke(@NotNull ColumnPath $this$invoke) {
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"<this>");
        return (R)this.get($this$invoke);
    }

    @NotNull
    default public Iterable<DataRow<T>> forwardIterable() {
        return UtilsKt.toIterable(this, DataRow::forwardIterable$lambda$0);
    }

    @NotNull
    default public Iterable<DataRow<T>> backwardIterable() {
        return UtilsKt.toIterable(this, DataRow::backwardIterable$lambda$0);
    }

    default public <R extends Comparable<? super R>> int compareTo(@NotNull ColumnReference<? extends R> $this$compareTo, @NotNull R other) {
        Intrinsics.checkNotNullParameter($this$compareTo, (String)"<this>");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return ((Comparable)this.get($this$compareTo)).compareTo(other);
    }

    default public int plus(@NotNull ColumnReference<Integer> $this$plus, int a) {
        Intrinsics.checkNotNullParameter($this$plus, (String)"<this>");
        return ((Number)this.get($this$plus)).intValue() + a;
    }

    default public long plus(@NotNull ColumnReference<Long> $this$plus, long a) {
        Intrinsics.checkNotNullParameter($this$plus, (String)"<this>");
        return ((Number)this.get($this$plus)).longValue() + a;
    }

    default public double plus(@NotNull ColumnReference<Double> $this$plus, double a) {
        Intrinsics.checkNotNullParameter($this$plus, (String)"<this>");
        return ((Number)this.get($this$plus)).doubleValue() + a;
    }

    @NotNull
    default public String plus(@NotNull ColumnReference<String> $this$plus, @NotNull String a) {
        Intrinsics.checkNotNullParameter($this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        return this.get($this$plus) + a;
    }

    default public int plus(int $this$plus, @NotNull ColumnReference<Integer> col) {
        Intrinsics.checkNotNullParameter(col, (String)"col");
        return $this$plus + ((Number)this.get(col)).intValue();
    }

    default public long plus(long $this$plus, @NotNull ColumnReference<Long> col) {
        Intrinsics.checkNotNullParameter(col, (String)"col");
        return $this$plus + ((Number)this.get(col)).longValue();
    }

    default public double plus(double $this$plus, @NotNull ColumnReference<Double> col) {
        Intrinsics.checkNotNullParameter(col, (String)"col");
        return $this$plus + ((Number)this.get(col)).doubleValue();
    }

    default public int minus(@NotNull ColumnReference<Integer> $this$minus, int a) {
        Intrinsics.checkNotNullParameter($this$minus, (String)"<this>");
        return ((Number)this.get($this$minus)).intValue() - a;
    }

    default public long minus(@NotNull ColumnReference<Long> $this$minus, long a) {
        Intrinsics.checkNotNullParameter($this$minus, (String)"<this>");
        return ((Number)this.get($this$minus)).longValue() - a;
    }

    default public double minus(@NotNull ColumnReference<Double> $this$minus, double a) {
        Intrinsics.checkNotNullParameter($this$minus, (String)"<this>");
        return ((Number)this.get($this$minus)).doubleValue() - a;
    }

    default public int minus(int $this$minus, @NotNull ColumnReference<Integer> col) {
        Intrinsics.checkNotNullParameter(col, (String)"col");
        return $this$minus - ((Number)this.get(col)).intValue();
    }

    default public long minus(long $this$minus, @NotNull ColumnReference<Long> col) {
        Intrinsics.checkNotNullParameter(col, (String)"col");
        return $this$minus - ((Number)this.get(col)).longValue();
    }

    default public double minus(double $this$minus, @NotNull ColumnReference<Double> col) {
        Intrinsics.checkNotNullParameter(col, (String)"col");
        return $this$minus - ((Number)this.get(col)).doubleValue();
    }

    default public int times(@NotNull ColumnReference<Integer> $this$times, int a) {
        Intrinsics.checkNotNullParameter($this$times, (String)"<this>");
        return ((Number)this.get($this$times)).intValue() * a;
    }

    default public long times(@NotNull ColumnReference<Long> $this$times, long a) {
        Intrinsics.checkNotNullParameter($this$times, (String)"<this>");
        return ((Number)this.get($this$times)).longValue() * a;
    }

    default public double times(@NotNull ColumnReference<Double> $this$times, double a) {
        Intrinsics.checkNotNullParameter($this$times, (String)"<this>");
        return ((Number)this.get($this$times)).doubleValue() * a;
    }

    default public double times(@NotNull ColumnReference<Double> $this$times, int a) {
        Intrinsics.checkNotNullParameter($this$times, (String)"<this>");
        return ((Number)this.get($this$times)).doubleValue() * (double)a;
    }

    default public long times(@NotNull ColumnReference<Long> $this$times, int a) {
        Intrinsics.checkNotNullParameter($this$times, (String)"<this>");
        return ((Number)this.get($this$times)).longValue() * (long)a;
    }

    default public double times(@NotNull ColumnReference<Double> $this$times, long a) {
        Intrinsics.checkNotNullParameter($this$times, (String)"<this>");
        return ((Number)this.get($this$times)).doubleValue() * (double)a;
    }

    default public int div(@NotNull ColumnReference<Integer> $this$div, int a) {
        Intrinsics.checkNotNullParameter($this$div, (String)"<this>");
        return ((Number)this.get($this$div)).intValue() / a;
    }

    default public long div(@NotNull ColumnReference<Long> $this$div, long a) {
        Intrinsics.checkNotNullParameter($this$div, (String)"<this>");
        return ((Number)this.get($this$div)).longValue() / a;
    }

    default public double div(@NotNull ColumnReference<Double> $this$div, double a) {
        Intrinsics.checkNotNullParameter($this$div, (String)"<this>");
        return ((Number)this.get($this$div)).doubleValue() / a;
    }

    default public double div(@NotNull ColumnReference<Double> $this$div, int a) {
        Intrinsics.checkNotNullParameter($this$div, (String)"<this>");
        return ((Number)this.get($this$div)).doubleValue() / (double)a;
    }

    default public long div(@NotNull ColumnReference<Long> $this$div, int a) {
        Intrinsics.checkNotNullParameter($this$div, (String)"<this>");
        return ((Number)this.get($this$div)).longValue() / (long)a;
    }

    default public double div(@NotNull ColumnReference<Double> $this$div, long a) {
        Intrinsics.checkNotNullParameter($this$div, (String)"<this>");
        return ((Number)this.get($this$div)).doubleValue() / (double)a;
    }

    private static DataRow forwardIterable$lambda$0(DataRow it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return DataRowKt.getNext(it);
    }

    private static DataRow backwardIterable$lambda$0(DataRow it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return DataRowKt.getPrev(it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\n\u0012\u0002\b\u00030\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlinx/dataframe/DataRow$Companion;", "", "<init>", "()V", "empty", "Lorg/jetbrains/kotlinx/dataframe/DataRow;", "Lorg/jetbrains/kotlinx/dataframe/AnyRow;", "getEmpty", "()Lorg/jetbrains/kotlinx/dataframe/DataRow;", "core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final DataRow<?> empty;

        private Companion() {
        }

        @NotNull
        public final DataRow<?> getEmpty() {
            return empty;
        }

        static {
            $$INSTANCE = new Companion();
            empty = DataFrame.Companion.empty(1).get(0);
        }
    }
}

